/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.vms.task;

import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.SshConnectDayuServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmDeployCompleteTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmDeployCompleteTask.class);
    public static final String TASK_NAME = "vm.deploy.complete";

    public void execute() throws TaskException {
        FileOperateUtils.deleteDirectory((String)DeployDayuContext.getInstance().getUnzipTemplateFilePath());
        this.appendTaskDetail("try to connect cloud sop node.");
        RetryUtils.retry(this::getVmPingResult, (int)30, (TimeUnit)TimeUnit.MINUTES);
    }

    private Boolean getVmPingResult() {
        String cloudSopIp = DeployDayuContext.getInstance().getCloudSopIp();
        if (!IpUtils.isReachable((String)cloudSopIp)) {
            log.warn("try to ping cloudsop ip failed, ip={}.", (Object)cloudSopIp);
            return false;
        }
        try {
            SshConnectDayuServiceUtils.getShellClient();
        }
        catch (SshException e) {
            log.warn("try to connect cloudsop failed, ip={}.", (Object)cloudSopIp);
            return false;
        }
        log.info("try to connect cloudsop success, ip={}.", (Object)cloudSopIp);
        this.appendTaskDetail("connected cloud sop successfully.");
        return true;
    }

    @Generated
    protected VmDeployCompleteTask(VmDeployCompleteTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static VmDeployCompleteTaskBuilder<?, ?> builder() {
        return new VmDeployCompleteTaskBuilderImpl();
    }

    @Generated
    private static final class VmDeployCompleteTaskBuilderImpl
    extends VmDeployCompleteTaskBuilder<VmDeployCompleteTask, VmDeployCompleteTaskBuilderImpl> {
        @Generated
        private VmDeployCompleteTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected VmDeployCompleteTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VmDeployCompleteTask build() {
            return new VmDeployCompleteTask(this);
        }
    }

    @Generated
    public static abstract class VmDeployCompleteTaskBuilder<C extends VmDeployCompleteTask, B extends VmDeployCompleteTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VmDeployCompleteTask.VmDeployCompleteTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

