/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.vms.task.init;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuVmsParams;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DeployDayuVmsParamsEntity;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.TemplateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.utils.DayuResourceBundleUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.vms.task.init.DeployDayuVmsInitTask;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.vms.task.init.TemplateUzipTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcTaskService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class DeployDayuVmsInitFactory {
    private static final String DAYU_TEMPLATE_NAME = "dayuTemplate";

    public static BaseTask createDeployDayuVmsInitTask(DayuVmsParams dayuVmsParams) {
        return ((DeployDayuVmsInitTask.DeployDayuVmsInitTaskBuilder)((DeployDayuVmsInitTask.DeployDayuVmsInitTaskBuilder)((DeployDayuVmsInitTask.DeployDayuVmsInitTaskBuilder)((DeployDayuVmsInitTask.DeployDayuVmsInitTaskBuilder)((DeployDayuVmsInitTask.DeployDayuVmsInitTaskBuilder)((DeployDayuVmsInitTask.DeployDayuVmsInitTaskBuilder)DeployDayuVmsInitTask.builder().taskName(DayuResourceBundleUtils.getTaskNameFromResource("deploy.dayu.vms.init"))).taskDescription(DayuResourceBundleUtils.getCommonFromResource("detail.vm.init.task"))).duration(DayuResourceBundleUtils.getTaskDurationFromResource("deploy.dayu.vms.init"))).subTasks(DeployDayuVmsInitFactory.createSubLists(dayuVmsParams))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).eventType("dayuVmDeployEvent")).build();
    }

    private static List<BaseTask> createSubLists(DayuVmsParams dayuVmsParams) {
        ArrayList<BaseTask> taskList = new ArrayList<BaseTask>();
        taskList.addAll(Arrays.asList(DeployDayuVmsInitFactory.createEnvironmentCheck(), DeployDayuVmsInitFactory.createTemplateUzipTask(dayuVmsParams.getDayuTemplateInfo().getFilepath())));
        taskList.addAll(DeployDayuVmsInitFactory.createUploadTemplateTasks(dayuVmsParams));
        return taskList;
    }

    private static List<BaseTask> createUploadTemplateTasks(DayuVmsParams dayuVmsParams) {
        return Collections.singletonList(DeployDayuVmsInitFactory.createUploadTemplateTask(dayuVmsParams.getDayuTemplateInfo(), dayuVmsParams.toBaseFcLoginInfo()));
    }

    private static BaseTask createUploadTemplateTask(TemplateInfo templateInfo, FcLoginInfo fcLoginInfo) {
        return FcTaskService.uploadTemplateTask((UploadTemplateCmd)DeployDayuVmsInitFactory.buildDayuUploadTemplateCmd(templateInfo), (FcLoginInfo)fcLoginInfo);
    }

    private static UploadTemplateCmd buildDayuUploadTemplateCmd(TemplateInfo templateInfo) {
        return UploadTemplateCmd.builder().cnaName(templateInfo.getCnaName()).templateName(DAYU_TEMPLATE_NAME).datastoreName(templateInfo.getDatastoreName()).filePath(() -> DeployDayuContext.getInstance().getDayuTemplateVhd()).ovfFilePath(() -> DeployDayuContext.getInstance().getDayuTemplateOvf()).templateIdHandler(templateId -> DeployDayuContext.getInstance().setEDataInsightVmId((String)templateId)).build();
    }

    private static BaseTask createTemplateUzipTask(String path) {
        return ((TemplateUzipTask.TemplateUzipTaskBuilder)((Object)((TemplateUzipTask.TemplateUzipTaskBuilder)((TemplateUzipTask.TemplateUzipTaskBuilder)((TemplateUzipTask.TemplateUzipTaskBuilder)TemplateUzipTask.builder().taskName(DayuResourceBundleUtils.getTaskNameFromResource("template.unzip"))).duration(DayuResourceBundleUtils.getTaskDurationFromResource("template.unzip"))).taskDescription(DayuResourceBundleUtils.getCommonFromResource("detail.vm.unzip.template"))).dayuTempalteFilePath(path))).build();
    }

    private static BaseTask createEnvironmentCheck() {
        return FcTaskService.createEnvironmentCheckTask(DeployDayuVmsInitFactory::buildEnvironmentCmd, (FcLoginInfo)DeployDayuContext.getInstance().getDayuVmsParams().toBaseFcLoginInfo());
    }

    private static EnvironmentCheckCmd buildEnvironmentCmd() {
        EnvironmentCheckCmd environmentCheckCmd = EnvironmentCheckCmd.builder().oldVmIds(() -> DeployDayuContext.getInstance().getDeployedVmId()).build();
        DeployDayuContext.getInstance().getDayuVmsParams().getDeployDayuVmsParamsEntities().forEach(deployDayuVmsParamsEntity -> DeployDayuVmsInitFactory.computeResources(environmentCheckCmd, deployDayuVmsParamsEntity));
        return environmentCheckCmd;
    }

    private static void computeResources(EnvironmentCheckCmd environmentCheckCmd, DeployDayuVmsParamsEntity deployDayuVmsParamsEntity) {
        deployDayuVmsParamsEntity.getDiskCmds().forEach(diskCmd -> environmentCheckCmd.addDatastore(diskCmd.getDateStoreName(), diskCmd.getQuantityGB()));
        environmentCheckCmd.addMemory(deployDayuVmsParamsEntity.getCnaName(), deployDayuVmsParamsEntity.getMemorySizeGb());
        environmentCheckCmd.addCpu(deployDayuVmsParamsEntity.getCnaName(), deployDayuVmsParamsEntity.getCpuCores());
    }

    @Generated
    private DeployDayuVmsInitFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

