/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dayu.vms.task.init;

import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.DayuConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuError;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.exception.DeployDayuException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUzipTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateUzipTask.class);
    public static final String NAME_KEY = "template.unzip";
    private static final String ZIP_TOOL_PATH = FilePathValidatorUtils.joinChildPath((String[])new String[]{DayuConstant.BASE_DIR, "tools", "7z", "7z.exe"});
    private String dayuTempalteFilePath;

    public void beforeExecute() {
        this.dayuTempalteFilePath = DeployDayuContext.getInstance().getDayuVmsParams().getDayuTemplateInfo().getFilepath();
    }

    public void execute() throws TaskException {
        this.validTemplateFile(this.dayuTempalteFilePath);
        String targetUnzipFilePath = this.getTempCachePath();
        this.appendTaskDetail("start to unzip template file.");
        ZipUtils.decompressFileBy7Zip((String)ZIP_TOOL_PATH, (String)this.dayuTempalteFilePath, (String)targetUnzipFilePath);
        ZipUtils.decompressFileBy7Zip((String)ZIP_TOOL_PATH, (String)this.getDayuVmTempalteZip(targetUnzipFilePath), (String)targetUnzipFilePath);
        this.appendTaskDetail("finish to unzip template file.");
        this.updateTemplateFilePaths(targetUnzipFilePath);
    }

    private String getDayuVmTempalteZip(String targetUnzipFilePath) {
        return FileUtils.listFiles((File)new File(targetUnzipFilePath), (String[])new String[]{"zip"}, (boolean)false).stream().filter(path -> path.toString().contains("iMasterNAIE")).findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElse("");
    }

    private String getTempCachePath() {
        String templateCache = FilePathValidatorUtils.joinChildPath((String[])new String[]{DayuConstant.TEMPORARY_CACHE, StringUtils.commonFormatTimeText()});
        File file = new File(templateCache);
        if (!file.exists() && !file.mkdirs()) {
            log.error("TempCachePath create error");
            throw new DeployDayuException(DeployDayuError.UNKNOWN_ERROR);
        }
        return templateCache;
    }

    private void validTemplateFile(String templateFile) {
        File file = new File(templateFile);
        if (!file.exists()) {
            log.error("template file not exists");
            throw new DeployDayuException(DeployDayuError.TEMPLATE_FILE_NOT_EXIST);
        }
    }

    private void updateTemplateFilePaths(String templateCacheDir) {
        String vhdFile = this.getTemplateUnzipFile(templateCacheDir, "vhd");
        this.checkUnzipFinish(vhdFile);
        DeployDayuContext.getInstance().setDayuTemplateVhd(vhdFile);
        String ovfFile = this.getTemplateUnzipFile(templateCacheDir, "ovf");
        this.checkUnzipFinish(ovfFile);
        DeployDayuContext.getInstance().setDayuTemplateOvf(ovfFile);
        DeployDayuContext.getInstance().setUnzipTemplateFilePath(templateCacheDir);
    }

    private void checkUnzipFinish(String unzipFile) {
        int waitSecond = 10;
        if (StringUtils.isEmpty((CharSequence)unzipFile)) {
            log.error("unzip file not exists");
            throw new DeployDayuException(DeployDayuError.TEMPLATE_FILE_NOT_EXIST);
        }
        if (!ZipUtils.checkDecompressFileExist((String)unzipFile, (long)waitSecond, (TimeUnit)TimeUnit.SECONDS)) {
            log.error("check unzip file failed");
            throw new DeployDayuException(DeployDayuError.TEMPLATE_FILE_NOT_EXIST);
        }
    }

    private String getTemplateUnzipFile(String templateCacheDir, String fileSuffix) {
        return FileUtils.listFiles((File)new File(templateCacheDir), (String[])new String[]{fileSuffix}, (boolean)false).stream().findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElse("");
    }

    @Generated
    protected TemplateUzipTask(TemplateUzipTaskBuilder<?, ?> b) {
        super(b);
        this.dayuTempalteFilePath = ((TemplateUzipTaskBuilder)b).dayuTempalteFilePath;
    }

    @Generated
    public static TemplateUzipTaskBuilder<?, ?> builder() {
        return new TemplateUzipTaskBuilderImpl();
    }

    @Generated
    private static final class TemplateUzipTaskBuilderImpl
    extends TemplateUzipTaskBuilder<TemplateUzipTask, TemplateUzipTaskBuilderImpl> {
        @Generated
        private TemplateUzipTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateUzipTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TemplateUzipTask build() {
            return new TemplateUzipTask(this);
        }
    }

    @Generated
    public static abstract class TemplateUzipTaskBuilder<C extends TemplateUzipTask, B extends TemplateUzipTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private String dayuTempalteFilePath;

        @Generated
        public B dayuTempalteFilePath(String dayuTempalteFilePath) {
            this.dayuTempalteFilePath = dayuTempalteFilePath;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TemplateUzipTask.TemplateUzipTaskBuilder(super=" + super.toString() + ", dayuTempalteFilePath=" + this.dayuTempalteFilePath + ")";
        }
    }
}

