/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.application;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployvm.entity.TaskInfoBo;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskResult;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE, componentModel="spring", imports={NumberUtils.class})
public interface VmAssembler {
    public TaskInfoBo toBo(TaskInfo var1);

    public DeployTaskInfoVo toVo(TaskResult var1);

    @Mappings(value={@Mapping(target="taskName", source="task.name"), @Mapping(target="beginTime", source="task.startTime"), @Mapping(target="finishTime", source="task.endTime"), @Mapping(target="durationTime", expression="java(NumberUtils.parseDurationTime(task.getDurationTime()))"), @Mapping(target="suggestion", source="task.suggestMessage"), @Mapping(target="errorMsg", source="task.errorMessage"), @Mapping(target="detail", source="task.description"), @Mapping(target="eventType", expression="java(\"vmDeployEvent\")"), @Mapping(target="actions", source="task")})
    public DeployTaskDetailVo toVo(TaskInfo var1, List<TaskInfo> var2);

    public TaskInfo copy(TaskInfo var1);

    default public long localDateTimeToLong(LocalDateTime localDateTime) {
        return localDateTime == null ? 0L : localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    default public List<DeployTaskDetailVo> toDeployTaskDetailVos(List<TaskInfo> taskInfos) {
        return taskInfos.stream().map(task -> this.toVo((TaskInfo)task, Collections.emptyList())).collect(Collectors.toList());
    }

    default public List<String> toAction(TaskInfo task) {
        ArrayList<String> actions = new ArrayList<String>();
        if (task.canRetry()) {
            actions.add(TaskOperateEnum.RETRY.name());
        }
        if (task.canSkip()) {
            actions.add(TaskOperateEnum.SKIP.name());
        }
        if (task.isEnvironmentTask()) {
            actions.add(TaskOperateEnum.RESUME.name());
        }
        return actions;
    }
}

