/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.application;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployvm.entity.TaskInfoBo;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.application.VmAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskResult;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class VmAssemblerImpl
implements VmAssembler {
    @Override
    public TaskInfoBo toBo(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        TaskInfoBo.TaskInfoBoBuilder taskInfoBo = TaskInfoBo.builder();
        taskInfoBo.id(taskInfo.getId());
        taskInfoBo.parentTaskId(taskInfo.getParentTaskId());
        taskInfoBo.name(taskInfo.getName());
        taskInfoBo.description(taskInfo.getDescription());
        taskInfoBo.startTime(Long.valueOf(this.localDateTimeToLong(taskInfo.getStartTime())));
        taskInfoBo.endTime(Long.valueOf(this.localDateTimeToLong(taskInfo.getEndTime())));
        if (taskInfo.getState() != null) {
            taskInfoBo.state(taskInfo.getState().name());
        }
        taskInfoBo.suggestMessage(taskInfo.getSuggestMessage());
        taskInfoBo.errorMessage(taskInfo.getErrorMessage());
        return taskInfoBo.build();
    }

    @Override
    public DeployTaskInfoVo toVo(TaskResult taskResult) {
        if (taskResult == null) {
            return null;
        }
        DeployTaskInfoVo.DeployTaskInfoVoBuilder deployTaskInfoVo = DeployTaskInfoVo.builder();
        if (taskResult.getState() != null) {
            deployTaskInfoVo.state(taskResult.getState().name());
        }
        deployTaskInfoVo.beginTime(Long.valueOf(this.localDateTimeToLong(taskResult.getBeginTime())));
        deployTaskInfoVo.finishTime(Long.valueOf(this.localDateTimeToLong(taskResult.getFinishTime())));
        return deployTaskInfoVo.build();
    }

    @Override
    public DeployTaskDetailVo toVo(TaskInfo task, List<TaskInfo> children) {
        if (task == null && children == null) {
            return null;
        }
        DeployTaskDetailVo.DeployTaskDetailVoBuilder deployTaskDetailVo = DeployTaskDetailVo.builder();
        if (task != null) {
            deployTaskDetailVo.taskName(task.getName());
            deployTaskDetailVo.beginTime(Long.valueOf(this.localDateTimeToLong(task.getStartTime())));
            deployTaskDetailVo.finishTime(Long.valueOf(this.localDateTimeToLong(task.getEndTime())));
            deployTaskDetailVo.suggestion(task.getSuggestMessage());
            deployTaskDetailVo.errorMsg(task.getErrorMessage());
            deployTaskDetailVo.detail(task.getDescription());
            deployTaskDetailVo.actions(this.toAction(task));
            deployTaskDetailVo.id(task.getId());
            if (task.getState() != null) {
                deployTaskDetailVo.state(task.getState().name());
            }
            deployTaskDetailVo.skipMsg(task.getSkipMsg());
        }
        deployTaskDetailVo.children(this.toDeployTaskDetailVos(children));
        deployTaskDetailVo.durationTime(NumberUtils.parseDurationTime((int)task.getDurationTime()));
        deployTaskDetailVo.eventType("vmDeployEvent");
        return deployTaskDetailVo.build();
    }

    @Override
    public TaskInfo copy(TaskInfo task) {
        if (task == null) {
            return null;
        }
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(task.getId());
        taskInfo.setParentTaskId(task.getParentTaskId());
        taskInfo.setName(task.getName());
        taskInfo.setDescription(task.getDescription());
        taskInfo.setStartTime(task.getStartTime());
        taskInfo.setEndTime(task.getEndTime());
        taskInfo.setDurationTime(task.getDurationTime());
        taskInfo.setState(task.getState());
        taskInfo.setSuggestMessage(task.getSuggestMessage());
        taskInfo.setErrorMessage(task.getErrorMessage());
        taskInfo.setSkipMsg(task.getSkipMsg());
        taskInfo.setVmsId(task.getVmsId());
        taskInfo.setFileId(task.getFileId());
        taskInfo.setImageFile(task.getImageFile());
        taskInfo.setRetry(task.isRetry());
        return taskInfo;
    }
}

