/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.application;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.rest.entity.Result;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.ParamTemplateBo;
import com.huawei.yinglong.river.deploy.virtualization.deployvm.entity.TaskInfoBoList;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageUpdate;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.application.VmAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.CacheProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.VmFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.VmProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.NodeCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.State;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.VmConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmNode;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.VmException;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.ExecutorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.ResultUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmConfigUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VmDeployFitImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmDeployFitImpl.class);
    private final VmAssembler assembler;
    private final CacheProvider cacheProvider;
    private final VmFactory vmFactory;
    private final VmProvider vmProvider;

    public List<ParamTemplateBo> getVmParamTemplates() {
        return this.cacheProvider.getParamTemplateBoList();
    }

    public Result validParam(VmParam vmParam) {
        String errorMessage = this.vmFactory.validParam(vmParam);
        return StringUtils.isEmpty((CharSequence)errorMessage) ? ResultUtils.success() : ResultUtils.failed(errorMessage);
    }

    public Response<TaskInfoBoList> getTaskProgress() {
        List infoBoList = this.cacheProvider.getTaskInfoList().stream().map(this.assembler::toBo).collect(Collectors.toList());
        return ResponseUtils.success((Object)TaskInfoBoList.builder().taskInfoBo(infoBoList).build());
    }

    public Response<DeployTaskInfoVo> queryDeployDetails(String taskId) {
        DeployTaskInfoVo deployTaskInfoVo = this.assembler.toVo(this.cacheProvider.getTaskResult());
        this.fillTaskChildren(deployTaskInfoVo);
        return ResponseUtils.success((Object)deployTaskInfoVo);
    }

    private void fillTaskChildren(DeployTaskInfoVo deployTaskInfoVo) {
        List<TaskInfo> parentTasks = this.cacheProvider.getParentTasks();
        List<TaskInfo> taskInfos = this.cacheProvider.getTaskInfoList();
        deployTaskInfoVo.setChildren(parentTasks.stream().map(parentTask -> this.assembler.toVo((TaskInfo)parentTask, taskInfos.stream().filter(task -> Objects.equals(parentTask.getId(), task.getParentTaskId())).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    public synchronized Result start(VmParam vmParam) {
        this.cacheProvider.getTaskInfoList().forEach(taskInfo -> taskInfo.init(true));
        this.cacheProvider.setEnvironmentCheckRequired(true);
        ExecutorUtils.execute(() -> this.startVmDeploy(vmParam, Collections.emptyList(), Collections.emptyList()));
        return ResultUtils.success();
    }

    public void updateParam(VmParam vmParam) {
        try {
            this.vmFactory.validParam(vmParam);
            this.cacheProvider.resetCache(vmParam);
        }
        catch (VmException e) {
            log.error("updateParam error", (Throwable)e);
        }
    }

    public Response<Boolean> retryAll() {
        if (this.cacheProvider.isTaskRunning() || !this.cacheProvider.isTaskError() && !this.cacheProvider.isTaskPause()) {
            return ResponseUtils.failed((ErrorDetail)new VmException(CustomError.STATE_ERROR));
        }
        List<TaskInfo> failedParentTask = this.cacheProvider.getParentTasks().stream().filter(task -> task.getState().isError()).collect(Collectors.toList());
        List cleanVmIndex = failedParentTask.stream().map(TaskInfo::getTaskNodeIndex).filter(index -> index > 0).collect(Collectors.toList());
        List failedVmIndex = this.cacheProvider.getLastTaskInfoList().stream().filter(TaskInfo::isParentTask).filter(taskInfo -> !taskInfo.isEnvironmentTask()).filter(taskInfo -> taskInfo.getState().isError()).map(TaskInfo::getTaskNodeIndex).collect(Collectors.toList());
        log.info("retry all task, clean vm index : {}, failed vm index : {}.", cleanVmIndex, failedVmIndex);
        failedParentTask.forEach(failedTask -> this.cacheProvider.initTaskWithParentAndChildren(failedTask.getId()));
        ExecutorUtils.execute(() -> this.startVmDeploy(this.cacheProvider.getVmParam(), failedVmIndex, cleanVmIndex));
        return ResponseUtils.success();
    }

    public Response<Boolean> skipItem(String itemId) {
        try {
            TaskInfo task = this.cacheProvider.getTaskById(itemId);
            if (!task.canSkip() || !task.getState().isError()) {
                throw new VmException(CustomError.STATE_ERROR);
            }
            log.info("skip item id : {}.", (Object)itemId);
            task.setState(State.SKIP);
            this.cacheProvider.getTaskById(task.getParentTaskId()).retry();
            ExecutorUtils.execute(() -> this.deployNodeOf(task.getTaskNodeIndex(), true));
            return ResponseUtils.success();
        }
        catch (VmException e) {
            return ResponseUtils.failed((ErrorDetail)e);
        }
    }

    public Response<Boolean> retryItem(String itemId) {
        try {
            TaskInfo taskInfo = this.cacheProvider.getTaskById(itemId);
            if (!taskInfo.getState().isError() && !taskInfo.getState().isPause()) {
                throw new VmException(CustomError.STATE_ERROR);
            }
            log.info("retry item id : {}.", (Object)itemId);
            this.cacheProvider.initTaskWithParentAndChildren(itemId);
            if (taskInfo.isEnvironmentTask()) {
                ExecutorUtils.execute(() -> this.startVmDeploy(this.cacheProvider.getVmParam(), Collections.emptyList(), Collections.emptyList()));
                return ResponseUtils.success();
            }
            ExecutorUtils.execute(() -> this.deployNodeOf(taskInfo.getTaskNodeIndex(), !taskInfo.isParentTask()));
            return ResponseUtils.success();
        }
        catch (VmException e) {
            return ResponseUtils.failed((ErrorDetail)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deployNodeOf(int index, boolean isUseCacheNode) {
        try {
            this.cacheProvider.setFailedVmIndex(Collections.singletonList(index));
            if (!isUseCacheNode) {
                this.cacheProvider.setVmIndex(Collections.singletonList(index));
            }
            VmParam vmParam = this.cacheProvider.getVmParam();
            List<NodeCreate> nodeCreates = isUseCacheNode ? new ArrayList<NodeCreate>(this.cacheProvider.getNodeCreateMaps().values()) : this.vmFactory.generateNodeCreate(this.cacheProvider.getApiServiceClient(), vmParam);
            this.cacheProvider.updateNodeCreateMaps(nodeCreates);
            nodeCreates.stream().filter(nodeCreate -> nodeCreate.getIndex() == index).findFirst().ifPresent(nodeCreate -> this.deployNode(vmParam, (NodeCreate)nodeCreate));
        }
        catch (Exception e) {
            log.error("deploy node failed.", (Throwable)e);
            this.cacheProvider.restoreTask();
        }
        finally {
            this.cacheProvider.clearThreadLocal();
        }
    }

    private boolean checkVmNodeDatastore(VmParam vmParam) {
        boolean isSkip = VmConfigUtils.isSkipSelectDatastore();
        log.info("deploy vm skip select datastore : {}.", (Object)isSkip);
        return isSkip || vmParam.getVmNode().stream().filter(VmNode::isDeploy).allMatch(vmNode -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{vmNode.getDatastoreSystemName(), vmNode.getDatastoreDataName()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startVmDeploy(VmParam vmParam, List<Integer> failedVmIndex, List<Integer> vmIndex) {
        List<NodeCreate> nodeCreateList;
        this.cacheProvider.setFailedVmIndex(failedVmIndex);
        this.cacheProvider.setVmIndex(vmIndex);
        TaskInfo environmentTask = this.cacheProvider.getTaskById("check_environment");
        environmentTask.tryStart();
        try {
            this.vmFactory.validParam(vmParam);
            this.cacheProvider.resetCache(vmParam);
            this.cacheProvider.clearNodeCreateMaps();
            if (!this.checkVmNodeDatastore(vmParam)) {
                log.warn("find some vm node not found datastore names.");
                environmentTask.setDescription(VmException.getSuggestMessage(ApiError.CONFIG_DATASTORE_DETAIL));
                environmentTask.pause();
                return;
            }
            environmentTask.setDescription(VmException.getSuggestMessage(ApiError.ENVIRONMENT_DETAIL));
            nodeCreateList = this.vmFactory.generateNodeCreate(this.cacheProvider.getApiServiceClient(), vmParam);
            environmentTask.success();
            this.cacheProvider.updateNodeCreateMaps(nodeCreateList);
            this.checkCpuAndMemory(nodeCreateList, vmParam);
            nodeCreateList.stream().map(NodeCreate::getSiteId).filter(StringUtils::isNotEmpty).findFirst().ifPresent(this.vmProvider::createAlarmThresholdRule);
        }
        catch (Exception e) {
            environmentTask.fail(e);
            return;
        }
        finally {
            this.cacheProvider.clearThreadLocal();
        }
        nodeCreateList.forEach(nodeCreate -> ExecutorUtils.execute(() -> this.deployNode(vmParam, (NodeCreate)nodeCreate)));
    }

    void checkCpuAndMemory(List<NodeCreate> nodeCreateList, VmParam vmParam) {
        HashMap nodeCpuMap = new HashMap();
        HashMap nodeMemoryMap = new HashMap();
        vmParam.getVmNode().forEach(vmNode -> this.fillNodeMap((VmNode)vmNode, nodeCpuMap, nodeMemoryMap));
        boolean isCpuInsufficient = nodeCreateList.stream().anyMatch(nodeCreate -> !nodeCreate.getHost().isCpuInsufficient((Integer)nodeCpuMap.get(nodeCreate.getHost().getName())));
        if (isCpuInsufficient) {
            throw new VmException(ApiError.CPU_INSUFFICIENT);
        }
        boolean isMemoryInsufficient = nodeCreateList.stream().anyMatch(nodeCreate -> !nodeCreate.getHost().isMemoryInsufficient((Integer)nodeMemoryMap.get(nodeCreate.getHost().getName())));
        if (isMemoryInsufficient) {
            throw new VmException(ApiError.MEMORY_INSUFFICIENT);
        }
    }

    private void fillNodeMap(VmNode vmNode, Map<String, Integer> nodeCpuMap, Map<String, Integer> nodeMemoryMap) {
        int cpuOfCna = nodeCpuMap.getOrDefault(vmNode.getCnaName(), 0);
        int memoryOfCna = nodeMemoryMap.getOrDefault(vmNode.getCnaName(), 0);
        nodeCpuMap.put(vmNode.getCnaName(), cpuOfCna += VmConfigUtils.getDefaultCpu(vmNode.getType(), vmNode.getManagementLevel()));
        nodeMemoryMap.put(vmNode.getCnaName(), memoryOfCna += VmConfigUtils.getDefaultMemoryGb(vmNode.getType(), vmNode.getManagementLevel()));
    }

    private void deployNode(VmParam vmParam, NodeCreate nodeCreate) {
        TaskInfo nodeTask = this.cacheProvider.getTaskById("node" + nodeCreate.getIndex());
        if (!nodeTask.tryStart()) {
            return;
        }
        if (!this.isCreateVmSuccess(nodeCreate, nodeTask)) {
            return;
        }
        TaskInfo imageTask = this.cacheProvider.getTaskById("node_update_iso" + nodeCreate.getIndex());
        if (imageTask.tryStart() && !this.isUpdateImageSuccess(vmParam, nodeCreate, imageTask)) {
            nodeTask.fail();
            return;
        }
        File file = imageTask.getImageFile();
        if (!this.isUploadImageSuccess(nodeCreate, file)) {
            nodeTask.fail();
            return;
        }
        if (!this.isAttachImageSuccess(nodeCreate, file.getName())) {
            nodeTask.fail();
            return;
        }
        if (!this.isInstallOsSuccess(nodeCreate)) {
            nodeTask.fail();
            return;
        }
        if (!this.isInstallVmTools(nodeCreate)) {
            nodeTask.fail();
            return;
        }
        if (this.isDeployContainerClusterService(nodeCreate.getVmNode().getType()) && !this.isMountingNics(nodeCreate)) {
            nodeTask.fail();
            return;
        }
        nodeTask.success();
        ExecutorUtils.execute(() -> this.cleanEnvironment(nodeCreate));
    }

    boolean isInstallVmTools(NodeCreate nodeCreate) {
        TaskInfo installToolsTask = this.cacheProvider.getTaskById("node_install_vmtools" + nodeCreate.getIndex());
        if (!installToolsTask.tryStart()) {
            return true;
        }
        try {
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.MINUTES);
            this.vmProvider.installVmTools(nodeCreate);
            installToolsTask.success();
            return true;
        }
        catch (VmException e) {
            installToolsTask.fail(e);
            log.error("install vm tools vmException failed.", (Throwable)e);
        }
        catch (Exception e) {
            installToolsTask.fail(e);
            log.error("install vm tools Exception failed.", (Throwable)e);
        }
        return false;
    }

    boolean isMountingNics(NodeCreate nodeCreate) {
        TaskInfo mountingNicsTask = this.cacheProvider.getTaskById("mounting_nics" + nodeCreate.getIndex());
        if (!mountingNicsTask.tryStart()) {
            return true;
        }
        try {
            this.vmProvider.mountingNics(nodeCreate);
            mountingNicsTask.success();
            return true;
        }
        catch (Exception exception) {
            mountingNicsTask.fail(exception);
            return false;
        }
    }

    boolean isDeployContainerClusterService(int index) {
        return index == 2;
    }

    private void cleanEnvironment(NodeCreate nodeCreate) {
        this.vmProvider.detachImage(nodeCreate);
        TaskInfo uploadImageTask = this.cacheProvider.getTaskById("node_upload_iso" + nodeCreate.getIndex());
        if (uploadImageTask.getFileId() > 0) {
            this.vmProvider.deleteFile(uploadImageTask.getFileId(), nodeCreate);
        }
    }

    private boolean isUpdateImageSuccess(VmParam vmParam, NodeCreate nodeCreate, TaskInfo imageTask) {
        try {
            String originName = new File(vmParam.getImagePath()).getName();
            VmNode vmNode = nodeCreate.getVmNode();
            ImageUpdate imageUpdate = this.vmFactory.generateImageUpdate(vmParam, originName, vmNode);
            Optional<File> imageFile = this.vmProvider.updateImage(imageUpdate);
            if (!imageFile.isPresent()) {
                throw new VmException(ApiError.UPDATE_IMAGE_FAILED);
            }
            imageTask.success();
            imageTask.setImageFile(imageFile.get());
            return true;
        }
        catch (Exception exception) {
            imageTask.fail(exception);
            return false;
        }
    }

    private boolean isInstallOsSuccess(NodeCreate nodeCreate) {
        TaskInfo installOsTask = this.cacheProvider.getTaskById("node_install_os" + nodeCreate.getIndex());
        if (!installOsTask.tryStart()) {
            return true;
        }
        ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.MINUTES);
        try {
            this.vmProvider.installVmOs(nodeCreate);
            installOsTask.success();
            return true;
        }
        catch (Exception exception) {
            installOsTask.fail(exception);
            return false;
        }
    }

    private boolean isAttachImageSuccess(NodeCreate nodeCreate, String fileName) {
        TaskInfo attachImageTask = this.cacheProvider.getTaskById("node_attach_iso" + nodeCreate.getIndex());
        if (!attachImageTask.tryStart()) {
            return true;
        }
        try {
            this.vmProvider.attachImage(fileName, nodeCreate);
            attachImageTask.success();
            return true;
        }
        catch (Exception exception) {
            attachImageTask.fail(exception);
            return false;
        }
    }

    private boolean isUploadImageSuccess(NodeCreate nodeCreate, File file) {
        TaskInfo uploadImageTask = this.cacheProvider.getTaskById("node_upload_iso" + nodeCreate.getIndex());
        if (!uploadImageTask.tryStart()) {
            return true;
        }
        try {
            int fileId = this.vmProvider.uploadImage(file, nodeCreate);
            log.info("upload image success file Id:{}.", (Object)fileId);
            uploadImageTask.setFileId(fileId);
            uploadImageTask.success();
            return true;
        }
        catch (Exception exception) {
            uploadImageTask.fail(exception);
            return false;
        }
    }

    private boolean isCreateVmSuccess(NodeCreate nodeCreate, TaskInfo nodeTask) {
        TaskInfo vmTask = this.cacheProvider.getTaskById("node_vm" + nodeCreate.getIndex());
        nodeCreate.setVmsId(vmTask.getVmsId());
        log.info("create vm task info : {}, {}.", (Object)vmTask.getVmsId(), (Object)vmTask.getId());
        if (!vmTask.tryStart()) {
            return true;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)vmTask.getVmsId())) {
                this.vmProvider.deleteVm(nodeCreate.getSiteId(), vmTask.getVmsId());
            }
            VmConfig nodeConfig = this.vmFactory.createVmConfig(nodeCreate);
            String vmsId = this.vmProvider.createVm(nodeCreate.getSiteId(), nodeConfig);
            log.info("create vm result : {}, {}", (Object)vmsId, (Object)vmTask.getId());
            nodeCreate.setVmsId(vmsId);
            vmTask.setVmsId(vmsId);
            this.tryBindAlarmThreshold(nodeCreate.getSiteId(), vmsId);
            vmTask.success();
            return true;
        }
        catch (Exception exception) {
            vmTask.fail(exception);
            nodeTask.fail(exception);
            return false;
        }
    }

    void tryBindAlarmThreshold(String siteId, String vmsId) {
        String vmsUrn = StringUtils.formatTxt((String)"urn:sites:%s:vms:%s", (Object[])new Object[]{siteId, vmsId});
        try {
            log.info("try to bind cpu alarm threshold.");
            this.vmProvider.bindAlarmThresholdRule(siteId, "eDME_CPU_ALARM_85", vmsUrn);
        }
        catch (VmException e) {
            log.error("try to bind cpu alarm threshold failed.");
        }
        try {
            log.info("try to bind memery alarm threshold.");
            this.vmProvider.bindAlarmThresholdRule(siteId, "eDME_MEMERY_ALARM_90", vmsUrn);
        }
        catch (VmException e) {
            log.error("try to bind memery alarm threshold failed.");
        }
    }

    @Generated
    public VmDeployFitImpl(VmAssembler assembler, CacheProvider cacheProvider, VmFactory vmFactory, VmProvider vmProvider) {
        this.assembler = assembler;
        this.cacheProvider = cacheProvider;
        this.vmFactory = vmFactory;
        this.vmProvider = vmProvider;
    }
}

