/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.domain;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdRule;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdRuleBind;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.VmRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.alarm.AlarmThresholdRuleList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.DataStoreResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.DatastoreUrns;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.dvswitch.DvSwitches;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.host.HostList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.image.AttachImage;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.image.ImageFileList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.os.OsVersions;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.protgroup.PortGroups;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.reboot.Reboot;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.site.SiteList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.task.SimpleTask;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.task.Task;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.upload.ApplyResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.upload.UploadResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.VmBootOption;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.VmConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.response.VmTaskResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VirtualNicsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.VmException;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.fun.QueryWithException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class ApiServiceClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiServiceClient.class);
    private static final String TOKEN_KEY = "X-Auth-Token";
    private final VmRequestApi vmRequestApi;

    private <T> Optional<T> queryWithHandler(QueryWithException<Call<T>, ?> queryWithException) {
        try {
            return Optional.of(queryWithException.query().execute()).map(VmRequestUtils::dealResponse);
        }
        catch (VmException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new VmException(ApiError.DATA_ERROR);
        }
    }

    public Optional<String> login(String user, String password, int userType) {
        try {
            Response response = this.vmRequestApi.login(VmRequestUtils.buildLoginHeaders(user, password, userType)).execute();
            VmRequestUtils.dealResponse(response);
            return Optional.ofNullable(response.headers().get(TOKEN_KEY));
        }
        catch (IOException exception) {
            log.error("login error", (Throwable)exception);
            throw new VmException(ApiError.LOGIN_FAIL);
        }
    }

    public Optional<SiteList> getSites() {
        return this.queryWithHandler(() -> this.vmRequestApi.getSites(this.buildHeaders()));
    }

    public Optional<HostList> getHosts(String siteId) {
        return this.queryWithHandler(() -> this.vmRequestApi.getHosts(this.buildHeaders(), siteId));
    }

    public Optional<DataStoreResponse> getDataStores(String siteId, String hostUrn) {
        return this.queryWithHandler(() -> this.vmRequestApi.getDataStores(this.buildHeaders(), siteId, VmRequestUtils.buildQueryDataStoreMap(hostUrn)));
    }

    public Optional<SimpleTask> refreshDataStores(String siteId, List<String> datastoreUrns) {
        return this.queryWithHandler(() -> this.vmRequestApi.refreshDataStores(this.buildHeaders(), siteId, new DatastoreUrns(datastoreUrns)));
    }

    public Optional<OsVersions> getOsVersions(String siteId, String arch, String cpuVendor) {
        return this.queryWithHandler(() -> this.vmRequestApi.getOsVersions(this.buildHeaders(), siteId, VmRequestUtils.buildOsMap(arch, cpuVendor)));
    }

    public Optional<DvSwitches> getDvSwitches(String siteId) {
        return this.queryWithHandler(() -> this.vmRequestApi.getDvSwitches(this.buildHeaders(), siteId));
    }

    public Optional<PortGroups> getPortGroups(String siteId, String dvSwitchId) {
        return this.queryWithHandler(() -> this.vmRequestApi.getPortGroups(this.buildHeaders(), siteId, dvSwitchId));
    }

    public Optional<VmTaskResponse> createVm(String siteId, VmConfig vmConfig) {
        return this.queryWithHandler(() -> this.vmRequestApi.createVm(this.buildHeaders(), siteId, vmConfig));
    }

    public Optional<Task> getTaskById(String siteId, String taskId) {
        return this.queryWithHandler(() -> this.vmRequestApi.getTaskById(this.buildHeaders(), siteId, taskId));
    }

    public Optional<ImageFileList> getImageFileList(String siteId, String diskId) {
        return this.queryWithHandler(() -> this.vmRequestApi.getImageFileList(this.buildHeaders(), siteId, diskId, VmRequestUtils.buildImageMap()));
    }

    public Optional<SimpleTask> attachImage(String siteId, String vmsId, AttachImage attachImage) {
        return this.queryWithHandler(() -> this.vmRequestApi.attachImage(this.buildHeaders(), siteId, vmsId, attachImage));
    }

    public Optional<SimpleTask> updateImageProperty(String siteId, String vmsId, VmBootOption bootOption) {
        return this.queryWithHandler(() -> this.vmRequestApi.updateVmProperty(this.buildHeaders(), siteId, vmsId, bootOption));
    }

    public Optional<SimpleTask> rebootVm(String siteId, String vmsId, Reboot reboot) {
        return this.queryWithHandler(() -> this.vmRequestApi.rebootVm(this.buildHeaders(), siteId, vmsId, reboot));
    }

    public Optional<ApplyResponse> applyUpload(String siteId, String diskId, Map<String, String> queryMap) {
        return this.queryWithHandler(() -> this.vmRequestApi.applyUpload(this.buildHeaders(), siteId, diskId, queryMap));
    }

    public void authCna(String url) {
        if (StringUtils.isEmpty(url)) {
            return;
        }
        try {
            log.info("auth cna");
            Response response = this.vmRequestApi.authCna(url).execute();
            if (response.isSuccessful()) {
                return;
            }
            if (response.errorBody() != null) {
                log.error("auth cna fail " + response.errorBody().string());
            }
            throw new VmException(ApiError.CNA_AUTH_FAIL);
        }
        catch (IOException exception) {
            log.error("auth cna fail", (Throwable)exception);
            throw new VmException(ApiError.CNA_AUTH_FAIL);
        }
    }

    public Optional<UploadResponse> getStreamUpload(ApplyResponse applyResponse, Map<String, String> queryMap) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X_UPLOAD_ACCESS", applyResponse.getToken());
        return this.queryWithHandler(() -> this.vmRequestApi.getStreamUpload(headers, applyResponse.getUploadURL(), queryMap));
    }

    public Optional<UploadResponse> postStreamUpload(Map<String, String> headers, String url, byte[] slice, Map<String, String> queryMap) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])slice);
        return this.queryWithHandler(() -> this.vmRequestApi.postStreamUpload(headers, url, requestBody, queryMap));
    }

    public Optional<SimpleTask> deleteVm(String siteId, String vmsId) {
        return this.queryWithHandler(() -> this.vmRequestApi.deleteVm(this.buildHeaders(), siteId, vmsId));
    }

    public Optional<SimpleTask> detachImage(String siteId, String vmsId) {
        return this.queryWithHandler(() -> this.vmRequestApi.detachImage(this.buildHeaders(), siteId, vmsId));
    }

    public void deleteFile(String siteId, String datastoreId, int fileId) {
        this.queryWithHandler(() -> this.vmRequestApi.deleteFile(this.buildHeaders(), siteId, datastoreId, fileId));
    }

    public Optional<AlarmThresholdRuleList> queryAlarmThresholdRule(String siteId, AlarmThresholdQuery query) {
        return this.queryWithHandler(() -> this.vmRequestApi.queryAlarmThresholdRule(this.buildHeaders(), siteId, query.toMap()));
    }

    public void addAlarmThresholdRule(String siteId, AlarmThresholdRule thresholdRule) {
        this.queryWithHandler(() -> this.vmRequestApi.addAlarmThresholdRule(this.buildHeaders(), siteId, thresholdRule));
    }

    public void bindAlarmThresholdRule(String siteId, AlarmThresholdRuleBind ruleBind) {
        this.queryWithHandler(() -> this.vmRequestApi.bindAlarmThresholdRule(this.buildHeaders(), siteId, ruleBind));
    }

    public Optional<SimpleTask> addVirtualNics(String siteId, String vmsId, VirtualNicsParam virtualNicsParam) {
        return this.queryWithHandler(() -> this.vmRequestApi.addVirtualNics(this.buildHeaders(), siteId, vmsId, virtualNicsParam));
    }

    public Optional<SimpleTask> installTools(String siteId, String vmsId) {
        return this.queryWithHandler(() -> this.vmRequestApi.installTools(this.buildHeaders(), siteId, vmsId));
    }

    public Optional<SimpleTask> uninstallTools(String siteId, String vmsId) {
        return this.queryWithHandler(() -> this.vmRequestApi.uninstallTools(this.buildHeaders(), siteId, vmsId));
    }

    public Optional<VmDetail> getVmInfo(String siteId, String vmsId) {
        return this.queryWithHandler(() -> this.vmRequestApi.getVmInfo(this.buildHeaders(), siteId, vmsId));
    }

    private Map<String, String> buildHeaders() {
        return Collections.emptyMap();
    }

    @Generated
    public ApiServiceClient(VmRequestApi vmRequestApi) {
        this.vmRequestApi = vmRequestApi;
    }
}

