/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.domain;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.ParamTemplateBo;
import com.huawei.yinglong.river.deploy.virtualization.deployvm.entity.FcInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.FcRequestInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.FcRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.entry.VerifySwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.application.VmAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.ApiServiceClient;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.NodeCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.State;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.VmRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.VmException;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.ExecutorUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import okhttp3.Interceptor;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheProvider.class);
    private final VmAssembler vmAssembler;
    private final ThreadLocal<List<Integer>> vmIndex = new ThreadLocal();
    private final ThreadLocal<List<Integer>> failedVmIndex = new ThreadLocal();
    private final ConcurrentHashMap<Integer, NodeCreate> nodeCreateMaps = new ConcurrentHashMap();
    private String token;
    private List<TaskInfo> taskInfoList;
    private List<TaskInfo> lastTaskInfoList;
    private List<ParamTemplateBo> paramTemplateBoList;
    private FcRequestClient fcRequestClient;
    private Optional<VerifySwitch> opVerifySwitch = Optional.empty();
    private ApiServiceClient apiServiceClient;
    private VmParam vmParam;
    private boolean isTenant;
    private boolean isContainerClusterService;
    private boolean isDcsas;
    private boolean isEnvironmentCheckRequired;

    public void setVmIndex(List<Integer> vmIdxs) {
        this.vmIndex.set(vmIdxs);
    }

    public void setFailedVmIndex(List<Integer> failedVmIdxs) {
        this.failedVmIndex.set(failedVmIdxs);
    }

    public void clearThreadLocal() {
        this.vmIndex.remove();
        this.failedVmIndex.remove();
    }

    public ApiServiceClient getApiServiceClient() {
        if (this.apiServiceClient == null) {
            VmRequestApi requestApi = this.createApiService(this.vmParam.getFcInfo());
            this.apiServiceClient = new ApiServiceClient(requestApi);
        }
        return this.apiServiceClient;
    }

    private VmRequestApi createApiService(FcInfo fcInfo) {
        String url = Optional.ofNullable(fcInfo).map(FcInfo::getUrl).orElse("");
        if (com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.StringUtils.isEmpty(url)) {
            throw new VmException(CustomError.PARAM_REQUIRED);
        }
        return (VmRequestApi)HttpRequestApiFactory.createRequestApi((String)FcRequestUtils.toFcUrl((String)url), VmRequestApi.class, (Interceptor[])new Interceptor[]{new FcRequestInterceptor(() -> this.getToken(fcInfo))});
    }

    private String getToken(FcInfo fcInfo) {
        try {
            return this.updateAndGetToken(fcInfo);
        }
        catch (VmException e) {
            log.error("Failed to get token.", (Throwable)e);
            return "";
        }
    }

    public TaskInfo getTaskById(String taskId) {
        return this.taskInfoList.stream().filter(taskInfo -> taskId.equals(taskInfo.getId())).findFirst().orElseThrow(VmException.thr(ApiError.DATA_ERROR));
    }

    public void resetCache(VmParam vmParam) {
        log.info("resetCache");
        this.vmParam = vmParam;
        this.apiServiceClient = null;
        FcInfo fcInfo = vmParam.getFcInfo();
        this.isTenant = vmParam.getVmNode().stream().anyMatch(vmNode -> vmNode.isDeploy() && vmNode.getType() == 1);
        this.isContainerClusterService = vmParam.getVmNode().stream().anyMatch(vmNode -> vmNode.isDeploy() && vmNode.getType() == 2);
        this.isDcsas = vmParam.getVmNode().stream().anyMatch(vmNode -> vmNode.isDeploy() && vmNode.getType() == 3);
        this.closeIsolationSwitch(fcInfo);
        this.updateAndGetToken(fcInfo);
    }

    public String updateAndGetToken(FcInfo fcInfo) {
        this.token = this.getApiServiceClient().login(fcInfo.getUser(), fcInfo.getPassword(), fcInfo.getUserType()).orElseThrow(VmException.thr(ApiError.LOGIN_FAIL));
        return this.token;
    }

    @PostConstruct
    public void init() {
        try {
            String taskStr = IOUtils.resourceToString((String)(LanguageUtils.getCurrentLanguage().isZh() ? "/taskinfo_cn.json" : "/taskinfo_en.json"), (Charset)StandardCharsets.UTF_8);
            this.taskInfoList = JSON.parseArray((String)taskStr, TaskInfo.class);
            String templateStr = IOUtils.resourceToString((String)"/vmTemplate.json", (Charset)StandardCharsets.UTF_8);
            this.paramTemplateBoList = JSON.parseArray((String)templateStr, ParamTemplateBo.class);
        }
        catch (IOException exception) {
            log.error("init fail!", (Throwable)exception);
        }
    }

    public boolean isTaskRunning() {
        return this.taskInfoList.stream().anyMatch(taskInfo -> taskInfo.getState().isRunning());
    }

    void closeIsolationSwitch(FcInfo fcInfo) {
        if (fcInfo.getUserType() == 0) {
            this.fcRequestClient = new FcRequestClient(fcInfo.getUrl(), fcInfo.getUser(), fcInfo.getPassword());
            this.opVerifySwitch = this.fcRequestClient.queryAccountIsolationSwitch();
        }
        log.info("query isolation switch result : {}, userType : {}.", this.opVerifySwitch, (Object)fcInfo.getUserType());
        if (this.opVerifySwitch.isPresent() && this.opVerifySwitch.get().isVerifySwitch()) {
            if (!this.fcRequestClient.setAccountIsolationSwitch(false)) {
                log.error("close isolation switch failed.");
                throw new VmException(ApiError.ISOLATION_SWITCH);
            }
            log.info("close isolation switch success.");
        }
    }

    private void openIsolationSwitch() {
        if (this.fcRequestClient != null && this.opVerifySwitch.isPresent() && this.opVerifySwitch.get().isVerifySwitch()) {
            boolean isOpenSuccess = this.fcRequestClient.setAccountIsolationSwitch(true);
            log.info("open isolation switch result : {}.", (Object)isOpenSuccess);
        }
    }

    public TaskResult getTaskResult() {
        if (this.isTaskNotStart()) {
            return TaskResult.builder().state(State.NOT_START).build();
        }
        boolean isTaskPaused = this.isTaskPaused();
        if (isTaskPaused || this.isTaskEnd()) {
            this.openIsolationSwitch();
            this.endOperation();
            State state = isTaskPaused ? State.PAUSE : State.END;
            return TaskResult.builder().state(this.isTaskError() ? State.ERROR : state).beginTime(this.getBeginTime()).finishTime(this.getFinishTime()).build();
        }
        return TaskResult.builder().state(State.RUNNING).beginTime(this.getBeginTime()).build();
    }

    private void endOperation() {
        this.lastTaskInfoList = this.taskInfoList.stream().map(this.vmAssembler::copy).collect(Collectors.toList());
        if (!this.isTaskError()) {
            log.info("deleteDirectory {}", (Object)ImageConstant.ISO_CACHE_DIR);
            ExecutorUtils.execute(() -> FileOperateUtils.deleteDirectory((String)ImageConstant.ISO_CACHE_DIR));
        }
        this.isEnvironmentCheckRequired = this.getTaskById("check_environment").getState().isError();
        log.info("task end, check env:{}.", (Object)this.isEnvironmentCheckRequired);
    }

    public void restoreTask() {
        this.taskInfoList = this.lastTaskInfoList.stream().map(this.vmAssembler::copy).collect(Collectors.toList());
    }

    public void clearNodeCreateMaps() {
        this.nodeCreateMaps.clear();
    }

    public void updateNodeCreateMaps(List<NodeCreate> nodeCreates) {
        nodeCreates.forEach(nodeCreate -> this.nodeCreateMaps.put(nodeCreate.getIndex(), (NodeCreate)nodeCreate));
    }

    public List<TaskInfo> getParentTasks() {
        ArrayList<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
        List baseTaskInfos = this.taskInfoList.stream().filter(TaskInfo::isParentTask).filter(info -> !info.isTenantNode()).filter(info -> !info.isContainerClusterNode()).filter(info -> !info.isDcsasNode()).collect(Collectors.toList());
        taskInfos.addAll(baseTaskInfos);
        if (this.isTenant) {
            log.info("get tenant parent task");
            List tenantTasks = this.taskInfoList.stream().filter(TaskInfo::isParentTask).filter(TaskInfo::isTenantNode).collect(Collectors.toList());
            taskInfos.addAll(tenantTasks);
        }
        if (this.isContainerClusterService) {
            log.info("get container cluster parent task");
            List ccsTasks = this.taskInfoList.stream().filter(TaskInfo::isParentTask).filter(TaskInfo::isContainerClusterNode).collect(Collectors.toList());
            taskInfos.addAll(ccsTasks);
        }
        if (this.isDcsas) {
            log.info("get Auto Scaling parent task");
            List asTasks = this.taskInfoList.stream().filter(TaskInfo::isParentTask).filter(TaskInfo::isDcsasNode).collect(Collectors.toList());
            taskInfos.addAll(asTasks);
        }
        return taskInfos;
    }

    private boolean isTaskEnd() {
        return this.getTaskById("check_environment").getState().isError() || this.getParentTasks().stream().allMatch(taskInfo -> taskInfo.getState().isEnd());
    }

    public boolean isTaskError() {
        return this.getParentTasks().stream().anyMatch(taskInfo -> taskInfo.getState().isError());
    }

    public boolean isTaskPause() {
        return this.getParentTasks().stream().anyMatch(taskInfo -> taskInfo.getState().isPause());
    }

    private boolean isTaskNotStart() {
        return this.getTaskById("check_environment").getState().isNotStart();
    }

    private boolean isTaskPaused() {
        return this.getTaskById("check_environment").getState().isPause() || this.getParentTasks().stream().allMatch(taskInfo -> taskInfo.getState().isPause());
    }

    private LocalDateTime getBeginTime() {
        return this.taskInfoList.stream().map(TaskInfo::getStartTime).filter(Objects::nonNull).min(LocalDateTime::compareTo).orElseGet(LocalDateTime::now);
    }

    private LocalDateTime getFinishTime() {
        return this.taskInfoList.stream().map(TaskInfo::getEndTime).filter(Objects::nonNull).max(LocalDateTime::compareTo).orElseGet(LocalDateTime::now);
    }

    public void initTaskWithParentAndChildren(String taskId) {
        TaskInfo task = this.getTaskById(taskId);
        task.init(false);
        this.getTaskInfoList().stream().filter(taskInfo -> taskId.equals(taskInfo.getParentTaskId())).forEach(taskInfo -> taskInfo.init(false));
        if (StringUtils.isNotEmpty((CharSequence)task.getParentTaskId())) {
            this.getTaskById(task.getParentTaskId()).retry();
        }
    }

    @Generated
    public VmAssembler getVmAssembler() {
        return this.vmAssembler;
    }

    @Generated
    public ThreadLocal<List<Integer>> getVmIndex() {
        return this.vmIndex;
    }

    @Generated
    public ThreadLocal<List<Integer>> getFailedVmIndex() {
        return this.failedVmIndex;
    }

    @Generated
    public ConcurrentHashMap<Integer, NodeCreate> getNodeCreateMaps() {
        return this.nodeCreateMaps;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public List<TaskInfo> getTaskInfoList() {
        return this.taskInfoList;
    }

    @Generated
    public List<TaskInfo> getLastTaskInfoList() {
        return this.lastTaskInfoList;
    }

    @Generated
    public List<ParamTemplateBo> getParamTemplateBoList() {
        return this.paramTemplateBoList;
    }

    @Generated
    public FcRequestClient getFcRequestClient() {
        return this.fcRequestClient;
    }

    @Generated
    public Optional<VerifySwitch> getOpVerifySwitch() {
        return this.opVerifySwitch;
    }

    @Generated
    public VmParam getVmParam() {
        return this.vmParam;
    }

    @Generated
    public boolean isTenant() {
        return this.isTenant;
    }

    @Generated
    public boolean isContainerClusterService() {
        return this.isContainerClusterService;
    }

    @Generated
    public boolean isDcsas() {
        return this.isDcsas;
    }

    @Generated
    public boolean isEnvironmentCheckRequired() {
        return this.isEnvironmentCheckRequired;
    }

    @Generated
    public CacheProvider(VmAssembler vmAssembler) {
        this.vmAssembler = vmAssembler;
    }

    @Generated
    public void setTaskInfoList(List<TaskInfo> taskInfoList) {
        this.taskInfoList = taskInfoList;
    }

    @Generated
    public void setTenant(boolean isTenant) {
        this.isTenant = isTenant;
    }

    @Generated
    public void setContainerClusterService(boolean isContainerClusterService) {
        this.isContainerClusterService = isContainerClusterService;
    }

    @Generated
    public void setDcsas(boolean isDcsas) {
        this.isDcsas = isDcsas;
    }

    @Generated
    public void setEnvironmentCheckRequired(boolean isEnvironmentCheckRequired) {
        this.isEnvironmentCheckRequired = isEnvironmentCheckRequired;
    }
}

