/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.domain;

import com.google.common.collect.ArrayListMultimap;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.yinglong.river.deploy.virtualization.deployvm.entity.FcInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.FcRequestInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageUpdate;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.IsoEulerVersion;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.ApiServiceClient;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.CacheProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.VmProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.NodeCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.VmArchType;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.VmNodeType;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.VmRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.DataStoreResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.dvswitch.DvSwitches;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.host.HostList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.os.OsVersion;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.os.OsVersions;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.protgroup.PortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.protgroup.PortGroups;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.site.Site;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.site.SiteList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.Cpu;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.Disk;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.GraphicsCard;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.Memory;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.Nic;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.NicConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.OsOptions;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.Property;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.VmConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.VmConfigX;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmNode;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.VmException;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmExceptionResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmRequestUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import okhttp3.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VmFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmFactory.class);
    private static final Pattern ARM_ISO_PATTERN = Pattern.compile("(e)?DME(-Data)?_(.+)?EulerOS(.+)?_ARM(_64)?.iso");
    private static final Pattern X86_ISO_PATTERN = Pattern.compile("(e)?DME(-Data)?_(.+)?EulerOS(.+)?_X86(_64)?.iso");
    private static final String DEFAULT_DVS_NAME = "ManagementDVS";
    private static final String DEFAULT_PORT_GROUP_NAME = "managePortgroup";
    private final VmProvider vmProvider;
    private final CacheProvider cacheProvider;

    public VmRequestApi createApiService(FcInfo fcInfo) {
        String url = Optional.ofNullable(fcInfo).map(FcInfo::getUrl).orElse("");
        if (com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.StringUtils.isEmpty(url)) {
            throw new VmException(CustomError.PARAM_REQUIRED);
        }
        return (VmRequestApi)HttpRequestApiFactory.createRequestApi((String)FcRequestUtils.toFcUrl((String)url), VmRequestApi.class, (Interceptor[])new Interceptor[]{new FcRequestInterceptor(() -> this.getToken(fcInfo))});
    }

    private String getToken(FcInfo fcInfo) {
        try {
            return this.cacheProvider.updateAndGetToken(fcInfo);
        }
        catch (VmException e) {
            log.error("Failed to get token.", (Throwable)e);
            return "";
        }
    }

    public String validParam(VmParam vmParam) {
        ArrayList<String> errorMessage = new ArrayList<String>();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{vmParam.getArch(), vmParam.getNetMask(), vmParam.getGateway(), vmParam.getNetDevice()})) {
            errorMessage.add(VmExceptionResourceUtils.getErrorMessage(CustomError.PARAM_REQUIRED.getKey()));
        }
        this.validAndSetImagePath(vmParam, errorMessage);
        this.validFcInfo(vmParam.getFcInfo(), errorMessage);
        return String.join((CharSequence)"\uff1b", errorMessage);
    }

    public ImageUpdate generateImageUpdate(VmParam vmParam, String originName, VmNode vmNode) {
        return ImageUpdate.builder().path(vmParam.getImagePath()).repackageIsoName(vmNode.getIp() + "_" + originName).diskNum(2).rootPassword(vmNode.getRootPassword()).grubPassword(vmNode.getRootPassword()).ip(vmNode.getIp()).netMask(vmParam.getNetMask()).gateway(vmParam.getGateway()).netDevice(vmParam.getNetDevice()).build();
    }

    public VmConfig createVmConfig(NodeCreate nodeCreate) {
        VmConfig vmConfig = new VmConfig();
        vmConfig.setName(nodeCreate.getVmNode().getName());
        vmConfig.setDescription("auto_create");
        vmConfig.setIsAutoBoot(true);
        vmConfig.setCpuVendor(nodeCreate.getHost().getCpuVendor());
        vmConfig.setLocation(nodeCreate.getHost().getUrn());
        vmConfig.setParentObjUrn(nodeCreate.getSiteUrn());
        vmConfig.setIsEnableImc(false);
        vmConfig.setIsBindingHost(true);
        vmConfig.setOsOptions(this.buildOsOptions(nodeCreate.getVersionId()));
        vmConfig.setVmConfig(this.buildVmConfigX(nodeCreate));
        return vmConfig;
    }

    private boolean needCreateVmNodeByVmIndex(int index) {
        List<Integer> failedVmIndex = this.cacheProvider.getFailedVmIndex().get();
        return CollectionUtils.isEmpty(failedVmIndex) || failedVmIndex.contains(index);
    }

    public List<NodeCreate> generateNodeCreate(ApiServiceClient apiServiceClient, VmParam vmParam) {
        String siteUrn = this.getSiteUrn(apiServiceClient);
        String siteId = VmRequestUtils.getIdFromUrn(siteUrn);
        log.info("generate node siteId:{}, siteUrn:{}.", (Object)siteId, (Object)siteUrn);
        this.vmProvider.cleanVm(siteId);
        this.vmProvider.refreshDatStore(siteId);
        Map<String, Host> hostMap = this.getHostMap(apiServiceClient, siteId);
        Map<String, List<DataStore>> dataStoreMap = this.getDataStoreMap(apiServiceClient, siteId, hostMap);
        ArrayListMultimap<String, DataStore> nodeToDataStoreMap = this.getNodeToDataStoreMap(vmParam, hostMap, dataStoreMap);
        int eulerVersionId = this.getEulerVersionId(apiServiceClient, siteId, hostMap, vmParam);
        String portGroupUrn = this.getPortGroupUrn(apiServiceClient, siteId);
        log.info("generate node eulerVersionId : {}, portGroupUrn : {}.", (Object)eulerVersionId, (Object)portGroupUrn);
        List<VmNode> node = vmParam.getVmNode();
        return IntStream.range(0, node.size()).filter(index -> this.needCreateVmNodeByVmIndex(index + 1) && ((VmNode)node.get(index)).isDeploy()).mapToObj(index -> {
            VmNode vmNode = (VmNode)node.get(index);
            List dataStores = nodeToDataStoreMap.get((Object)vmNode.getIp());
            return NodeCreate.builder().index(index + 1).vmNode(vmNode).host((Host)hostMap.get(vmNode.getCnaName())).sysDataStore((DataStore)dataStores.get(0)).dataDataStore((DataStore)dataStores.get(1)).imgDataStore(this.getImgDataStore((List)dataStoreMap.get(vmNode.getCnaName()))).siteUrn(siteUrn).versionId(eulerVersionId).portGroupUrn(portGroupUrn).arch(VmArchType.of(vmParam.getArch())).memoryGb(this.isTenantNode(vmNode) ? VmConfigUtils.getDefaultTenantMemoryGb() : VmConfigUtils.getDefaultMemoryGb(vmNode.getType(), vmNode.getManagementLevel())).build();
        }).collect(Collectors.toList());
    }

    private DataStore getImgDataStore(List<DataStore> dataStores) {
        if (CollectionUtils.isEmpty(dataStores)) {
            throw new VmException(ApiError.DATA_ERROR);
        }
        int imageSize = VmConfigUtils.getImageSizeGb();
        DataStore dataStore = dataStores.stream().filter(DataStore::isSupportUploadFile).sorted(Comparator.comparingInt(DataStore::getFreeSizeGB)).filter(store -> store.useSize(imageSize)).findFirst().orElseThrow(VmException.thr(ApiError.DATA_STORE_INSUFFICIENT));
        log.info("Image upload datastore:{}-{}", (Object)dataStore.getUrn(), (Object)dataStore.getName());
        return dataStore;
    }

    private VmConfigX buildVmConfigX(NodeCreate nodeCreate) {
        VmConfigX vmConfigX = new VmConfigX();
        vmConfigX.setCpu(this.buildCpu(nodeCreate));
        vmConfigX.setMemory(this.buildMemory(nodeCreate));
        vmConfigX.setDisks(this.buildDisks(nodeCreate.getVmNode(), nodeCreate));
        vmConfigX.setNics(Collections.singletonList(this.buildNic(nodeCreate.getPortGroupUrn())));
        boolean isArm = Optional.ofNullable(nodeCreate.getHost()).map(Host::getArch).map("arm"::equals).orElse(false);
        vmConfigX.setGraphicsCard(this.buildGraphicsCard(isArm));
        vmConfigX.setProperties(this.buildProperty(isArm));
        return vmConfigX;
    }

    private boolean isTenantNode(VmNode vmNode) {
        return VmNodeType.of(vmNode.getType()) == VmNodeType.TENANT;
    }

    Property buildProperty(boolean isArm) {
        Property property = new Property();
        property.setReoverByHost(true);
        property.setBootFirmware(isArm ? "UEFI" : "BIOS");
        property.setBootFirmwareTime(0);
        property.setBootOption("disk");
        property.setClockMode("freeClock");
        property.setAutoUpgrade(true);
        return property;
    }

    private GraphicsCard buildGraphicsCard(boolean isArm) {
        GraphicsCard graphicsCard = new GraphicsCard();
        if (!isArm) {
            graphicsCard.setSize(4);
        }
        graphicsCard.setType(isArm ? "virtio" : "cirrus");
        return graphicsCard;
    }

    private Nic buildNic(String portGroupUrn) {
        Nic nic = new Nic();
        nic.setIsEnableSecurityGroup(false);
        nic.setPortGroupUrn(portGroupUrn);
        nic.setSequenceNum(0);
        nic.setVirtIo(1);
        nic.setBootOrder(-1);
        NicConfig nicConfig = new NicConfig();
        nicConfig.setQueues(1);
        nicConfig.setVringbuf(256);
        nic.setNicConfig(nicConfig);
        return nic;
    }

    private List<Disk> buildDisks(VmNode vmNode, NodeCreate nodeCreate) {
        int systemDatastoreSizeGb = VmConfigUtils.getSystemDatastoreSizeGb(vmNode.getType(), vmNode.getManagementLevel());
        if (vmNode.getSizeGb() <= systemDatastoreSizeGb) {
            throw new VmException(ApiError.STORE_SIZE_TOO_SMALL);
        }
        ArrayList<Disk> disks = new ArrayList<Disk>();
        disks.add(this.buildDisk(nodeCreate.getHostId(), systemDatastoreSizeGb, nodeCreate.getSysDataStore(), 1));
        int dataDiskSize = vmNode.getSizeGb() - systemDatastoreSizeGb;
        disks.add(this.buildDisk(nodeCreate.getHostId(), dataDiskSize, nodeCreate.getDataDataStore(), 2));
        return disks;
    }

    private Disk buildDisk(String hostId, int sizeGb, DataStore dataStore, int sequenceNum) {
        Disk disk = new Disk();
        disk.setDatastoreUrn(dataStore.getUrn());
        disk.setQuantityGB(sizeGb);
        disk.setSequenceNum(sequenceNum);
        disk.setType("normal");
        disk.setIsIndepDisk(false);
        disk.setIsPersistentDisk(true);
        disk.setVolType(1);
        disk.setPciType("VIRTIO");
        disk.setBootOrder(-1);
        disk.setIsThin(dataStore.getIsThin());
        if (dataStore.isHostProtocolNvme(hostId)) {
            disk.setStorageProtocol("1");
        }
        return disk;
    }

    private Memory buildMemory(NodeCreate nodeCreate) {
        Memory memory = new Memory();
        memory.setQuantityMB(nodeCreate.getMemoryGb() * 1024);
        memory.setWeight(memory.getQuantityMB() * 10);
        memory.setHugePage(nodeCreate.isProtocolNvme() ? "1G" : "4K");
        memory.setReservation(nodeCreate.getMemoryGb() * 1024);
        return memory;
    }

    private Cpu buildCpu(NodeCreate nodeCreate) {
        int cpuMhz = Optional.ofNullable(nodeCreate.getHost()).map(Host::getCpuMHz).orElse(0);
        int cpuNum = VmConfigUtils.getDefaultCpu(nodeCreate.getVmNode().getType(), nodeCreate.getVmNode().getManagementLevel());
        log.info("build cpu MHz: {}, core: {}.", (Object)cpuMhz, (Object)cpuNum);
        Cpu cpu = new Cpu();
        cpu.setQuantity(cpuNum);
        cpu.setWeight(cpu.getQuantity() * 500);
        cpu.setCoresPerSocket(1);
        cpu.setReservation(cpuNum * cpuMhz);
        cpu.setLimit(0);
        cpu.setCpuHotPlug(0);
        cpu.setCpuThreadPolicy("prefer");
        cpu.setCpuPolicy("shared");
        return cpu;
    }

    private OsOptions buildOsOptions(int versionId) {
        OsOptions osOptions = new OsOptions();
        osOptions.setOsType("Linux");
        osOptions.setOsVersion(versionId);
        return osOptions;
    }

    String getPortGroupUrn(ApiServiceClient apiServiceClient, String siteId) {
        String dvSwitchId = apiServiceClient.getDvSwitches(siteId).map(DvSwitches::getDvSwitchs).map(dvSwitches -> dvSwitches.stream().filter(dvSwitch -> DEFAULT_DVS_NAME.equals(dvSwitch.getName())).findFirst().orElseThrow(VmException.thr(ApiError.DATA_ERROR))).map(dvSwitch -> VmRequestUtils.getIdFromUrn(dvSwitch.getUrn())).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        return apiServiceClient.getPortGroups(siteId, dvSwitchId).map(PortGroups::getPortGroups).map(portGroups -> portGroups.stream().filter(portGroup -> DEFAULT_PORT_GROUP_NAME.equals(portGroup.getName())).findFirst().orElseThrow(VmException.thr(ApiError.DATA_ERROR))).map(PortGroup::getUrn).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
    }

    private int getEulerVersionId(ApiServiceClient apiServiceClient, String siteId, Map<String, Host> hostMap, VmParam vmParam) {
        List cnaLists = vmParam.getVmNode().stream().map(VmNode::getCnaName).collect(Collectors.toList());
        Host host = hostMap.values().stream().filter(h -> cnaLists.contains(h.getHostRealName())).findFirst().orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        List linuxVersions = apiServiceClient.getOsVersions(siteId, host.getArch(), host.getCpuVendor()).map(OsVersions::getLinux).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        String eulerOsVersion = IsoEulerVersion.parse((String)vmParam.getImagePath()).getFcOsVersion();
        return linuxVersions.stream().filter(version -> version.getVersionDes().contains(eulerOsVersion)).findFirst().map(OsVersion::getId).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
    }

    private ArrayListMultimap<String, DataStore> getNodeToDataStoreMap(VmParam vmParam, Map<String, Host> hostMap, Map<String, List<DataStore>> dataStoreMap) {
        ArrayListMultimap nodeToDataStoreMap = ArrayListMultimap.create();
        List<VmNode> vmNodes = vmParam.getVmNode();
        IntStream.range(0, vmNodes.size()).filter(index -> this.needCreateVmNodeByVmIndex(index + 1)).mapToObj(vmNodes::get).forEach(vmNode -> this.buildVmNodeDataStoreMaps(hostMap, dataStoreMap, (ArrayListMultimap<String, DataStore>)nodeToDataStoreMap, (VmNode)vmNode));
        return nodeToDataStoreMap;
    }

    private void buildVmNodeDataStoreMaps(Map<String, Host> hostMap, Map<String, List<DataStore>> dataStoreMap, ArrayListMultimap<String, DataStore> nodeToDataStoreMap, VmNode vmNode) {
        if (!vmNode.isDeploy()) {
            return;
        }
        Host host = hostMap.get(vmNode.getCnaName());
        if (host == null) {
            throw new VmException(ApiError.CNA_NOT_EXIST);
        }
        if (this.cacheProvider.isEnvironmentCheckRequired() && !host.isUseMemorySuccess(this.isTenantNode(vmNode) ? VmConfigUtils.getDefaultTenantMemoryGb() : VmConfigUtils.getDefaultMemoryGb(vmNode.getType(), vmNode.getManagementLevel()))) {
            throw new VmException(ApiError.CNA_MEMORY_INSUFFICIENT);
        }
        this.fillNodeToDataMap(dataStoreMap, nodeToDataStoreMap, vmNode);
    }

    private void fillNodeToDataMap(Map<String, List<DataStore>> dataStoreMap, ArrayListMultimap<String, DataStore> nodeToDataStoreMap, VmNode vmNode) {
        log.info("fill node ip:{}, cnaName:{}, size:{}.", new Object[]{vmNode.getIp(), vmNode.getCnaName(), vmNode.getSizeGb()});
        List<DataStore> dataStores = dataStoreMap.get(vmNode.getCnaName());
        int systemDatastoreSizeGb = VmConfigUtils.getSystemDatastoreSizeGb(vmNode.getType(), vmNode.getManagementLevel());
        if (vmNode.getSizeGb() <= systemDatastoreSizeGb) {
            throw new VmException(ApiError.STORE_SIZE_TOO_SMALL);
        }
        DataStore sysDatastore = this.findDatastore(dataStores, systemDatastoreSizeGb, vmNode.getDatastoreSystemName());
        log.info("system datastore: {}, freeSize: {} ", (Object)sysDatastore.getName(), (Object)sysDatastore.getFreeSizeGB());
        nodeToDataStoreMap.put((Object)vmNode.getIp(), (Object)sysDatastore);
        DataStore dataDatastore = this.findDatastore(dataStores, vmNode.getSizeGb() - systemDatastoreSizeGb, vmNode.getDatastoreDataName());
        log.info("data datastore: {}, freeSize: {} ", (Object)dataDatastore.getName(), (Object)dataDatastore.getFreeSizeGB());
        nodeToDataStoreMap.put((Object)vmNode.getIp(), (Object)dataDatastore);
    }

    private DataStore findDatastore(List<DataStore> dataStores, int sizeGb, String datastoreName) {
        if (StringUtils.isNotEmpty((CharSequence)datastoreName)) {
            DataStore dataStore = dataStores.stream().filter(store -> store.getName().equals(datastoreName)).findFirst().orElseThrow(VmException.thr(ApiError.DATA_STORE_NOT_EXIST));
            if (dataStore.useSize(sizeGb)) {
                return dataStore;
            }
            throw new VmException(ApiError.DATA_STORE_INSUFFICIENT);
        }
        return dataStores.stream().sorted(Comparator.comparingInt(DataStore::getFreeSizeGB)).filter(store -> store.useSize(sizeGb)).findFirst().orElseThrow(VmException.thr(ApiError.DATA_STORE_INSUFFICIENT));
    }

    private List<DataStore> queryDataStores(ApiServiceClient apiServiceClient, String siteId, Host host) {
        List dataStores = apiServiceClient.getDataStores(siteId, host.getUrn()).map(DataStoreResponse::getDatastores).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        List<String> dataStoreTypes = VmConfigUtils.getDataStoreTypes();
        return dataStores.stream().filter(DataStore::isAvailableStatus).filter(dataStore -> dataStoreTypes.contains(dataStore.getStorageType())).peek(dataStore -> log.info("query host {} local store name:{}, freeSize:{}.", new Object[]{host.getName(), dataStore.getName(), dataStore.getFreeSizeGB()})).collect(Collectors.toList());
    }

    private Map<String, List<DataStore>> getDataStoreMap(ApiServiceClient apiServiceClient, String siteId, Map<String, Host> hostMap) {
        return hostMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.queryDataStores(apiServiceClient, siteId, (Host)entry.getValue())));
    }

    private Map<String, Host> getHostMap(ApiServiceClient apiServiceClient, String siteId) {
        List hosts = apiServiceClient.getHosts(siteId).map(HostList::getHosts).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        if (CollectionUtils.isEmpty((Collection)hosts)) {
            throw new VmException(ApiError.DATA_ERROR);
        }
        return hosts.stream().collect(Collectors.toMap(Host::getName, Function.identity()));
    }

    private String getSiteUrn(ApiServiceClient apiServiceClient) {
        return apiServiceClient.getSites().map(SiteList::getSites).map(list -> (Site)list.get(0)).map(Site::getUrn).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
    }

    private void validFcInfo(FcInfo fcInfo, List<String> errorMessage) {
        if (fcInfo == null || StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{fcInfo.getUrl(), fcInfo.getUser(), fcInfo.getPassword()})) {
            errorMessage.add(VmExceptionResourceUtils.getErrorMessage(CustomError.PARAM_REQUIRED.getKey()));
        }
    }

    private void validAndSetImagePath(VmParam vmParam, List<String> errorMessage) {
        Pattern pattern;
        File imageFile = new File(vmParam.getImagePath());
        if (!imageFile.exists()) {
            errorMessage.add(VmExceptionResourceUtils.getErrorMessage(CustomError.FILE_NOT_EXIST.getKey()));
            return;
        }
        Pattern pattern2 = pattern = "X86".equalsIgnoreCase(vmParam.getArch()) ? X86_ISO_PATTERN : ARM_ISO_PATTERN;
        if (imageFile.isDirectory()) {
            Object[] files = imageFile.listFiles();
            if (ArrayUtils.isEmpty((Object[])files)) {
                errorMessage.add(VmExceptionResourceUtils.getErrorMessage(CustomError.FILE_NOT_EXIST.getKey()));
                return;
            }
            Optional imagePath = Arrays.stream(files).filter(file -> pattern.matcher(file.getName()).matches()).findFirst().flatMap(FilePathValidatorUtils::getSafePath);
            if (imagePath.isPresent()) {
                vmParam.setImagePath((String)imagePath.get());
                return;
            }
            errorMessage.add(VmExceptionResourceUtils.getErrorMessage(CustomError.FILE_NOT_EXIST.getKey()));
            return;
        }
        if (!pattern.matcher(imageFile.getName()).matches()) {
            errorMessage.add(VmExceptionResourceUtils.getErrorMessage(CustomError.FILE_NOT_EXIST.getKey()));
        }
    }

    @Generated
    public VmFactory(VmProvider vmProvider, CacheProvider cacheProvider) {
        this.vmProvider = vmProvider;
        this.cacheProvider = cacheProvider;
    }
}

