/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.domain;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdRule;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.AlarmThresholdRuleBind;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.alarm.cmd.CreateAlarmThresholdRule;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.NicSpecification;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Nic;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageUpdate;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.ApiServiceClient;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.CacheProvider;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.NodeCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.VmArchType;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.alarm.AlarmThresholdRuleList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.DataStoreResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.dvswitch.DvSwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.dvswitch.DvSwitches;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.image.AttachImage;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.image.FileUnits;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.image.ImageFileList;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.protgroup.PortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.protgroup.PortGroups;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.reboot.Reboot;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.task.SimpleTask;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.task.Task;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.upload.ApplyResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.upload.UploadResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.VmBootOption;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.VmConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.vm.response.VmTaskResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.DcsccsPublicDomainInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.ExtraIpConfigParam;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VirtualNicsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmNode;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.VmException;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmRequestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VmProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmProvider.class);
    public static final String ALARM_THRESHOLD_CPU_NAME = "eDME_CPU_ALARM_85";
    public static final String ALARM_THRESHOLD_MEMERY_NAME = "eDME_MEMERY_ALARM_90";
    private static final int PROGRESS_FINISH = 100;
    private static final int DEFAULT_BYTE_LENGTH = 0x100000;
    private static final String BOOT_OPTION_CDROM = "cdrom";
    private static final String BOOT_OPTION_DISK = "disk";
    private static final String CONTENT_RANGE = "bytes %d-%d/%d";
    private static final String ALARM_THRESHOLD_NOT_ENABLED = "65535";
    private final CacheProvider cacheProvider;

    public String createVm(String siteId, VmConfig vmConfig) {
        String taskUrn = this.cacheProvider.getApiServiceClient().createVm(siteId, vmConfig).map(VmTaskResponse::getTaskUrn).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        Task task = this.getTaskUntilFinish(siteId, taskUrn, 30);
        log.info("create Vm taskUrn:{}, entityUrn:{}.", (Object)taskUrn, (Object)task.getEntityUrn());
        return VmRequestUtils.getIdFromUrn(task.getEntityUrn());
    }

    public void bindAlarmThresholdRule(String siteId, String ruleName, String vmUrn) {
        log.info("bind alarm rule, name : {}, vmUrn : {}.", (Object)ruleName, (Object)vmUrn);
        this.cacheProvider.getApiServiceClient().bindAlarmThresholdRule(siteId, AlarmThresholdRuleBind.builder().ruleName(ruleName).objectList(Collections.singletonList(vmUrn)).build());
        log.info("bind alarm rule {} success.", (Object)vmUrn);
    }

    public void createAlarmThresholdRule(String siteId) {
        List alarmThresholdRules = this.cacheProvider.getApiServiceClient().queryAlarmThresholdRule(siteId, AlarmThresholdQuery.builder().isDefault(0).page(1).limit(100).objectType("vms").build()).map(AlarmThresholdRuleList::getItems).orElseThrow(VmException.thr(ApiError.ALARM_THRESHOLD_QUERY_FAIL));
        List ruleNames = alarmThresholdRules.stream().map(CreateAlarmThresholdRule::getRuleName).collect(Collectors.toList());
        log.info("find exist alarm rules : {}.", ruleNames);
        if (!ruleNames.contains(ALARM_THRESHOLD_CPU_NAME)) {
            this.cacheProvider.getApiServiceClient().addAlarmThresholdRule(siteId, this.buildAlarmThresholdRule(ALARM_THRESHOLD_CPU_NAME, "cpu_usage", 85));
            log.info("create cpu threshold success.");
        }
        if (!ruleNames.contains(ALARM_THRESHOLD_MEMERY_NAME)) {
            this.cacheProvider.getApiServiceClient().addAlarmThresholdRule(siteId, this.buildAlarmThresholdRule(ALARM_THRESHOLD_MEMERY_NAME, "mem_usage", 90));
            log.info("create memery threshold success.");
        }
    }

    private AlarmThresholdRule buildAlarmThresholdRule(String name, String metric, int threshold) {
        return ((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)((AlarmThresholdRule.AlarmThresholdRuleBuilder)AlarmThresholdRule.builder().ruleName(name)).alarmThrCritical(ALARM_THRESHOLD_NOT_ENABLED)).alarmThrMajor(String.valueOf(threshold))).alarmThrMinor(ALARM_THRESHOLD_NOT_ENABLED)).alarmThrWarning(ALARM_THRESHOLD_NOT_ENABLED)).objectType("vms")).metric(metric)).offset("5")).description("auto created by deploy tools.")).build();
    }

    public void cleanVm(String siteId) {
        List<TaskInfo> lastTaskInfoList = this.cacheProvider.getLastTaskInfoList();
        List<Integer> vmIndex = this.cacheProvider.getVmIndex().get();
        if (CollectionUtils.isEmpty(lastTaskInfoList) || CollectionUtils.isEmpty(vmIndex)) {
            log.info("clean vm, vmIndex:{}.", vmIndex);
            return;
        }
        List<TaskInfo> failedParentTasks = lastTaskInfoList.stream().filter(taskInfo -> this.isFailedIndexTask(vmIndex, (TaskInfo)taskInfo)).collect(Collectors.toList());
        failedParentTasks.forEach(failedParentTask -> lastTaskInfoList.stream().filter(taskInfo -> this.isFailedVmTask((TaskInfo)failedParentTask, (TaskInfo)taskInfo)).forEach(failedVmTask -> this.deleteVm(siteId, failedVmTask.getVmsId())));
    }

    private boolean isFailedIndexTask(List<Integer> vmIndex, TaskInfo taskInfo) {
        return taskInfo.getState().isError() && taskInfo.isParentTask() && vmIndex.contains(taskInfo.getTaskNodeIndex());
    }

    public void deleteVm(String siteId, String vmsId) {
        try {
            String taskUrn = this.cacheProvider.getApiServiceClient().deleteVm(siteId, vmsId).map(SimpleTask::getTaskUrn).orElse("");
            log.info("prepare to delete Vm: {}.", (Object)taskUrn);
            this.getTaskUntilFinish(siteId, taskUrn, 10);
            log.info("clean vm success, siteId:{}, vmsId{}", (Object)siteId, (Object)vmsId);
        }
        catch (VmException e) {
            log.error("clean vm failed, siteId: {}, vmsId: {}", new Object[]{siteId, vmsId, e});
        }
    }

    private boolean isFailedVmTask(TaskInfo failedParentTask, TaskInfo taskInfo) {
        log.info("check failed vm task, id:{}, pId:{}, vmsId:{}.", new Object[]{failedParentTask.getId(), taskInfo.getParentTaskId(), taskInfo.getVmsId()});
        return StringUtils.isNotEmpty((CharSequence)taskInfo.getVmsId()) && failedParentTask.getId().equals(taskInfo.getParentTaskId());
    }

    public void mountingNics(NodeCreate nodeCreate) {
        log.info("start mounting nic,ip is {}", (Object)nodeCreate.getHost().getName());
        String vmsId = nodeCreate.getVmsId();
        String siteId = nodeCreate.getSiteId();
        this.mountingNicsApi(siteId, vmsId, this.buildVirtualNicParam(nodeCreate));
        this.checkMountIngNicIsSuccess(siteId, vmsId, nodeCreate.getVmNode().getExtraIpConfigParams().get(0).getIp());
        this.configuringRoutes(nodeCreate);
    }

    public void installVmTools(NodeCreate nodeCreate) {
        log.info("start install vm tools,ip is {}", (Object)nodeCreate.getHost().getName());
        String vmsId = nodeCreate.getVmsId();
        String siteId = nodeCreate.getSiteId();
        this.installTools(vmsId, siteId);
        this.installToolsCmd(nodeCreate.getVmNode());
        try {
            this.uninstallTools(vmsId, siteId);
        }
        catch (VmException e) {
            log.error("uninstall vm tools failed.", (Throwable)e);
        }
    }

    void configuringRoutes(NodeCreate nodeCreate) {
        SshConnInfo sshConnInfo = SshConnInfo.builder().hostName(nodeCreate.getVmNode().getIp()).userName("root").userPwd(nodeCreate.getVmNode().getRootPassword()).build();
        try {
            SshShellService shellService = SshManager.createSshShellService((ClientSession)SshManager.getSession((SshConnInfo)sshConnInfo));
            shellService.connect();
            DcsccsPublicDomainInfo dcsccsPublicDomainInfo = nodeCreate.getVmNode().getDcsccsPublicDomainInfo();
            String bMsresult = shellService.execCommand(String.format("route add -net %s gw %s", dcsccsPublicDomainInfo.getBmsVipSegment(), dcsccsPublicDomainInfo.getGateway()));
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
            String clientResult = shellService.execCommand(String.format("route add -net %s gw %s", dcsccsPublicDomainInfo.getClientSegment(), dcsccsPublicDomainInfo.getGateway()));
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
            String nicName = VmArchType.X86 == nodeCreate.getArch() ? "enp4s2" : "enp7s0";
            shellService.execCommand(String.format("echo '%s via %s dev %s' >> /etc/sysconfig/network-scripts/route-%s", dcsccsPublicDomainInfo.getBmsVipSegment(), dcsccsPublicDomainInfo.getGateway(), nicName, nicName));
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
            shellService.execCommand(String.format("echo '%s via %s dev %s' >> /etc/sysconfig/network-scripts/route-%s", dcsccsPublicDomainInfo.getClientSegment(), dcsccsPublicDomainInfo.getGateway(), nicName, nicName));
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
            String failedResult = "netmask doesn't match route address";
            if (bMsresult.contains(failedResult) || clientResult.contains(failedResult)) {
                throw new VmException(ApiError.ROUTE_CONFIG_FAILED);
            }
        }
        catch (SshException e) {
            throw new VmException(ApiError.INSTALL_TOOLS_FAILED);
        }
        finally {
            SshManager.releaseSession((SshConnInfo)sshConnInfo);
        }
    }

    void checkMountIngNicIsSuccess(String siteId, String vmsId, String targetIp) {
        try {
            RetryUtils.retry(() -> this.cacheProvider.getApiServiceClient().getVmInfo(siteId, vmsId), optionalVmDetail -> this.checkIpIsMounting((Optional<VmDetail>)optionalVmDetail, targetIp), (int)10, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (FcTaskException e) {
            throw new VmException(ApiError.MOUNTING_NIC_FAILED);
        }
    }

    boolean checkIpIsMounting(Optional<VmDetail> optionalVmDetail, String targetIp) {
        if (!optionalVmDetail.isPresent()) {
            log.error("query vm info failed");
            throw new VmException(ApiError.DATA_ERROR);
        }
        List nics = optionalVmDetail.get().getVmConfig().getNics();
        return nics.size() == 2 && ((Nic)nics.get(1)).getIp().equals(targetIp);
    }

    void installToolsCmd(VmNode vmNode) {
        SshConnInfo sshConnInfo = SshConnInfo.builder().hostName(vmNode.getIp()).userName("root").userPwd(vmNode.getRootPassword()).build();
        try {
            ClientSession clientSession = SshManager.getSession((SshConnInfo)sshConnInfo);
            SshShellService shellService = SshManager.createSshShellService((ClientSession)clientSession);
            shellService.connect();
            log.info("install tools cmd");
            this.executeCmd(shellService, "mkdir xvdd");
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
            this.executeCmd(shellService, "mount /dev/sr0 xvdd");
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
            this.executeCmd(shellService, "cp xvdd/*.bz2 .");
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
            this.executeCmd(shellService, "tar -xjvf *.bz2");
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
            this.executeCmd(shellService, "cd vmtools");
            this.executeCmd(shellService, "./install");
            shellService.disconnect();
        }
        catch (SshException e) {
            log.error("try to connect os failed, {}: {}.", (Object)vmNode.getIp(), (Object)e.getErrorMessage());
            throw new VmException(ApiError.INSTALL_TOOLS_FAILED);
        }
        finally {
            SshManager.releaseSession((SshConnInfo)sshConnInfo);
        }
    }

    private void executeCmd(SshShellService shellService, String cmd) throws SshException {
        String result = shellService.execCommand(cmd);
        log.info("execute cmd [{}], result : {}.", (Object)cmd, (Object)result);
    }

    void installTools(String vmsId, String siteId) {
        SimpleTask simpleTask = this.cacheProvider.getApiServiceClient().installTools(siteId, vmsId).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("install vm tools, vmsId:{}, task:{}.", (Object)vmsId, (Object)simpleTask);
        this.getTaskUntilFinish(siteId, simpleTask.getTaskUrn(), 10);
    }

    void uninstallTools(String vmsId, String siteId) {
        SimpleTask simpleTask = this.cacheProvider.getApiServiceClient().uninstallTools(siteId, vmsId).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("uninstall vm tools, vmsId:{}, task:{}.", (Object)vmsId, (Object)simpleTask);
        this.getTaskUntilFinish(siteId, simpleTask.getTaskUrn(), 10);
    }

    void mountingNicsApi(String siteId, String vmsId, VirtualNicsParam virtualNicParam) {
        SimpleTask simpleTask = this.cacheProvider.getApiServiceClient().addVirtualNics(siteId, vmsId, virtualNicParam).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("update boot option, vmsId:{}, VirtualNicsParam:{}, task:{}.", new Object[]{vmsId, virtualNicParam, simpleTask});
        this.getTaskUntilFinish(siteId, simpleTask.getTaskUrn(), 10);
    }

    private VirtualNicsParam buildVirtualNicParam(NodeCreate nodeCreate) {
        ExtraIpConfigParam extraIpConfigParam = nodeCreate.getVmNode().getExtraIpConfigParams().get(0);
        return VirtualNicsParam.builder().portGroupUrn(this.getPortGroupUrn(nodeCreate.getVmNode().getExtraIpConfigParams().get(0).getPortGroup(), nodeCreate.getSiteId())).nicSpecification(NicSpecification.builder().sequenceNum(2).ip(extraIpConfigParam.getIp()).netmask(extraIpConfigParam.getNetMask()).build()).build();
    }

    String getPortGroupUrn(String name, String siteId) {
        ApiServiceClient apiServiceClient = this.cacheProvider.getApiServiceClient();
        List dvSwitches = apiServiceClient.getDvSwitches(siteId).map(DvSwitches::getDvSwitchs).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        for (DvSwitch dvSwitch : dvSwitches) {
            List portGroupList;
            Optional<String> first;
            Optional<List> portGroups = apiServiceClient.getPortGroups(siteId, VmRequestUtils.getIdFromUrn(dvSwitch.getUrn())).map(PortGroups::getPortGroups);
            if (!portGroups.isPresent() || !(first = (portGroupList = portGroups.get()).stream().filter(portGroup -> name.equals(portGroup.getName())).map(PortGroup::getUrn).findFirst()).isPresent()) continue;
            return first.get();
        }
        throw new VmException(ApiError.DATA_ERROR);
    }

    public void installVmOs(NodeCreate nodeCreate) {
        String vmsId = nodeCreate.getVmsId();
        String siteId = nodeCreate.getSiteId();
        this.updateBootOption(siteId, vmsId, BOOT_OPTION_CDROM);
        this.reboot(siteId, vmsId);
        this.updateBootOption(siteId, vmsId, BOOT_OPTION_DISK);
        this.checkIp(nodeCreate);
        this.checkIpSshConnected(nodeCreate);
    }

    public void attachImage(String fileName, NodeCreate nodeCreate) {
        this.detachImage(nodeCreate);
        int fileId = this.getFileIdWhenFileReady(fileName, nodeCreate);
        log.info("attach image file id:{}, fileName:{},index:{}.", new Object[]{fileId, fileId, nodeCreate.getIndex()});
        AttachImage attachImage = this.generateAttachImage(fileName, nodeCreate, fileId);
        SimpleTask simpleTask = this.cacheProvider.getApiServiceClient().attachImage(nodeCreate.getSiteId(), nodeCreate.getVmsId(), attachImage).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("attach image task:{}.", (Object)simpleTask);
        if (StringUtils.isNotEmpty((CharSequence)simpleTask.getErrorDes())) {
            throw new VmException(ApiError.TASK_FAIL, Collections.singletonList(simpleTask.getErrorDes()));
        }
        this.getTaskUntilFinish(nodeCreate.getSiteId(), simpleTask.getTaskUrn(), 10);
    }

    int getFileIdWhenFileReady(String fileName, NodeCreate nodeCreate) {
        FileUnits fileInfo;
        int timeout = 30;
        int count = 0;
        do {
            ThreadUtils.threadSafeSleep((int)20, (TimeUnit)TimeUnit.SECONDS);
            if (++count <= timeout) continue;
            throw new VmException(ApiError.IMAGE_FILE_NOT_READY);
        } while (!(fileInfo = this.getFileInfo(fileName, nodeCreate)).isFileStatusReady());
        return fileInfo.getFileId();
    }

    public void detachImage(NodeCreate nodeCreate) {
        try {
            String taskUrn = this.cacheProvider.getApiServiceClient().detachImage(nodeCreate.getSiteId(), nodeCreate.getVmsId()).map(SimpleTask::getTaskUrn).orElse("");
            this.getTaskUntilFinish(nodeCreate.getSiteId(), taskUrn, 10);
            log.info("detachImage siteId:{}, vmsId{}", (Object)nodeCreate.getSiteId(), (Object)nodeCreate.getVmsId());
        }
        catch (VmException e) {
            log.error("DetachImage failed", (Throwable)e);
        }
    }

    public void refreshDatStore(String siteId) {
        try {
            List<String> dataStoreUrns = this.cacheProvider.getApiServiceClient().getDataStores(siteId, null).map(DataStoreResponse::getDatastores).orElse(Collections.emptyList()).stream().map(DataStore::getUrn).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(dataStoreUrns)) {
                log.info("not find data stores.");
                return;
            }
            log.info("refresh data stores:{}.", dataStoreUrns);
            String taskUrn = this.cacheProvider.getApiServiceClient().refreshDataStores(siteId, dataStoreUrns).map(SimpleTask::getTaskUrn).orElse("");
            log.info("refresh data taskUrn:{}.", (Object)taskUrn);
            this.getTaskUntilFinish(siteId, taskUrn, 10);
        }
        catch (VmException e) {
            log.error("refreshDatStore failed", (Throwable)e);
        }
    }

    public int uploadImage(File file, NodeCreate nodeCreate) {
        this.tryDeleteFile(file, nodeCreate);
        log.info("file length:{}", (Object)file.length());
        Map<String, String> uploadMap = VmRequestUtils.buildUploadMap(file.getName(), file.length(), nodeCreate.getSiteId(), nodeCreate.getDataStoreId());
        int tryCount = 1;
        ApiServiceClient apiServiceClient = this.cacheProvider.getApiServiceClient();
        while (true) {
            try {
                log.info("upload image, try {}", (Object)tryCount);
                ApplyResponse applyResponse = apiServiceClient.applyUpload(nodeCreate.getSiteId(), nodeCreate.getDataStoreId(), uploadMap).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
                log.info("applyResponse: {}", (Object)JSON.toJSONString((Object)applyResponse));
                UploadResponse uploadResponse = apiServiceClient.getStreamUpload(applyResponse, uploadMap).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
                this.sliceUpload(file, uploadMap, applyResponse, uploadResponse);
                return this.getFileId(file.getName(), nodeCreate);
            }
            catch (VmException exception) {
                log.error("retry upload all", (Throwable)exception);
                if (++tryCount > 3) {
                    throw exception;
                }
                ThreadUtils.threadSafeSleep((int)3, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    private void tryDeleteFile(File file, NodeCreate nodeCreate) {
        try {
            int fileId = this.getFileId(file.getName(), nodeCreate);
            log.info("try to delete file, id:{}, index:{}.", (Object)fileId, (Object)nodeCreate.getIndex());
            if (fileId > 0) {
                this.deleteFile(fileId, nodeCreate);
            }
        }
        catch (VmException e) {
            log.error("DeleteFile failed", (Throwable)e);
        }
    }

    public void deleteFile(int fileId, NodeCreate nodeCreate) {
        try {
            this.cacheProvider.getApiServiceClient().deleteFile(nodeCreate.getSiteId(), nodeCreate.getDataStoreId(), fileId);
            log.info("DeleteFile, siteId:{}, storeId:{}, fileId:{}", new Object[]{nodeCreate.getSiteId(), nodeCreate.getDataStoreId(), fileId});
        }
        catch (VmException e) {
            log.error("Error deleting file {}", (Object)fileId, (Object)e);
        }
    }

    public Optional<File> updateImage(ImageUpdate imageUpdate) {
        Optional filePath = ImageUtils.updateImage((ImageUpdate)imageUpdate);
        if (!filePath.isPresent() || !new File((String)filePath.get()).exists()) {
            return Optional.empty();
        }
        return Optional.of(this.getFileWhileLengthNotChange((String)filePath.get()));
    }

    private void checkIp(NodeCreate nodeCreate) {
        String ip = Optional.ofNullable(nodeCreate.getVmNode()).map(VmNode::getIp).orElse("");
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return;
        }
        int maxCount = VmConfigUtils.getCheckIpTimeout();
        log.info("check ip:{}, maxCount:{}.", (Object)ip, (Object)maxCount);
        for (int tryCount = 0; tryCount < maxCount; ++tryCount) {
            if (IpUtils.isReachable((String)ip)) {
                log.info("ip:{}, has reached.", (Object)ip);
                return;
            }
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.MINUTES);
        }
        log.error("checkIp timeout");
        throw new VmException(CustomError.INSTALL_TIMEOUT);
    }

    private void checkIpSshConnected(NodeCreate nodeCreate) {
        String ip = Optional.ofNullable(nodeCreate.getVmNode()).map(VmNode::getIp).orElse("");
        String pwd = Optional.ofNullable(nodeCreate.getVmNode()).map(VmNode::getRootPassword).orElse("");
        if (StringUtils.isEmpty((CharSequence)ip) || StringUtils.isEmpty((CharSequence)pwd)) {
            log.error("check ip by ssh, ip or pwd is empty. ip = {}.", (Object)ip);
            return;
        }
        log.info("start to check ip:{} by ssh.", (Object)ip);
        int waitTimeout = VmConfigUtils.getWaitTimeout();
        for (int tryCount = 0; tryCount < waitTimeout; ++tryCount) {
            if (this.tryToConnectOsBySsh(ip, pwd)) {
                log.info("check ip by ssh, ssh collect success.");
                return;
            }
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.MINUTES);
        }
        log.error("check ip by ssh [{}] timeout.", (Object)ip);
        throw new VmException(CustomError.INSTALL_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryToConnectOsBySsh(String ip, String pwd) {
        boolean bl;
        SshConnInfo connInfo = null;
        try {
            connInfo = SshConnInfo.builder().hostName(ip).userName("root").userPwd(pwd).build();
            bl = SshManager.isConnected((SshConnInfo)connInfo);
        }
        catch (SshException e) {
            try {
                log.warn("try to connect os failed, {}: {}.", (Object)ip, (Object)e.getErrorMessage());
            }
            catch (Throwable throwable) {
                SshManager.releaseSession(connInfo);
                throw throwable;
            }
            SshManager.releaseSession((SshConnInfo)connInfo);
            return false;
        }
        SshManager.releaseSession((SshConnInfo)connInfo);
        return bl;
    }

    private void reboot(String siteId, String vmsId) {
        SimpleTask rebootTaskResponse = this.cacheProvider.getApiServiceClient().rebootVm(siteId, vmsId, new Reboot()).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("reboot vmsId:{}, task:{}.", (Object)vmsId, (Object)rebootTaskResponse);
        this.getTaskUntilFinish(siteId, rebootTaskResponse.getTaskUrn(), 10);
    }

    private void updateBootOption(String siteId, String vmsId, String bootOption) {
        SimpleTask cdromTask = this.cacheProvider.getApiServiceClient().updateImageProperty(siteId, vmsId, new VmBootOption(bootOption)).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("update boot option, vmsId:{}, bootOption:{}, task:{}.", new Object[]{vmsId, bootOption, cdromTask});
        this.getTaskUntilFinish(siteId, cdromTask.getTaskUrn(), 10);
    }

    private int getFileId(String fileName, NodeCreate nodeCreate) {
        List imageFileList = this.cacheProvider.getApiServiceClient().getImageFileList(nodeCreate.getSiteId(), nodeCreate.getDataStoreId()).map(ImageFileList::getFileUnits).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("query [{}] file ids:{}.", (Object)nodeCreate.getIndex(), (Object)imageFileList);
        return imageFileList.stream().filter(image -> image.getName().equals(fileName)).findFirst().map(FileUnits::getFileId).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
    }

    FileUnits getFileInfo(String fileName, NodeCreate nodeCreate) {
        List imageFileList = this.cacheProvider.getApiServiceClient().getImageFileList(nodeCreate.getSiteId(), nodeCreate.getDataStoreId()).map(ImageFileList::getFileUnits).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        log.info("query [{}] file ids:{}.", (Object)nodeCreate.getIndex(), (Object)imageFileList);
        return imageFileList.stream().filter(image -> image.getName().equals(fileName)).findFirst().orElseThrow(VmException.thr(ApiError.DATA_ERROR));
    }

    private File getFileWhileLengthNotChange(String filePath) {
        File file = new File(filePath);
        long length = 0L;
        for (int count = 0; length != file.length() && count < 10; ++count) {
            length = file.length();
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.MINUTES);
            log.info("length : {}, fileLength : {}.", (Object)length, (Object)file.length());
        }
        return file;
    }

    private void sliceUpload(File file, Map<String, String> uploadMap, ApplyResponse applyResponse, UploadResponse uploadResponse) {
        Map<String, String> tokenHeaders = VmRequestUtils.buildHeaders(this.cacheProvider.getToken());
        tokenHeaders.put("X_UPLOAD_ACCESS", applyResponse.getToken());
        tokenHeaders.put("Content-Type", "application/octet-stream");
        int start = uploadResponse.getStart();
        int sliceCount = 0;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            long fileLength = file.length();
            while ((long)start < fileLength) {
                if (sliceCount % 100 == 0) {
                    this.cacheProvider.getApiServiceClient().authCna(applyResponse.getTrustURL());
                }
                byte[] bytes = new byte[0x100000];
                int read = fileInputStream.read(bytes);
                tokenHeaders.put("Content-Length", String.valueOf(read));
                tokenHeaders.put("Content-Range", StringUtils.formatTxt((String)CONTENT_RANGE, (Object[])new Object[]{start, start + read, fileLength}));
                UploadResponse response = this.tryUpload(uploadMap, applyResponse, tokenHeaders, bytes);
                this.checkResponse(start, response);
                start = response.getStart();
                ++sliceCount;
            }
        }
        catch (IOException e) {
            throw new VmException(ApiError.UPLOAD_IMAGE_FAIL);
        }
    }

    private void checkResponse(int start, UploadResponse response) {
        if (!response.isSuccess()) {
            log.error("response error. {}", (Object)response.getMessage());
            throw new VmException(ApiError.UPLOAD_IMAGE_SLICE_FAIL, Collections.singletonList(response.getMessage()));
        }
        if (response.getStart() <= start) {
            log.warn("unexpected start, response {}, now {}.", (Object)response.getStart(), (Object)start);
            throw new VmException(ApiError.UPLOAD_IMAGE_FAIL);
        }
    }

    private UploadResponse tryUpload(Map<String, String> uploadMap, ApplyResponse applyResponse, Map<String, String> tokenHeaders, byte[] bytes) {
        for (int tryCount = 0; tryCount < 3; ++tryCount) {
            try {
                return this.cacheProvider.getApiServiceClient().postStreamUpload(tokenHeaders, applyResponse.getUploadURL(), bytes, uploadMap).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
            }
            catch (VmException vmException) {
                log.error("retry upload slice", (Throwable)vmException);
                ThreadUtils.threadSafeSleep((int)3, (TimeUnit)TimeUnit.SECONDS);
                log.info("threadSafeSleep 3 SECONDS");
                continue;
            }
        }
        throw new VmException(ApiError.UPLOAD_IMAGE_FAIL);
    }

    private AttachImage generateAttachImage(String fileName, NodeCreate nodeCreate, int fileId) {
        AttachImage attachImage = new AttachImage();
        attachImage.setProtocol("file");
        attachImage.setFileId(fileId);
        attachImage.setDevicePath(nodeCreate.getDataStoreId() + "@" + fileName);
        attachImage.setIsEnableIntegrity(false);
        return attachImage;
    }

    Task getTaskUntilFinish(String siteId, String taskUrn, int seconds) {
        String taskId = VmRequestUtils.getIdFromUrn(taskUrn);
        ApiServiceClient apiServiceClient = this.cacheProvider.getApiServiceClient();
        Task task = apiServiceClient.getTaskById(siteId, taskId).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
        while (task.getProgress() != 100) {
            ThreadUtils.threadSafeSleep((int)seconds, (TimeUnit)TimeUnit.SECONDS);
            task = apiServiceClient.getTaskById(siteId, taskId).orElseThrow(VmException.thr(ApiError.DATA_ERROR));
            log.info("query task progress, taskUrn:{}, status:{}.", (Object)taskUrn, (Object)task.getStatus());
        }
        if (!"success".equals(task.getStatus())) {
            throw new VmException(ApiError.TASK_FAIL, Collections.singletonList(task.getReasonDes()));
        }
        return task;
    }

    @Generated
    public VmProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

