/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node;

import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.node.VmArchType;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmNode;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util.VmRequestUtils;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class NodeCreate {
    private int index;
    private VmNode vmNode;
    private Host host;
    private DataStore sysDataStore;
    private DataStore dataDataStore;
    private DataStore imgDataStore;
    private String siteUrn;
    private int versionId;
    private String portGroupUrn;
    private int memoryGb;
    private String vmsId;
    private VmArchType arch;

    public String getSiteId() {
        return Optional.ofNullable(this.siteUrn).map(VmRequestUtils::getIdFromUrn).orElse("");
    }

    public String getHostId() {
        return Optional.ofNullable(this.host).map(Host::getUrn).map(VmRequestUtils::getIdFromUrn).orElse("");
    }

    public String getDataStoreId() {
        return Optional.ofNullable(this.imgDataStore).map(DataStore::getUrn).map(VmRequestUtils::getIdFromUrn).orElse("");
    }

    public boolean isProtocolNvme() {
        if (Objects.isNull(this.sysDataStore) || Objects.isNull(this.host)) {
            return false;
        }
        String hostId = VmRequestUtils.getIdFromUrn(this.host.getUrn());
        return this.sysDataStore.isHostProtocolNvme(hostId) || this.dataDataStore.isHostProtocolNvme(hostId);
    }

    @Generated
    NodeCreate(int index, VmNode vmNode, Host host, DataStore sysDataStore, DataStore dataDataStore, DataStore imgDataStore, String siteUrn, int versionId, String portGroupUrn, int memoryGb, String vmsId, VmArchType arch) {
        this.index = index;
        this.vmNode = vmNode;
        this.host = host;
        this.sysDataStore = sysDataStore;
        this.dataDataStore = dataDataStore;
        this.imgDataStore = imgDataStore;
        this.siteUrn = siteUrn;
        this.versionId = versionId;
        this.portGroupUrn = portGroupUrn;
        this.memoryGb = memoryGb;
        this.vmsId = vmsId;
        this.arch = arch;
    }

    @Generated
    public static NodeCreateBuilder builder() {
        return new NodeCreateBuilder();
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public VmNode getVmNode() {
        return this.vmNode;
    }

    @Generated
    public Host getHost() {
        return this.host;
    }

    @Generated
    public DataStore getSysDataStore() {
        return this.sysDataStore;
    }

    @Generated
    public DataStore getDataDataStore() {
        return this.dataDataStore;
    }

    @Generated
    public DataStore getImgDataStore() {
        return this.imgDataStore;
    }

    @Generated
    public String getSiteUrn() {
        return this.siteUrn;
    }

    @Generated
    public int getVersionId() {
        return this.versionId;
    }

    @Generated
    public String getPortGroupUrn() {
        return this.portGroupUrn;
    }

    @Generated
    public int getMemoryGb() {
        return this.memoryGb;
    }

    @Generated
    public String getVmsId() {
        return this.vmsId;
    }

    @Generated
    public VmArchType getArch() {
        return this.arch;
    }

    @Generated
    public void setVmsId(String vmsId) {
        this.vmsId = vmsId;
    }

    @Generated
    public static class NodeCreateBuilder {
        @Generated
        private int index;
        @Generated
        private VmNode vmNode;
        @Generated
        private Host host;
        @Generated
        private DataStore sysDataStore;
        @Generated
        private DataStore dataDataStore;
        @Generated
        private DataStore imgDataStore;
        @Generated
        private String siteUrn;
        @Generated
        private int versionId;
        @Generated
        private String portGroupUrn;
        @Generated
        private int memoryGb;
        @Generated
        private String vmsId;
        @Generated
        private VmArchType arch;

        @Generated
        NodeCreateBuilder() {
        }

        @Generated
        public NodeCreateBuilder index(int index) {
            this.index = index;
            return this;
        }

        @Generated
        public NodeCreateBuilder vmNode(VmNode vmNode) {
            this.vmNode = vmNode;
            return this;
        }

        @Generated
        public NodeCreateBuilder host(Host host) {
            this.host = host;
            return this;
        }

        @Generated
        public NodeCreateBuilder sysDataStore(DataStore sysDataStore) {
            this.sysDataStore = sysDataStore;
            return this;
        }

        @Generated
        public NodeCreateBuilder dataDataStore(DataStore dataDataStore) {
            this.dataDataStore = dataDataStore;
            return this;
        }

        @Generated
        public NodeCreateBuilder imgDataStore(DataStore imgDataStore) {
            this.imgDataStore = imgDataStore;
            return this;
        }

        @Generated
        public NodeCreateBuilder siteUrn(String siteUrn) {
            this.siteUrn = siteUrn;
            return this;
        }

        @Generated
        public NodeCreateBuilder versionId(int versionId) {
            this.versionId = versionId;
            return this;
        }

        @Generated
        public NodeCreateBuilder portGroupUrn(String portGroupUrn) {
            this.portGroupUrn = portGroupUrn;
            return this;
        }

        @Generated
        public NodeCreateBuilder memoryGb(int memoryGb) {
            this.memoryGb = memoryGb;
            return this;
        }

        @Generated
        public NodeCreateBuilder vmsId(String vmsId) {
            this.vmsId = vmsId;
            return this;
        }

        @Generated
        public NodeCreateBuilder arch(VmArchType arch) {
            this.arch = arch;
            return this;
        }

        @Generated
        public NodeCreate build() {
            return new NodeCreate(this.index, this.vmNode, this.host, this.sysDataStore, this.dataDataStore, this.imgDataStore, this.siteUrn, this.versionId, this.portGroupUrn, this.memoryGb, this.vmsId, this.arch);
        }

        @Generated
        public String toString() {
            return "NodeCreate.NodeCreateBuilder(index=" + this.index + ", vmNode=" + this.vmNode + ", host=" + this.host + ", sysDataStore=" + this.sysDataStore + ", dataDataStore=" + this.dataDataStore + ", imgDataStore=" + this.imgDataStore + ", siteUrn=" + this.siteUrn + ", versionId=" + this.versionId + ", portGroupUrn=" + this.portGroupUrn + ", memoryGb=" + this.memoryGb + ", vmsId=" + this.vmsId + ", arch=" + (Object)((Object)this.arch) + ")";
        }
    }
}

