/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task;

import com.google.common.collect.ImmutableList;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.domain.task.State;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.VmException;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInfo.class);
    public static final String ENVIRONMENT_TASK_ID = "check_environment";
    private static final List<String> CAN_SKIP_TASK = ImmutableList.of((Object)"node_attach_iso", (Object)"node_install_os", (Object)"node_install_vmtools", (Object)"mounting_nics");
    private static final String CAN_NOT_RETRY_TASK = "node_install_os";
    private static final List<String> tenantNodes = ImmutableList.of((Object)"node4", (Object)"node5");
    private static final List<String> containerClusterNodes = ImmutableList.of((Object)"node6", (Object)"node7");
    private static final List<String> dcsasNodes = ImmutableList.of((Object)"node8", (Object)"node9");
    private String id;
    private String parentTaskId;
    private String name;
    private String description;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private int durationTime;
    private State state = State.NOT_START;
    private String suggestMessage;
    private String errorMessage;
    private String skipMsg;
    private String vmsId;
    private int fileId;
    private File imageFile;
    private boolean isRetry;

    public boolean tryStart() {
        if (this.isRetry) {
            this.isRetry = false;
            return true;
        }
        if (!this.state.isNotStart()) {
            return false;
        }
        log.info(this.id + " start");
        this.startTime = LocalDateTime.now();
        this.state = State.RUNNING;
        return true;
    }

    public void success() {
        log.info(this.id + " success");
        this.endTime = LocalDateTime.now();
        this.state = State.END;
    }

    public void finish(State state, String suggestMessage, String errorMessage) {
        this.endTime = LocalDateTime.now();
        this.state = state;
        this.suggestMessage = suggestMessage;
        this.errorMessage = errorMessage;
    }

    public void fail(VmException vmException) {
        log.error("{} fail", (Object)this.id, (Object)vmException);
        this.finish(State.ERROR, vmException.getSuggestMessage(), vmException.getMessage());
    }

    public void fail(Exception exception) {
        if (exception instanceof VmException) {
            this.fail((VmException)exception);
        } else {
            log.error("{} fail", (Object)this.id, (Object)exception);
            this.fail();
        }
    }

    public void fail() {
        this.fail(new VmException(CustomError.TASK_FAILED));
    }

    public void pause() {
        this.pause(new VmException(CustomError.TASK_PAUSED));
    }

    public void pause(VmException vmException) {
        log.error("{} pause", (Object)this.id, (Object)vmException);
        this.finish(State.PAUSE, vmException.getSuggestMessage(), vmException.getMessage());
    }

    public boolean canSkip() {
        return CAN_SKIP_TASK.stream().anyMatch(taskId -> this.id.contains((CharSequence)taskId));
    }

    public boolean canRetry() {
        return !this.id.contains(CAN_NOT_RETRY_TASK);
    }

    public void init(boolean isNewTask) {
        this.state = State.NOT_START;
        this.startTime = null;
        this.endTime = null;
        this.suggestMessage = null;
        this.errorMessage = null;
        if (isNewTask) {
            this.vmsId = null;
            this.fileId = 0;
            this.imageFile = null;
            this.isRetry = false;
        }
    }

    public int getTaskNodeIndex() {
        if (this.isEnvironmentTask()) {
            return 0;
        }
        return Character.getNumericValue(this.id.charAt(this.id.length() - 1));
    }

    public boolean isEnvironmentTask() {
        return ENVIRONMENT_TASK_ID.equals(this.id);
    }

    public void retry() {
        this.isRetry = true;
        this.state = State.RUNNING;
        this.endTime = null;
    }

    public boolean isParentTask() {
        return StringUtils.isEmpty((CharSequence)this.parentTaskId);
    }

    public boolean isTenantNode() {
        return tenantNodes.contains(this.id);
    }

    public boolean isContainerClusterNode() {
        return containerClusterNodes.contains(this.id);
    }

    public boolean isDcsasNode() {
        return dcsasNodes.contains(this.id);
    }

    @Generated
    public TaskInfo() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public int getDurationTime() {
        return this.durationTime;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public String getSuggestMessage() {
        return this.suggestMessage;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public String getSkipMsg() {
        return this.skipMsg;
    }

    @Generated
    public String getVmsId() {
        return this.vmsId;
    }

    @Generated
    public int getFileId() {
        return this.fileId;
    }

    @Generated
    public File getImageFile() {
        return this.imageFile;
    }

    @Generated
    public boolean isRetry() {
        return this.isRetry;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setDurationTime(int durationTime) {
        this.durationTime = durationTime;
    }

    @Generated
    public void setState(State state) {
        this.state = state;
    }

    @Generated
    public void setSuggestMessage(String suggestMessage) {
        this.suggestMessage = suggestMessage;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setSkipMsg(String skipMsg) {
        this.skipMsg = skipMsg;
    }

    @Generated
    public void setVmsId(String vmsId) {
        this.vmsId = vmsId;
    }

    @Generated
    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    @Generated
    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    @Generated
    public void setRetry(boolean isRetry) {
        this.isRetry = isRetry;
    }
}

