/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.ImmutableList;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.ConnectProtocol;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.datastore.StorageUnits;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class DataStore {
    private static final List<String> NOT_SUPPORT_FILE_UPLOAD = ImmutableList.of((Object)"DSWARE", (Object)"advanceSan");
    @JSONField(name="urn")
    private String urn;
    @JSONField(name="uri")
    private String uri;
    @JSONField(name="suUrn")
    private String suUrn;
    @JSONField(name="suName")
    private String suName;
    @JSONField(name="storageType")
    private String storageType;
    @JSONField(name="clusterSize")
    private Integer clusterSize;
    @JSONField(name="name")
    private String name;
    @JSONField(name="status")
    private String status;
    @JSONField(name="capacityGB")
    private Integer capacityGB;
    @JSONField(name="usedSizeGB")
    private Integer usedSizeGB;
    @JSONField(name="freeSizeGB")
    private Integer freeSizeGB;
    @JSONField(name="isThin")
    private Boolean isThin;
    @JSONField(name="thinRate")
    private Integer thinRate;
    @JSONField(name="actualCapacityGB")
    private Integer actualCapacityGB;
    @JSONField(name="actualFreeSizeGB")
    private Integer actualFreeSizeGB;
    @JSONField(name="refreshTime")
    private String refreshTime;
    @JSONField(name="hosts")
    private List<String> hosts;
    @JSONField(name="suIdList")
    private List<?> suIdList;
    @JSONField(name="storageUnits")
    private List<StorageUnits> storageUnits;
    @JSONField(name="dsLockType")
    private Integer dsLockType;
    private List<ConnectProtocol> hostConnectProtocols;

    public boolean useSize(int sizeGb) {
        if (this.freeSizeGB < sizeGb) {
            return false;
        }
        DataStore dataStore = this;
        dataStore.freeSizeGB = dataStore.freeSizeGB - sizeGb;
        return true;
    }

    public boolean isAvailableStatus() {
        return Objects.equals(this.status, "NORMAL") || Objects.equals(this.status, "CONNECTED");
    }

    public boolean isHostProtocolNvme(String hostId) {
        return CollectionUtils.isNotEmpty(this.hostConnectProtocols) && this.hostConnectProtocols.stream().filter(protocol -> hostId.equals(protocol.getUrn())).anyMatch(protocol -> "NVMe".equals(protocol.getAccessProtocol()));
    }

    public boolean isSupportUploadFile() {
        return !NOT_SUPPORT_FILE_UPLOAD.contains(this.storageType);
    }

    @Generated
    public DataStore() {
    }

    @Generated
    public String getUrn() {
        return this.urn;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getSuUrn() {
        return this.suUrn;
    }

    @Generated
    public String getSuName() {
        return this.suName;
    }

    @Generated
    public String getStorageType() {
        return this.storageType;
    }

    @Generated
    public Integer getClusterSize() {
        return this.clusterSize;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Integer getCapacityGB() {
        return this.capacityGB;
    }

    @Generated
    public Integer getUsedSizeGB() {
        return this.usedSizeGB;
    }

    @Generated
    public Integer getFreeSizeGB() {
        return this.freeSizeGB;
    }

    @Generated
    public Boolean getIsThin() {
        return this.isThin;
    }

    @Generated
    public Integer getThinRate() {
        return this.thinRate;
    }

    @Generated
    public Integer getActualCapacityGB() {
        return this.actualCapacityGB;
    }

    @Generated
    public Integer getActualFreeSizeGB() {
        return this.actualFreeSizeGB;
    }

    @Generated
    public String getRefreshTime() {
        return this.refreshTime;
    }

    @Generated
    public List<String> getHosts() {
        return this.hosts;
    }

    @Generated
    public List<?> getSuIdList() {
        return this.suIdList;
    }

    @Generated
    public List<StorageUnits> getStorageUnits() {
        return this.storageUnits;
    }

    @Generated
    public Integer getDsLockType() {
        return this.dsLockType;
    }

    @Generated
    public List<ConnectProtocol> getHostConnectProtocols() {
        return this.hostConnectProtocols;
    }

    @Generated
    public void setUrn(String urn) {
        this.urn = urn;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setSuUrn(String suUrn) {
        this.suUrn = suUrn;
    }

    @Generated
    public void setSuName(String suName) {
        this.suName = suName;
    }

    @Generated
    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @Generated
    public void setClusterSize(Integer clusterSize) {
        this.clusterSize = clusterSize;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setCapacityGB(Integer capacityGB) {
        this.capacityGB = capacityGB;
    }

    @Generated
    public void setUsedSizeGB(Integer usedSizeGB) {
        this.usedSizeGB = usedSizeGB;
    }

    @Generated
    public void setFreeSizeGB(Integer freeSizeGB) {
        this.freeSizeGB = freeSizeGB;
    }

    @Generated
    public void setIsThin(Boolean isThin) {
        this.isThin = isThin;
    }

    @Generated
    public void setThinRate(Integer thinRate) {
        this.thinRate = thinRate;
    }

    @Generated
    public void setActualCapacityGB(Integer actualCapacityGB) {
        this.actualCapacityGB = actualCapacityGB;
    }

    @Generated
    public void setActualFreeSizeGB(Integer actualFreeSizeGB) {
        this.actualFreeSizeGB = actualFreeSizeGB;
    }

    @Generated
    public void setRefreshTime(String refreshTime) {
        this.refreshTime = refreshTime;
    }

    @Generated
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    @Generated
    public void setSuIdList(List<?> suIdList) {
        this.suIdList = suIdList;
    }

    @Generated
    public void setStorageUnits(List<StorageUnits> storageUnits) {
        this.storageUnits = storageUnits;
    }

    @Generated
    public void setDsLockType(Integer dsLockType) {
        this.dsLockType = dsLockType;
    }

    @Generated
    public void setHostConnectProtocols(List<ConnectProtocol> hostConnectProtocols) {
        this.hostConnectProtocols = hostConnectProtocols;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataStore)) {
            return false;
        }
        DataStore other = (DataStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$clusterSize = this.getClusterSize();
        Integer other$clusterSize = other.getClusterSize();
        if (this$clusterSize == null ? other$clusterSize != null : !((Object)this$clusterSize).equals(other$clusterSize)) {
            return false;
        }
        Integer this$capacityGB = this.getCapacityGB();
        Integer other$capacityGB = other.getCapacityGB();
        if (this$capacityGB == null ? other$capacityGB != null : !((Object)this$capacityGB).equals(other$capacityGB)) {
            return false;
        }
        Integer this$usedSizeGB = this.getUsedSizeGB();
        Integer other$usedSizeGB = other.getUsedSizeGB();
        if (this$usedSizeGB == null ? other$usedSizeGB != null : !((Object)this$usedSizeGB).equals(other$usedSizeGB)) {
            return false;
        }
        Integer this$freeSizeGB = this.getFreeSizeGB();
        Integer other$freeSizeGB = other.getFreeSizeGB();
        if (this$freeSizeGB == null ? other$freeSizeGB != null : !((Object)this$freeSizeGB).equals(other$freeSizeGB)) {
            return false;
        }
        Boolean this$isThin = this.getIsThin();
        Boolean other$isThin = other.getIsThin();
        if (this$isThin == null ? other$isThin != null : !((Object)this$isThin).equals(other$isThin)) {
            return false;
        }
        Integer this$thinRate = this.getThinRate();
        Integer other$thinRate = other.getThinRate();
        if (this$thinRate == null ? other$thinRate != null : !((Object)this$thinRate).equals(other$thinRate)) {
            return false;
        }
        Integer this$actualCapacityGB = this.getActualCapacityGB();
        Integer other$actualCapacityGB = other.getActualCapacityGB();
        if (this$actualCapacityGB == null ? other$actualCapacityGB != null : !((Object)this$actualCapacityGB).equals(other$actualCapacityGB)) {
            return false;
        }
        Integer this$actualFreeSizeGB = this.getActualFreeSizeGB();
        Integer other$actualFreeSizeGB = other.getActualFreeSizeGB();
        if (this$actualFreeSizeGB == null ? other$actualFreeSizeGB != null : !((Object)this$actualFreeSizeGB).equals(other$actualFreeSizeGB)) {
            return false;
        }
        Integer this$dsLockType = this.getDsLockType();
        Integer other$dsLockType = other.getDsLockType();
        if (this$dsLockType == null ? other$dsLockType != null : !((Object)this$dsLockType).equals(other$dsLockType)) {
            return false;
        }
        String this$urn = this.getUrn();
        String other$urn = other.getUrn();
        if (this$urn == null ? other$urn != null : !this$urn.equals(other$urn)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$suUrn = this.getSuUrn();
        String other$suUrn = other.getSuUrn();
        if (this$suUrn == null ? other$suUrn != null : !this$suUrn.equals(other$suUrn)) {
            return false;
        }
        String this$suName = this.getSuName();
        String other$suName = other.getSuName();
        if (this$suName == null ? other$suName != null : !this$suName.equals(other$suName)) {
            return false;
        }
        String this$storageType = this.getStorageType();
        String other$storageType = other.getStorageType();
        if (this$storageType == null ? other$storageType != null : !this$storageType.equals(other$storageType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$refreshTime = this.getRefreshTime();
        String other$refreshTime = other.getRefreshTime();
        if (this$refreshTime == null ? other$refreshTime != null : !this$refreshTime.equals(other$refreshTime)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        List<?> this$suIdList = this.getSuIdList();
        List<?> other$suIdList = other.getSuIdList();
        if (this$suIdList == null ? other$suIdList != null : !((Object)this$suIdList).equals(other$suIdList)) {
            return false;
        }
        List<StorageUnits> this$storageUnits = this.getStorageUnits();
        List<StorageUnits> other$storageUnits = other.getStorageUnits();
        if (this$storageUnits == null ? other$storageUnits != null : !((Object)this$storageUnits).equals(other$storageUnits)) {
            return false;
        }
        List<ConnectProtocol> this$hostConnectProtocols = this.getHostConnectProtocols();
        List<ConnectProtocol> other$hostConnectProtocols = other.getHostConnectProtocols();
        return !(this$hostConnectProtocols == null ? other$hostConnectProtocols != null : !((Object)this$hostConnectProtocols).equals(other$hostConnectProtocols));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataStore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $clusterSize = this.getClusterSize();
        result = result * 59 + ($clusterSize == null ? 43 : ((Object)$clusterSize).hashCode());
        Integer $capacityGB = this.getCapacityGB();
        result = result * 59 + ($capacityGB == null ? 43 : ((Object)$capacityGB).hashCode());
        Integer $usedSizeGB = this.getUsedSizeGB();
        result = result * 59 + ($usedSizeGB == null ? 43 : ((Object)$usedSizeGB).hashCode());
        Integer $freeSizeGB = this.getFreeSizeGB();
        result = result * 59 + ($freeSizeGB == null ? 43 : ((Object)$freeSizeGB).hashCode());
        Boolean $isThin = this.getIsThin();
        result = result * 59 + ($isThin == null ? 43 : ((Object)$isThin).hashCode());
        Integer $thinRate = this.getThinRate();
        result = result * 59 + ($thinRate == null ? 43 : ((Object)$thinRate).hashCode());
        Integer $actualCapacityGB = this.getActualCapacityGB();
        result = result * 59 + ($actualCapacityGB == null ? 43 : ((Object)$actualCapacityGB).hashCode());
        Integer $actualFreeSizeGB = this.getActualFreeSizeGB();
        result = result * 59 + ($actualFreeSizeGB == null ? 43 : ((Object)$actualFreeSizeGB).hashCode());
        Integer $dsLockType = this.getDsLockType();
        result = result * 59 + ($dsLockType == null ? 43 : ((Object)$dsLockType).hashCode());
        String $urn = this.getUrn();
        result = result * 59 + ($urn == null ? 43 : $urn.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $suUrn = this.getSuUrn();
        result = result * 59 + ($suUrn == null ? 43 : $suUrn.hashCode());
        String $suName = this.getSuName();
        result = result * 59 + ($suName == null ? 43 : $suName.hashCode());
        String $storageType = this.getStorageType();
        result = result * 59 + ($storageType == null ? 43 : $storageType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $refreshTime = this.getRefreshTime();
        result = result * 59 + ($refreshTime == null ? 43 : $refreshTime.hashCode());
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        List<?> $suIdList = this.getSuIdList();
        result = result * 59 + ($suIdList == null ? 43 : ((Object)$suIdList).hashCode());
        List<StorageUnits> $storageUnits = this.getStorageUnits();
        result = result * 59 + ($storageUnits == null ? 43 : ((Object)$storageUnits).hashCode());
        List<ConnectProtocol> $hostConnectProtocols = this.getHostConnectProtocols();
        result = result * 59 + ($hostConnectProtocols == null ? 43 : ((Object)$hostConnectProtocols).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataStore(urn=" + this.getUrn() + ", uri=" + this.getUri() + ", suUrn=" + this.getSuUrn() + ", suName=" + this.getSuName() + ", storageType=" + this.getStorageType() + ", clusterSize=" + this.getClusterSize() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", capacityGB=" + this.getCapacityGB() + ", usedSizeGB=" + this.getUsedSizeGB() + ", freeSizeGB=" + this.getFreeSizeGB() + ", isThin=" + this.getIsThin() + ", thinRate=" + this.getThinRate() + ", actualCapacityGB=" + this.getActualCapacityGB() + ", actualFreeSizeGB=" + this.getActualFreeSizeGB() + ", refreshTime=" + this.getRefreshTime() + ", hosts=" + this.getHosts() + ", suIdList=" + this.getSuIdList() + ", storageUnits=" + this.getStorageUnits() + ", dsLockType=" + this.getDsLockType() + ", hostConnectProtocols=" + this.getHostConnectProtocols() + ")";
    }
}

