/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringUtils.class);

    public static boolean isAnyEmpty(String ... strings) {
        return Arrays.stream(strings).anyMatch(StringUtils::isEmpty);
    }

    public static boolean isEmpty(String source) {
        return source == null || source.isEmpty();
    }

    public static void cleanPwd(String pwd) {
        if (StringUtils.isEmpty(pwd)) {
            return;
        }
        try {
            Field stringValue = String.class.getDeclaredField("value");
            StringUtils.setAccessible(stringValue, true);
            char[] pwdChar = (char[])stringValue.get(pwd);
            Arrays.fill(pwdChar, '\u0000');
            StringUtils.setAccessible(stringValue, false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("Clean pwd Exception", (Throwable)e);
        }
    }

    private static void setAccessible(AccessibleObject accessibleObject, boolean isAccessible) {
        if (accessibleObject != null) {
            AccessController.doPrivileged(new MySetAccessiblePrivilegedAction(accessibleObject, isAccessible));
        }
    }

    @Generated
    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class MySetAccessiblePrivilegedAction
    implements PrivilegedAction<Boolean> {
        private final AccessibleObject ob;
        private final boolean isAccessible;

        private MySetAccessiblePrivilegedAction(AccessibleObject ob, boolean isAccessible) {
            this.ob = ob;
            this.isAccessible = isAccessible;
        }

        @Override
        public Boolean run() {
            this.ob.setAccessible(this.isAccessible);
            return true;
        }
    }
}

