/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lombok.Generated;

public final class VmConfigUtils {
    private static final String CONFIG_DIR = "configProperties";
    private static final String CONFIG_FILE_NAME = "deployvm.properties";
    private static final String DEFAULT_MEMORY_KEY = "deploy.edme.vm.memory";
    private static final String DEFAULT_MEMORY_TENANT_KEY = "deploy.edme.vm.tenant.memory";
    private static final String DEFAULT_CONTAINER_MEMORY = "deploy.edme.container.vm.memory";
    private static final String DEFAULT_CPU = "deploy.edme.vm.cpu";
    private static final String DEFAULT_TENANT_CPU = "deploy.edme.vm.tenant.cpu";
    private static final String DEFAULT_CONTAINER_CPU = "deploy.edme.container.vm.cpu";
    private static final String SYSTEM_DATASTORE = "deploy.edme.vm.system.datastore";
    private static final String SYSTEM_TENANT_DATASTORE = "deploy.edme.vm.system.datastore";
    private static final String SYSTEM_CONTAINER_DATASTORE = "deploy.edme.container.vm.system.datastore";
    private static final String CHECK_IP_TIMEOUT = "deploy.vm.check.ip.timeout";
    private static final String WAIT_TIME_AFTER_CHECK_IP = "deploy.vm.check.ip.wait";
    private static final String DATA_STORE_TYPES = "data.store.types";
    private static final String SKIP_DATASTORE_SELECT = "deploy.skip.datastore.select";
    private static final String DEFAULT_IMAGE = "deploy.vm.image";
    private static final String CONFIG_PATH = String.join((CharSequence)File.separator, "configProperties", "deployvm.properties");

    public static int getDefaultMemoryGb(int vmType, String managementLevel) {
        int memory = 0;
        switch (vmType) {
            case 0: {
                memory = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + DEFAULT_MEMORY_KEY)).orElse("64"), (int)64));
                break;
            }
            case 1: {
                memory = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + DEFAULT_MEMORY_TENANT_KEY)).orElse("64"), (int)64));
                break;
            }
            case 2: 
            case 3: {
                memory = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + DEFAULT_CONTAINER_MEMORY)).orElse("8"), (int)8));
                break;
            }
        }
        return memory;
    }

    public static int getDefaultTenantMemoryGb() {
        String defaultMemoryGb = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DEFAULT_MEMORY_TENANT_KEY).orElse("32");
        return Math.max(0, NumberUtils.parseInt((String)defaultMemoryGb, (int)32));
    }

    public static int getCheckIpTimeout() {
        String checkIpTimeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)CHECK_IP_TIMEOUT).orElse("15");
        return Math.max(0, NumberUtils.parseInt((String)checkIpTimeout, (int)15));
    }

    public static int getWaitTimeout() {
        String waitTimeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)WAIT_TIME_AFTER_CHECK_IP).orElse("10");
        return Math.max(0, NumberUtils.parseInt((String)waitTimeout, (int)10));
    }

    public static List<String> getDataStoreTypes() {
        String dataStoreTypes = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DATA_STORE_TYPES).orElse("LOCALPOME");
        return Arrays.asList(dataStoreTypes.split(";"));
    }

    public static int getSystemDatastoreSizeGb(int vmType, String managementLevel) {
        int systemDataStoreSizeGb = 0;
        switch (vmType) {
            case 0: {
                systemDataStoreSizeGb = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + "deploy.edme.vm.system.datastore")).orElse("55"), (int)55));
                break;
            }
            case 1: {
                systemDataStoreSizeGb = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + "deploy.edme.vm.system.datastore")).orElse("55"), (int)55));
                break;
            }
            case 2: 
            case 3: {
                systemDataStoreSizeGb = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + SYSTEM_CONTAINER_DATASTORE)).orElse("55"), (int)55));
                break;
            }
        }
        return systemDataStoreSizeGb;
    }

    public static boolean isSkipSelectDatastore() {
        return Boolean.parseBoolean(ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)SKIP_DATASTORE_SELECT).orElse("false"));
    }

    public static int getDefaultCpu(int vmType, String managementLevel) {
        int cpu = 0;
        switch (vmType) {
            case 0: {
                cpu = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + DEFAULT_CPU)).orElse("16"), (int)16));
                break;
            }
            case 1: {
                cpu = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + DEFAULT_TENANT_CPU)).orElse("16"), (int)16));
                break;
            }
            case 2: 
            case 3: {
                cpu = Math.max(0, NumberUtils.parseInt((String)ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)(managementLevel.toLowerCase(Locale.ROOT) + "." + DEFAULT_CONTAINER_CPU)).orElse("4"), (int)4));
                break;
            }
        }
        return cpu;
    }

    public static int getImageSizeGb() {
        String imageSize = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DEFAULT_IMAGE).orElse("2");
        return Math.max(0, NumberUtils.parseInt((String)imageSize, (int)2));
    }

    @Generated
    private VmConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

