/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.vm.system.util;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.infrastructure.ErrorResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.system.exception.VmException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public final class VmRequestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmRequestUtils.class);
    private static final String X_AUTH_USER = "X-Auth-User";
    private static final String X_AUTH_KEY = "X-Auth-Key";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT = "Accept";
    private static final String X_AUTH_AUTH_TYPE = "X-Auth-AuthType";
    private static final String X_AUTH_USER_TYPE = "X-Auth-UserType";
    private static final String X_ENCRYPT_ALGORITHM = "X-ENCRYPT-ALGORITHM";
    private static final String X_AUTH_TOKEN = "X-Auth-Token";
    private static final String ACCEPT_LANGUAGE = "Accept-Language";

    public static String getIdFromUrn(String urn) {
        if (!urn.contains(":")) {
            throw new VmException(ApiError.DATA_ERROR);
        }
        return urn.substring(urn.lastIndexOf(":") + 1);
    }

    public static <T> T dealResponse(Response<T> response) {
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        try {
            ErrorResponse errorResponse = response.errorBody() == null ? new ErrorResponse() : (ErrorResponse)JSON.parseObject((String)response.errorBody().string(), ErrorResponse.class);
            throw new VmException(ApiError.TASK_FAIL, Collections.singletonList(errorResponse == null ? "" : errorResponse.getErrorDes()));
        }
        catch (IOException e) {
            log.error("dealResponse error", (Throwable)e);
            throw new VmException(ApiError.DATA_ERROR);
        }
    }

    public static Map<String, String> buildLoginHeaders(String username, String password, int userType) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(X_AUTH_USER, username);
        header.put(X_AUTH_KEY, password);
        header.put(CONTENT_TYPE, "application/json; charset=UTF-8");
        header.put(ACCEPT, "application/json;version=8.1;charset=UTF-8");
        header.put(X_AUTH_AUTH_TYPE, "0");
        header.put(X_AUTH_USER_TYPE, String.valueOf(userType));
        header.put(X_ENCRYPT_ALGORITHM, "1");
        header.put(ACCEPT_LANGUAGE, LanguageUtils.getCurrentLanguage().isZh() ? "zh_CN" : "en_US");
        return header;
    }

    public static Map<String, String> buildHeaders(String token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(X_AUTH_TOKEN, token);
        header.put(CONTENT_TYPE, "application/json; charset=UTF-8");
        header.put(ACCEPT, "application/json;version=8.1;charset=UTF-8");
        header.put(ACCEPT_LANGUAGE, LanguageUtils.getCurrentLanguage().isZh() ? "zh_CN" : "en_US");
        return header;
    }

    public static Map<String, String> buildQueryDataStoreMap(@Nullable String hostUrn) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)hostUrn)) {
            queryMap.put("scope", hostUrn);
        }
        queryMap.put("accessible", "1");
        queryMap.put("exceptDatastoreType", "LUN");
        return queryMap;
    }

    public static Map<String, String> buildOsMap(String arch, String cpuVendor) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("arch", arch);
        queryMap.put("cpuVendor", cpuVendor);
        return queryMap;
    }

    public static Map<String, String> buildImageMap() {
        HashMap<String, String> imageQueryMap = new HashMap<String, String>();
        imageQueryMap.put("page", "1");
        imageQueryMap.put("offset", "0");
        imageQueryMap.put("limit", "100");
        return imageQueryMap;
    }

    public static Map<String, String> buildUploadMap(String fileName, long length, String siteId, String dataStoreId) {
        HashMap<String, String> applyQueryMap = new HashMap<String, String>();
        applyQueryMap.put("name", fileName);
        applyQueryMap.put("size", String.valueOf(length));
        applyQueryMap.put("siteID", siteId);
        applyQueryMap.put("dataStoreID", dataStoreId);
        applyQueryMap.put("client", "html5");
        return applyQueryMap;
    }

    @Generated
    private VmRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

