/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.dto.identity.GroupDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.identity.GroupMembersResource;
import org.camunda.bpm.engine.rest.sub.identity.GroupResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.GroupMembersResourceImpl;

public class GroupResourceImpl
extends AbstractIdentityResource
implements GroupResource {
    private String rootResourcePath;

    public GroupResourceImpl(String processEngineName, String groupId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.GROUP, groupId, objectMapper);
        this.rootResourcePath = rootResourcePath;
    }

    @Override
    public GroupDto getGroup(UriInfo context) {
        Group dbGroup = this.findGroupObject();
        if (dbGroup == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Group with id " + this.resourceId + " does not exist");
        }
        GroupDto group = GroupDto.fromGroup(dbGroup);
        return group;
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/group").path(this.resourceId).build(new Object[0]);
        dto.addReflexiveLink(uri, "GET", "self");
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.UPDATE)) {
            dto.addReflexiveLink(uri, "PUT", "update");
        }
        return dto;
    }

    @Override
    public void updateGroup(GroupDto group) {
        this.ensureNotReadOnly();
        Group dbGroup = this.findGroupObject();
        if (dbGroup == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Group with id " + this.resourceId + " does not exist");
        }
        group.update(dbGroup);
        this.identityService.saveGroup(dbGroup);
    }

    @Override
    public void deleteGroup() {
        this.ensureNotReadOnly();
        this.identityService.deleteGroup(this.resourceId);
    }

    @Override
    public GroupMembersResource getGroupMembersResource() {
        return new GroupMembersResourceImpl(this.getProcessEngine().getName(), this.resourceId, this.rootResourcePath, this.getObjectMapper());
    }

    protected Group findGroupObject() {
        try {
            return (Group)this.identityService.createGroupQuery().groupId(this.resourceId).singleResult();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "Exception while performing group query: " + e.getMessage());
        }
    }
}

