/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.assembler;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.CreateVmByImgCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.ImageUpdateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.OsCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.WatchDogCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.context.DeployHiCloudContext;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.context.DeployHiCloudRuntimeContext;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.ExecuteScriptCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.UnzipInstallToolCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.UploadServiceFileCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudResourceBundleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(imports={HiCloudResourceBundleUtils.class, DeployHiCloudContext.class})
public interface HiCLoudAssembler {
    @Mappings(value={@Mapping(target="templateId", expression="java(templateIdSupplier())"), @Mapping(target="vmIdHandler", expression="java(vmIdHandler())"), @Mapping(target="vmName", source="hostName"), @Mapping(target="isAutoStartVm", expression="java(false)"), @Mapping(target="watchDogCmd", expression="java(createWatchDogCmd())")})
    public CreateVmByTemplateCmd toCmd(HiCloudVmParam var1);

    public UploadServiceFileCmd toUploadServiceCmd(HiCloudParam var1);

    public ExecuteScriptCmd toExecuteScriptCmd(HiCloudParam var1);

    public UnzipInstallToolCmd toUnzipCmd(HiCloudParam var1);

    default public Consumer<String> vmIdHandler() {
        return vmId -> {
            DeployHiCloudContext.getInstance().addVmId((String)vmId);
            DeployHiCloudRuntimeContext.get().setVmId((String)vmId);
        };
    }

    default public Supplier<String> templateIdSupplier() {
        return () -> DeployHiCloudContext.getInstance().getTemplateId();
    }

    default public WatchDogCmd createWatchDogCmd() {
        return WatchDogCmd.builder().enableWatchDog(true).watchDogStrategy("none").watchDogPreTimeOut((int)TimeUnit.SECONDS.toSeconds(30L)).watchDogTimeOut((int)TimeUnit.SECONDS.toSeconds(900L)).build();
    }

    @Mappings(value={@Mapping(target="taskName", expression="java(HiCloudResourceBundleUtils.getTaskNameFromResource(\"deploy.hicloud.gkit\"))"), @Mapping(target="vmName", expression="java(\"Gkit\")"), @Mapping(target="vmIdHandler", expression="java(vmId -> DeployHiCloudContext.getInstance().addVmId(vmId))"), @Mapping(target="disks", source="vmParam"), @Mapping(target="osCmd", source="vmParam")})
    public CreateVmByImgCmd toCreateVmByImg(HiCloudVmParam var1, String var2, ImageUpdateCmd var3);

    default public OsCmd toOsCmd(HiCloudVmParam vmParam) {
        return OsCmd.builder().ip(vmParam.getAppOmIp()).userName("paas").userPwd(vmParam.getPaasPassword()).build();
    }

    default public List<Integer> toDisks(HiCloudVmParam vmParam) {
        ArrayList<Integer> disks = new ArrayList<Integer>();
        disks.add(vmParam.getSysDisk());
        disks.addAll(vmParam.getDiskCmds().stream().map(DiskCmd::getQuantityGB).collect(Collectors.toList()));
        return disks;
    }
}

