/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.assembler;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.CreateVmByImgCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.ImageUpdateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.assembler.HiCLoudAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.context.DeployHiCloudContext;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.ExecuteScriptCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.UnzipInstallToolCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.UploadServiceFileCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudResourceBundleUtils;
import java.util.ArrayList;
import java.util.List;

public class HiCLoudAssemblerImpl
implements HiCLoudAssembler {
    @Override
    public CreateVmByTemplateCmd toCmd(HiCloudVmParam vmParam) {
        if (vmParam == null) {
            return null;
        }
        CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder createVmByTemplateCmd = CreateVmByTemplateCmd.builder();
        createVmByTemplateCmd.vmName(vmParam.getHostName());
        createVmByTemplateCmd.cnaName(vmParam.getCnaName());
        createVmByTemplateCmd.datastoreName(vmParam.getDatastoreName());
        createVmByTemplateCmd.cpuCores(vmParam.getCpuCores());
        createVmByTemplateCmd.memorySizeGb(vmParam.getMemorySizeGb());
        createVmByTemplateCmd.hostName(vmParam.getHostName());
        List<VmNicConfigCmd> list = vmParam.getNicConfigs();
        if (list != null) {
            createVmByTemplateCmd.nicConfigs(new ArrayList<VmNicConfigCmd>(list));
        }
        createVmByTemplateCmd.templateId(this.templateIdSupplier());
        createVmByTemplateCmd.vmIdHandler(this.vmIdHandler());
        createVmByTemplateCmd.isAutoStartVm(false);
        createVmByTemplateCmd.watchDogCmd(this.createWatchDogCmd());
        return createVmByTemplateCmd.build();
    }

    @Override
    public UploadServiceFileCmd toUploadServiceCmd(HiCloudParam param) {
        if (param == null) {
            return null;
        }
        UploadServiceFileCmd.UploadServiceFileCmdBuilder uploadServiceFileCmd = UploadServiceFileCmd.builder();
        uploadServiceFileCmd.gkitVmParam(param.getGkitVmParam());
        uploadServiceFileCmd.templateParam(param.getTemplateParam());
        uploadServiceFileCmd.packagePath(param.getPackagePath());
        return uploadServiceFileCmd.build();
    }

    @Override
    public ExecuteScriptCmd toExecuteScriptCmd(HiCloudParam param) {
        if (param == null) {
            return null;
        }
        ExecuteScriptCmd.ExecuteScriptCmdBuilder executeScriptCmd = ExecuteScriptCmd.builder();
        executeScriptCmd.hiCloudPassword(param.getHiCloudPassword());
        executeScriptCmd.gkitVmParam(param.getGkitVmParam());
        return executeScriptCmd.build();
    }

    @Override
    public UnzipInstallToolCmd toUnzipCmd(HiCloudParam param) {
        if (param == null) {
            return null;
        }
        UnzipInstallToolCmd.UnzipInstallToolCmdBuilder unzipInstallToolCmd = UnzipInstallToolCmd.builder();
        unzipInstallToolCmd.gkitVmParam(param.getGkitVmParam());
        unzipInstallToolCmd.packagePath(param.getPackagePath());
        return unzipInstallToolCmd.build();
    }

    @Override
    public CreateVmByImgCmd toCreateVmByImg(HiCloudVmParam vmParam, String osVersionName, ImageUpdateCmd imageUpdateCmd) {
        if (vmParam == null && osVersionName == null && imageUpdateCmd == null) {
            return null;
        }
        CreateVmByImgCmd.CreateVmByImgCmdBuilder createVmByImgCmd = CreateVmByImgCmd.builder();
        if (vmParam != null) {
            createVmByImgCmd.disks(this.toDisks(vmParam));
            createVmByImgCmd.osCmd(this.toOsCmd(vmParam));
            createVmByImgCmd.cnaName(vmParam.getCnaName());
            createVmByImgCmd.datastoreName(vmParam.getDatastoreName());
            createVmByImgCmd.cpuCores(vmParam.getCpuCores());
            createVmByImgCmd.memorySizeGb(vmParam.getMemorySizeGb());
        }
        createVmByImgCmd.osVersionName(osVersionName);
        createVmByImgCmd.imageUpdateCmd(imageUpdateCmd);
        createVmByImgCmd.taskName(HiCloudResourceBundleUtils.getTaskNameFromResource("deploy.hicloud.gkit"));
        createVmByImgCmd.vmName("Gkit");
        createVmByImgCmd.vmIdHandler(vmId -> DeployHiCloudContext.getInstance().addVmId((String)vmId));
        return createVmByImgCmd.build();
    }
}

