/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.conversion.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.constant.HiCloudConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.context.DeployHiCloudContext;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.SshConnectHiCloudServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadImageFileTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadImageFileTask.class);
    public static final String TASK_NAME = "download.image.file.task";
    private HiCloudVmParam gKitVmParams;

    public void execute() throws TaskException {
        try (SshShellService shellService = SshConnectHiCloudServiceUtils.getShellClient(this.gKitVmParams);
             SshSftpService sftpService = SshConnectHiCloudServiceUtils.getSftpClient(this.gKitVmParams);){
            this.downloadImageFile(sftpService);
            this.clearUnnecessaryFiles(shellService);
        }
        catch (SshException sshException) {
            log.error("ssh execute error: ", (Throwable)sshException);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
        catch (Exception exception) {
            log.error("DownloadMirrorFilesTask Error: ", (Throwable)exception);
            throw new DeployHiCloudException(DeployHiCloudError.DOWNLOAD_IMAGE_FILE_FAILED);
        }
    }

    private String getImageFile(SshSftpService sftpService) throws SshException {
        return sftpService.ls("/home/paas").stream().filter(ConsistencyPattern::isQcow2File).findFirst().orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.DOWNLOAD_IMAGE_FILE_FAILED));
    }

    private void downloadImageFile(SshSftpService sftpService) throws SshException, TaskException {
        sftpService.connect();
        String imageFile = this.getImageFile(sftpService);
        String downloadPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{HiCloudConstant.ISO_CACHE_DIR, imageFile});
        sftpService.download(FilePathValidatorUtils.createLinuxPaths((String)"/home/paas", (String[])new String[]{imageFile}), downloadPath, (SftpProgCallback)new DefaultSftpProgCallback(imageFile));
        DeployHiCloudContext.getInstance().setHiCloudImageFilePath(downloadPath);
    }

    private void clearUnnecessaryFiles(SshShellService shellService) throws SshException {
        shellService.changeRootPermission(this.gKitVmParams.getRootPassword());
        shellService.execCommand("rm -rf qemu/ install_package/");
    }

    @Generated
    protected DownloadImageFileTask(DownloadImageFileTaskBuilder<?, ?> b) {
        super(b);
        this.gKitVmParams = ((DownloadImageFileTaskBuilder)b).gKitVmParams;
    }

    @Generated
    public static DownloadImageFileTaskBuilder<?, ?> builder() {
        return new DownloadImageFileTaskBuilderImpl();
    }

    @Generated
    private static final class DownloadImageFileTaskBuilderImpl
    extends DownloadImageFileTaskBuilder<DownloadImageFileTask, DownloadImageFileTaskBuilderImpl> {
        @Generated
        private DownloadImageFileTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DownloadImageFileTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DownloadImageFileTask build() {
            return new DownloadImageFileTask(this);
        }
    }

    @Generated
    public static abstract class DownloadImageFileTaskBuilder<C extends DownloadImageFileTask, B extends DownloadImageFileTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private HiCloudVmParam gKitVmParams;

        @Generated
        public B gKitVmParams(HiCloudVmParam gKitVmParams) {
            this.gKitVmParams = gKitVmParams;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DownloadImageFileTask.DownloadImageFileTaskBuilder(super=" + super.toString() + ", gKitVmParams=" + this.gKitVmParams + ")";
        }
    }
}

