/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.conversion.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.SshConnectHiCloudServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteScriptFileTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteScriptFileTask.class);
    public static final String TASK_NAME = "execute.script.file.task";
    private static final String SCRIPT_FILE_NAME = "update_image.sh";
    private HiCloudVmParam gKitVmParams;

    public void execute() throws TaskException {
        try (SshShellService sshShellService = SshConnectHiCloudServiceUtils.getShellClient(this.gKitVmParams);
             SshSftpService sftpService = SshConnectHiCloudServiceUtils.getSftpClient(this.gKitVmParams);){
            this.unzipFiles(sshShellService, this.getScriptFileName(sftpService));
            this.executeScript(sshShellService);
        }
        catch (SshException sshException) {
            log.error("ssh execute error: ", (Throwable)sshException);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
        catch (Exception exception) {
            log.error("Execute Script Error: ", (Throwable)exception);
            throw new DeployHiCloudException(DeployHiCloudError.EXECUTE_SCRIPT_FAILED);
        }
    }

    private String getScriptFileName(SshSftpService sftpService) throws SshException {
        sftpService.connect();
        return sftpService.ls("/home/paas").stream().filter(ConsistencyPattern::isHiCloudConversionScriptPackage).findFirst().orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.EXECUTE_SCRIPT_FAILED));
    }

    private void unzipFiles(SshShellService shellService, String zipFileName) throws SshException {
        int timeout = (int)TimeUnit.MINUTES.toSeconds(HiCloudConfigUtils.getUnzipTimeout());
        String unzipOutput = shellService.execCommandWithTimeout(StringUtils.formatTxt((String)"unzip %s", (Object[])new Object[]{zipFileName}), timeout);
        if (SshErrParser.isInvalidResult((String)unzipOutput)) {
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_UNZIP_INSTALL_TOOL_DIR_ERROR);
        }
    }

    private void executeScript(SshShellService shellService) throws SshException {
        shellService.changeRootPermission(this.gKitVmParams.getRootPassword());
        shellService.execCommand("mount /dev/cdrom /mnt");
        int timeout = (int)TimeUnit.MINUTES.toSeconds(HiCloudConfigUtils.getScriptExecutionTimeout());
        String scriptLog = shellService.execCommandWithTimeout(StringUtils.formatTxt((String)"sh %s", (Object[])new Object[]{SCRIPT_FILE_NAME}), timeout);
        log.error("execute update image result: {}", (Object)scriptLog);
        if (SshErrParser.isInvalidResult((String)scriptLog)) {
            throw new DeployHiCloudException(DeployHiCloudError.EXECUTE_SCRIPT_FAILED);
        }
        log.info("Script Execution Finished");
    }

    @Generated
    protected ExecuteScriptFileTask(ExecuteScriptFileTaskBuilder<?, ?> b) {
        super(b);
        this.gKitVmParams = ((ExecuteScriptFileTaskBuilder)b).gKitVmParams;
    }

    @Generated
    public static ExecuteScriptFileTaskBuilder<?, ?> builder() {
        return new ExecuteScriptFileTaskBuilderImpl();
    }

    @Generated
    private static final class ExecuteScriptFileTaskBuilderImpl
    extends ExecuteScriptFileTaskBuilder<ExecuteScriptFileTask, ExecuteScriptFileTaskBuilderImpl> {
        @Generated
        private ExecuteScriptFileTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecuteScriptFileTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecuteScriptFileTask build() {
            return new ExecuteScriptFileTask(this);
        }
    }

    @Generated
    public static abstract class ExecuteScriptFileTaskBuilder<C extends ExecuteScriptFileTask, B extends ExecuteScriptFileTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private HiCloudVmParam gKitVmParams;

        @Generated
        public B gKitVmParams(HiCloudVmParam gKitVmParams) {
            this.gKitVmParams = gKitVmParams;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ExecuteScriptFileTask.ExecuteScriptFileTaskBuilder(super=" + super.toString() + ", gKitVmParams=" + this.gKitVmParams + ")";
        }
    }
}

