/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.conversion.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudPackageFileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.SshConnectHiCloudServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadImageFilesTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadImageFilesTask.class);
    public static final String TASK_NAME = "upload.image.files.task";
    private final String fileSourcePath;
    private final HiCloudVmParam gKitVmParam;

    public void execute() throws TaskException {
        try (SshSftpService sftpService = SshConnectHiCloudServiceUtils.getSftpClient(this.gKitVmParam);){
            sftpService.connect();
            log.info("sftp connected");
            List<String> requiredFiles = HiCloudPackageFileUtils.getPackageFiles(this.fileSourcePath, ConsistencyPattern::isHiCloudConversionRequiredPackage);
            this.uploadRequiredFiles(requiredFiles, sftpService);
        }
        catch (SshException sshException) {
            log.error("ssh execute error: ", (Throwable)sshException);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
        catch (Exception exception) {
            log.error("UploadImageFilesTask Error: ", (Throwable)exception);
            throw new DeployHiCloudException(DeployHiCloudError.UPLOAD_IMAGE_FILE_FAILED);
        }
    }

    private void uploadRequiredFiles(List<String> requiredFiles, SshSftpService sftpService) throws SshException {
        List currentDirFiles = sftpService.ls("/home/paas");
        requiredFiles.stream().filter(file -> !currentDirFiles.contains(file)).forEach(fileName -> this.uploadFile((String)fileName, sftpService));
        ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
    }

    private void uploadFile(String fileName, SshSftpService sftpService) {
        try {
            sftpService.upload(FilePathValidatorUtils.joinChildPath((String[])new String[]{this.fileSourcePath, fileName}), "/home/paas", (SftpProgCallback)new DefaultSftpProgCallback(fileName));
        }
        catch (SshException sshException) {
            log.error("ssh execute error: ", (Throwable)sshException);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
    }

    @Generated
    protected UploadImageFilesTask(UploadImageFilesTaskBuilder<?, ?> b) {
        super(b);
        this.fileSourcePath = ((UploadImageFilesTaskBuilder)b).fileSourcePath;
        this.gKitVmParam = ((UploadImageFilesTaskBuilder)b).gKitVmParam;
    }

    @Generated
    public static UploadImageFilesTaskBuilder<?, ?> builder() {
        return new UploadImageFilesTaskBuilderImpl();
    }

    @Generated
    private static final class UploadImageFilesTaskBuilderImpl
    extends UploadImageFilesTaskBuilder<UploadImageFilesTask, UploadImageFilesTaskBuilderImpl> {
        @Generated
        private UploadImageFilesTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadImageFilesTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadImageFilesTask build() {
            return new UploadImageFilesTask(this);
        }
    }

    @Generated
    public static abstract class UploadImageFilesTaskBuilder<C extends UploadImageFilesTask, B extends UploadImageFilesTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private String fileSourcePath;
        @Generated
        private HiCloudVmParam gKitVmParam;

        @Generated
        public B fileSourcePath(String fileSourcePath) {
            this.fileSourcePath = fileSourcePath;
            return (B)this.self();
        }

        @Generated
        public B gKitVmParam(HiCloudVmParam gKitVmParam) {
            this.gKitVmParam = gKitVmParam;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UploadImageFilesTask.UploadImageFilesTaskBuilder(super=" + super.toString() + ", fileSourcePath=" + this.fileSourcePath + ", gKitVmParam=" + this.gKitVmParam + ")";
        }
    }
}

