/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.constant.HiCloudConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.ServiceStepTask;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.ExecuteScriptCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.SshConnectHiCloudServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiCloudAutoExecuteScriptTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HiCloudAutoExecuteScriptTask.class);
    public static final String TASK_NAME = "upload.hicloud.service.auto.install.script";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private boolean isExecuted;
    @NotNull
    private ExecuteScriptCmd cmd;

    public void beforeExecute() {
        if (this.isExecuted) {
            return;
        }
        this.isExecuted = true;
        try {
            SshShellService shellService = SshConnectHiCloudServiceUtils.getShellClient(this.cmd.getGkitVmParam());
            String stepConfig = shellService.execCommand(StringUtils.formatTxt((String)"cat %s", (Object[])new Object[]{HiCloudConstant.SCRIPT_CONFIG_PATH}));
            this.setSubTasks(Arrays.stream(stepConfig.split("\n")).filter(this::isValid).map(line -> line.split("\\|")).filter(info -> ((String[])info).length >= 4).map(this::buildTask).collect(Collectors.toList()));
        }
        catch (SshException e) {
            log.error("get step config failed", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.CONFIG_STEP_ERROR);
        }
    }

    public void execute() throws TaskException {
        try {
            SshShellService shellService = SshConnectHiCloudServiceUtils.getShellClient(this.cmd.getGkitVmParam());
            String cdResult = shellService.execCommand(StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{HiCloudConstant.HICLOUD_AUTO_EXECUTE_SCRIPT_PATH}));
            if (cdResult.toLowerCase(Locale.ENGLISH).contains("no such file or directory")) {
                log.error("The hicloud auto execute script directory does not exist");
                throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_AUTO_EXECUTE_SCRIPT_DIR_ERROR);
            }
            shellService.execCommand(StringUtils.formatTxt((String)"echo %s", (Object[])new Object[]{this.buildInitCmd()}));
            RetryUtils.retry(() -> this.getResult(shellService), this::isAllSubTaskSuccess, (int)180, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
    }

    private boolean isAllSubTaskSuccess(Map<String, BaseTaskResult> resultMap) {
        resultMap.forEach((id, result) -> this.getSubTasks().stream().filter(task -> id.equals(task.getTaskId())).findFirst().ifPresent(task -> task.setTaskResult(result)));
        this.getSubTasks().stream().filter(BaseTask::isErrorOrPaused).findFirst().ifPresent(task -> {
            throw new DeployHiCloudException(DeployHiCloudError.SERVICE_STEP_ERROR, Collections.singletonList(task.getTaskResult().getErrorMessage()));
        });
        return this.getSubTasks().stream().allMatch(BaseTask::isSuccess);
    }

    public void afterExecute() {
        SshManager.releaseSession((SshConnInfo)SshConnectHiCloudServiceUtils.getSshConnInfo(this.cmd.getGkitVmParam()));
    }

    private boolean isValid(String line) {
        return StringUtils.isNotEmpty((CharSequence)line) && !line.startsWith("#") && line.contains("|");
    }

    private String getDescription(String[] line) {
        if (LanguageUtils.getCurrentLanguage().isZh()) {
            return line.length >= 8 ? line[7] : "";
        }
        return line.length >= 9 ? line[8] : "";
    }

    BaseTask buildTask(String[] line) {
        return ((ServiceStepTask.ServiceStepTaskBuilder)((ServiceStepTask.ServiceStepTaskBuilder)((ServiceStepTask.ServiceStepTaskBuilder)((ServiceStepTask.ServiceStepTaskBuilder)ServiceStepTask.builder().taskId(line[1])).taskName(LanguageUtils.getCurrentLanguage().isZh() ? line[2] : line[1])).duration(line.length >= 7 ? NumberUtils.parseInt((String)line[6], (int)0) : 0)).taskDescription(this.getDescription(line))).build();
    }

    private Map<String, BaseTaskResult> getResult(SshShellService shellService) {
        try {
            String stepResult = shellService.execCommand(StringUtils.formatTxt((String)"cat %s", (Object[])new Object[]{HiCloudConstant.SCRIPT_RESULT_PATH}));
            return Arrays.stream(stepResult.split("\n")).filter(this::isValid).map(line -> line.split("\\|")).filter(info -> ((String[])info).length >= 4).collect(Collectors.toMap(result -> result[0], this::buildResult));
        }
        catch (SshException e) {
            throw new DeployHiCloudException(DeployHiCloudError.CONFIG_STEP_ERROR);
        }
    }

    private BaseTaskResult buildResult(String[] result) {
        BaseTaskResult baseTaskResult = new BaseTaskResult();
        baseTaskResult.setStartTime(LocalDateTime.parse(result[1], DATE_TIME_FORMATTER));
        TaskStatus taskStatus = HiCloudConstant.TASK_STATUS_MAP.entrySet().stream().filter(entry -> result[3].startsWith((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(TaskStatus.ERROR);
        baseTaskResult.setTaskStatus(taskStatus);
        if (TaskStatus.isFinishStatus((TaskStatus)taskStatus)) {
            baseTaskResult.setEndTime(LocalDateTime.parse(result[2], DATE_TIME_FORMATTER));
        }
        if (result.length >= 5) {
            baseTaskResult.setErrorMessage(result[4]);
        }
        return baseTaskResult;
    }

    private String buildInitCmd() {
        String pwd = JsonUtils.toJson((Object)this.cmd.getHiCloudPassword());
        return StringUtils.formatTxt((String)"'%s' | %s", (Object[])new Object[]{pwd, "sh install.sh -i -s"});
    }

    @Generated
    protected HiCloudAutoExecuteScriptTask(HiCloudAutoExecuteScriptTaskBuilder<?, ?> b) {
        super(b);
        this.isExecuted = ((HiCloudAutoExecuteScriptTaskBuilder)b).isExecuted;
        this.cmd = ((HiCloudAutoExecuteScriptTaskBuilder)b).cmd;
        if (this.cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
    }

    @Generated
    public static HiCloudAutoExecuteScriptTaskBuilder<?, ?> builder() {
        return new HiCloudAutoExecuteScriptTaskBuilderImpl();
    }

    @Generated
    private static final class HiCloudAutoExecuteScriptTaskBuilderImpl
    extends HiCloudAutoExecuteScriptTaskBuilder<HiCloudAutoExecuteScriptTask, HiCloudAutoExecuteScriptTaskBuilderImpl> {
        @Generated
        private HiCloudAutoExecuteScriptTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected HiCloudAutoExecuteScriptTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HiCloudAutoExecuteScriptTask build() {
            return new HiCloudAutoExecuteScriptTask(this);
        }
    }

    @Generated
    public static abstract class HiCloudAutoExecuteScriptTaskBuilder<C extends HiCloudAutoExecuteScriptTask, B extends HiCloudAutoExecuteScriptTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private boolean isExecuted;
        @Generated
        private ExecuteScriptCmd cmd;

        @Generated
        public B isExecuted(boolean isExecuted) {
            this.isExecuted = isExecuted;
            return (B)this.self();
        }

        @Generated
        public B cmd(@NotNull ExecuteScriptCmd cmd) {
            this.cmd = cmd;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "HiCloudAutoExecuteScriptTask.HiCloudAutoExecuteScriptTaskBuilder(super=" + super.toString() + ", isExecuted=" + this.isExecuted + ", cmd=" + this.cmd + ")";
        }
    }
}

