/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.constant.HiCloudConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.UnzipInstallToolCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudPackageFileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.SshConnectHiCloudServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipInstallToolTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnzipInstallToolTask.class);
    public static final String TASK_NAME = "upload.hicloud.service.unzip.install.tool";
    private static final int TIMEOUT = (int)TimeUnit.MINUTES.toSeconds(HiCloudConfigUtils.getUnzipTimeout());
    @NotNull
    private UnzipInstallToolCmd cmd;

    public void execute() throws TaskException {
        try (SshShellService shellService = SshConnectHiCloudServiceUtils.getShellClient(this.cmd.getGkitVmParam());){
            String cdResult = shellService.execCommand(StringUtils.formatTxt((String)"cd %s", (Object[])new Object[]{HiCloudConstant.TARGET_UPLOAD_PATH}));
            if (SshErrParser.isInvalidResult((String)cdResult)) {
                log.error("cd HiCloud directory failed.");
                throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_UNZIP_INSTALL_TOOL_DIR_ERROR);
            }
            String result = shellService.execCommandWithTimeout(StringUtils.formatTxt((String)"unzip -o %s", (Object[])new Object[]{HiCloudPackageFileUtils.getUnzipFile(this.cmd.getPackagePath()).getName()}), TIMEOUT);
            log.info("unzip HiCloud Package, result = {}", (Object)result);
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_AUTO_INSTALL_TOOL_UNZIP_ERROR);
        }
    }

    @Generated
    protected UnzipInstallToolTask(UnzipInstallToolTaskBuilder<?, ?> b) {
        super(b);
        this.cmd = ((UnzipInstallToolTaskBuilder)b).cmd;
        if (this.cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
    }

    @Generated
    public static UnzipInstallToolTaskBuilder<?, ?> builder() {
        return new UnzipInstallToolTaskBuilderImpl();
    }

    @Generated
    private static final class UnzipInstallToolTaskBuilderImpl
    extends UnzipInstallToolTaskBuilder<UnzipInstallToolTask, UnzipInstallToolTaskBuilderImpl> {
        @Generated
        private UnzipInstallToolTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UnzipInstallToolTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UnzipInstallToolTask build() {
            return new UnzipInstallToolTask(this);
        }
    }

    @Generated
    public static abstract class UnzipInstallToolTaskBuilder<C extends UnzipInstallToolTask, B extends UnzipInstallToolTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private UnzipInstallToolCmd cmd;

        @Generated
        public B cmd(@NotNull UnzipInstallToolCmd cmd) {
            this.cmd = cmd;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UnzipInstallToolTask.UnzipInstallToolTaskBuilder(super=" + super.toString() + ", cmd=" + this.cmd + ")";
        }
    }
}

