/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.constant.HiCloudConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.cmd.UploadServiceFileCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudPackageFileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.SshConnectHiCloudServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServiceDeployFilesTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadServiceDeployFilesTask.class);
    public static final String TASK_NAME = "upload.hicloud.service.deploy.files";
    @NotNull
    private UploadServiceFileCmd cmd;

    public void execute() throws TaskException {
        this.buildNeedDir();
        this.uploadServiceDeployFiles();
    }

    private void uploadServiceDeployFiles() throws DeployHiCloudException {
        try (SshSftpService sftpService = SshConnectHiCloudServiceUtils.getSftpClient(this.cmd.getGkitVmParam());){
            sftpService.connect();
            HiCloudPackageFileUtils.getPackageFiles(this.cmd.getPackagePath()).forEach(file -> this.uploadFile(sftpService, (File)file));
            this.uploadFile(sftpService, this.createTemplateParameterFile());
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("uploadServiceDeployFiles error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.UPLOAD_PACKAGE_FAILED);
        }
    }

    private void buildNeedDir() throws DeployHiCloudException {
        try (SshShellService shellService = SshConnectHiCloudServiceUtils.getShellClient(this.cmd.getGkitVmParam());){
            shellService.execCommand(StringUtils.formatTxt((String)"rm -rf %s", (Object[])new Object[]{HiCloudConstant.TARGET_UPLOAD_PATH}));
            shellService.execCommand(StringUtils.formatTxt((String)"mkdir -p %s", (Object[])new Object[]{HiCloudConstant.TARGET_UPLOAD_PATH}));
        }
        catch (SshException e) {
            log.error("ssh execute error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_SSH_CONNECT_ERROR);
        }
    }

    private void uploadFile(SshSftpService sftpService, File file) {
        String fileName = file.getName();
        log.info("upload file: {}", (Object)fileName);
        String path = (String)FilePathValidatorUtils.getSafePath((File)file).orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
        try {
            if (sftpService.upload(path, HiCloudConstant.TARGET_UPLOAD_PATH, (SftpProgCallback)new DefaultSftpProgCallback(fileName))) {
                return;
            }
        }
        catch (SshException e) {
            log.error("Failed to upload {}", (Object)fileName, (Object)e);
        }
        throw new DeployHiCloudException(DeployHiCloudError.UPLOAD_PACKAGE_FAILED);
    }

    private File createTemplateParameterFile() {
        log.info("start to create template_parameter.json.");
        File file = new File(HiCloudConstant.HICLOUD_TEMPLATE_PARAMETER_JSON_PATH);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_CREATE_TEMPLATE_PARAMETER_ERROR);
        }
        String result = JsonUtils.toJson((Object)this.cmd.getTemplateParam());
        try (FileWriter fileWriter = new FileWriter(file, false);){
            fileWriter.write(result);
        }
        catch (IOException e) {
            log.error("creat json error", (Throwable)e);
            throw new DeployHiCloudException(DeployHiCloudError.HICLOUD_CREATE_TEMPLATE_PARAMETER_ERROR);
        }
        log.info("finish to create template_parameter.json.");
        return file;
    }

    @Generated
    protected UploadServiceDeployFilesTask(UploadServiceDeployFilesTaskBuilder<?, ?> b) {
        super(b);
        this.cmd = ((UploadServiceDeployFilesTaskBuilder)b).cmd;
        if (this.cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
    }

    @Generated
    public static UploadServiceDeployFilesTaskBuilder<?, ?> builder() {
        return new UploadServiceDeployFilesTaskBuilderImpl();
    }

    @Generated
    private static final class UploadServiceDeployFilesTaskBuilderImpl
    extends UploadServiceDeployFilesTaskBuilder<UploadServiceDeployFilesTask, UploadServiceDeployFilesTaskBuilderImpl> {
        @Generated
        private UploadServiceDeployFilesTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadServiceDeployFilesTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadServiceDeployFilesTask build() {
            return new UploadServiceDeployFilesTask(this);
        }
    }

    @Generated
    public static abstract class UploadServiceDeployFilesTaskBuilder<C extends UploadServiceDeployFilesTask, B extends UploadServiceDeployFilesTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private UploadServiceFileCmd cmd;

        @Generated
        public B cmd(@NotNull UploadServiceFileCmd cmd) {
            this.cmd = cmd;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UploadServiceDeployFilesTask.UploadServiceDeployFilesTaskBuilder(super=" + super.toString() + ", cmd=" + this.cmd + ")";
        }
    }
}

