/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.vm;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.AttachDiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.CreateVmByImgCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.ImageUpdateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcTaskService;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.assembler.HiCLoudAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.constant.HiCloudConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.context.DeployHiCloudContext;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.context.DeployHiCloudRuntimeContext;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.conversion.DeployConversionFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.vm.DeployHiCloudVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.vm.subtask.BatchCreateVmTask;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.vm.subtask.VmStatusCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudImageUpdateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudPackageFileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudResourceBundleUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.DeployVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageUpdate;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeployVmsFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployVmsFactory.class);
    private static final HiCLoudAssembler ASSEMBLER = (HiCLoudAssembler)Mappers.getMapper(HiCLoudAssembler.class);

    public static BaseTask createDeployVmsTask(HiCloudParam param) {
        return ((DeployHiCloudVmsTask.DeployHiCloudVmsTaskBuilder)((DeployHiCloudVmsTask.DeployHiCloudVmsTaskBuilder)((DeployHiCloudVmsTask.DeployHiCloudVmsTaskBuilder)((DeployHiCloudVmsTask.DeployHiCloudVmsTaskBuilder)((DeployHiCloudVmsTask.DeployHiCloudVmsTaskBuilder)((DeployHiCloudVmsTask.DeployHiCloudVmsTaskBuilder)DeployHiCloudVmsTask.builder().taskId(param.getTaskId())).taskName(HiCloudResourceBundleUtils.getTaskNameFromResource("deploy.hicloud.vm.check"))).duration(HiCloudResourceBundleUtils.getDurationFromResource("deploy.hicloud.vm.check"))).subTasks(DeployVmsFactory.createSubTasks(param))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).eventType("hiCloudVmDeployEvent")).build();
    }

    private static List<BaseTask> createSubTasks(HiCloudParam param) {
        ArrayList<BaseTask> subTasks = new ArrayList<BaseTask>();
        subTasks.add(DeployVmsFactory.createEnvironmentCheck(param));
        subTasks.add((BaseTask)FcTaskService.createVmByImageTask((CreateVmByImgCmd)ASSEMBLER.toCreateVmByImg(param.getGkitVmParam(), param.getGkitOsVersionName(), DeployVmsFactory.buildImgUpdate(param)), (FcLoginInfo)param.getFcLoginInfo()));
        subTasks.add(DeployConversionFactory.createDeployConversionTask(param));
        subTasks.add((BaseTask)FcTaskService.uploadTemplateTask((UploadTemplateCmd)DeployVmsFactory.buildHiCloudUploadTemplateCmd(param), (FcLoginInfo)param.getFcLoginInfo()));
        subTasks.add(DeployVmsFactory.createVmsTask(param));
        subTasks.add(DeployVmsFactory.createVmCheckTask(param.getVmParams(), param.getFcLoginInfo()));
        subTasks.forEach(task -> task.setEventType("hiCloudVmDeployEvent"));
        subTasks.forEach(task -> task.setSupportOperates(Collections.singletonList(TaskOperateEnum.RETRY)));
        return subTasks;
    }

    private static ImageUpdateCmd buildImgUpdate(HiCloudParam param) {
        HiCloudVmParam gkitVmParam = param.getGkitVmParam();
        File imageFile = HiCloudPackageFileUtils.getGKitImagePackageFile(param.getPackagePath());
        return ImageUpdateCmd.builder().path(DeployVmsFactory.imagePathSupplier(imageFile)).ip(gkitVmParam.getAppOmIp()).updateOperate(path -> HiCloudImageUpdateUtils.updateImages(DeployVmsFactory.buildImageUpdate(imageFile, gkitVmParam), param.getPackagePath(), path)).build();
    }

    private static Supplier<String> imagePathSupplier(File imageFile) {
        return () -> {
            Optional imagePath = FilePathValidatorUtils.getSafePath((File)imageFile);
            if (!imagePath.isPresent()) {
                return "";
            }
            if (!ZipUtils.decompressFileBy7Zip((String)ImageConstant.ZIP_TOOL_PATH, (String)((String)imagePath.get()), (String)HiCloudConstant.ISO_CACHE_DIR)) {
                return "";
            }
            return FilePathValidatorUtils.getSafePath((File)HiCloudPackageFileUtils.getGKitIsoFile(HiCloudConstant.ISO_CACHE_DIR)).orElse("");
        };
    }

    private static ImageUpdate buildImageUpdate(File imageFile, HiCloudVmParam gkitVmParam) {
        String imagePath = (String)FilePathValidatorUtils.getSafePath((File)imageFile).orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
        VmNicConfigCmd nicConfig = gkitVmParam.getNicConfigs().get(0);
        return ImageUpdate.builder().path(imagePath).repackageIsoName(imageFile.getName()).diskNum(gkitVmParam.getDiskCmds().size()).rootPassword(gkitVmParam.getRootPassword()).grubPassword(gkitVmParam.getRootPassword()).paasPassword(gkitVmParam.getPaasPassword()).ip(gkitVmParam.getAppOmIp()).netMask(nicConfig.getNetmask()).gateway(nicConfig.getGateway()).netDevice(imageFile.getName().toLowerCase(Locale.ROOT).contains("x86") ? "enp4s1" : "enp4s0").build();
    }

    private static BaseTask createVmsTask(HiCloudParam param) {
        return ((BatchCreateVmTask.BatchCreateVmTaskBuilder)((BatchCreateVmTask.BatchCreateVmTaskBuilder)((BatchCreateVmTask.BatchCreateVmTaskBuilder)((BatchCreateVmTask.BatchCreateVmTaskBuilder)BatchCreateVmTask.builder().taskName(HiCloudResourceBundleUtils.getTaskNameFromResource("deploy.hicloud.vms.batch"))).duration(HiCloudResourceBundleUtils.getDurationFromResource("deploy.hicloud.vms.batch"))).subTasks(DeployVmsFactory.createVmByTemplateSubTasks(param))).isExecuteSubTasks(false)).build();
    }

    private static UploadTemplateCmd buildHiCloudUploadTemplateCmd(HiCloudParam param) {
        return UploadTemplateCmd.builder().filePath(() -> DeployHiCloudContext.getInstance().getHiCloudImageFilePath()).cnaName(param.getGkitVmParam().getCnaName()).datastoreName(param.getGkitVmParam().getDatastoreName()).osVersionName(param.getOsVersionName()).templateName("HiCloud_Template").templateIdHandler(templateId -> DeployHiCloudContext.getInstance().setTemplateId((String)templateId)).build();
    }

    private static List<BaseTask> createVmByTemplateSubTasks(HiCloudParam param) {
        List<BaseTask> subTask = param.getVmParams().stream().map(vmParam -> DeployVmsFactory.createVmTask(param, vmParam)).collect(Collectors.toList());
        subTask.forEach(task -> task.setEventType("hiCloudVmDeployEvent"));
        subTask.forEach(task -> task.setSupportOperates(Collections.singletonList(TaskOperateEnum.RETRY)));
        return subTask;
    }

    private static DeployVmsTask createVmTask(HiCloudParam param, HiCloudVmParam vmParam) {
        List<BaseTask> subTasks = Arrays.asList(FcTaskService.createVmByTemplateTask((CreateVmByTemplateCmd)ASSEMBLER.toCmd(vmParam), (FcLoginInfo)param.getFcLoginInfo()), DeployVmsFactory.buildAttachDiskTask(vmParam.getDiskCmds(), param.getFcLoginInfo()), FcTaskService.createStartVmTask((FcLoginInfo)param.getFcLoginInfo(), (boolean)true));
        return ((DeployVmsTask.DeployVmsTaskBuilder)((DeployVmsTask.DeployVmsTaskBuilder)((DeployVmsTask.DeployVmsTaskBuilder)DeployVmsTask.builder().cnaName(vmParam.getCnaName()).taskName(vmParam.getHostName())).duration(2)).subTasks(subTasks)).build();
    }

    private static BaseTask buildAttachDiskTask(List<DiskCmd> diskCmds, FcLoginInfo fcLoginInfo) {
        AttachDiskCmd attachDiskCmd = AttachDiskCmd.builder().vmId(() -> DeployHiCloudRuntimeContext.get().getVmId()).diskCmds(diskCmds).build();
        return FcTaskService.createAttachDiskTask((AttachDiskCmd)attachDiskCmd, (FcLoginInfo)fcLoginInfo);
    }

    private static BaseTask createVmCheckTask(List<HiCloudVmParam> param, FcLoginInfo fcLoginInfo) {
        return ((VmStatusCheckTask.VmStatusCheckTaskBuilder)((Object)((VmStatusCheckTask.VmStatusCheckTaskBuilder)((Object)((VmStatusCheckTask.VmStatusCheckTaskBuilder)((VmStatusCheckTask.VmStatusCheckTaskBuilder)VmStatusCheckTask.builder().taskName(HiCloudResourceBundleUtils.getTaskNameFromResource("deploy.hicloud.vm.check"))).duration(HiCloudResourceBundleUtils.getDurationFromResource("deploy.hicloud.vm.check"))).vmParams(param))).fcLoginInfo(fcLoginInfo))).build();
    }

    private static BaseTask createEnvironmentCheck(HiCloudParam hiCloudParam) {
        return FcTaskService.createEnvironmentCheckTask((EnvironmentCheckCmd)DeployVmsFactory.buildEnvironmentCmd(hiCloudParam), (FcLoginInfo)hiCloudParam.getFcLoginInfo());
    }

    private static EnvironmentCheckCmd buildEnvironmentCmd(HiCloudParam hiCloudParam) {
        EnvironmentCheckCmd environmentCheckCmd = EnvironmentCheckCmd.builder().oldVmIds(() -> DeployHiCloudContext.getInstance().getVmIds()).build();
        hiCloudParam.getVmParams().forEach(vmParam -> DeployVmsFactory.computeResources(environmentCheckCmd, vmParam));
        DeployVmsFactory.computeResources(environmentCheckCmd, hiCloudParam.getGkitVmParam());
        return environmentCheckCmd;
    }

    static void computeResources(EnvironmentCheckCmd environmentCheckCmd, HiCloudVmParam hiCloudVmParam) {
        hiCloudVmParam.getDiskCmds().forEach(diskCmd -> environmentCheckCmd.addDatastore(diskCmd.getDateStoreName(), diskCmd.getQuantityGB()));
        environmentCheckCmd.addDatastore(hiCloudVmParam.getDatastoreName(), 40);
        environmentCheckCmd.addMemory(hiCloudVmParam.getCnaName(), hiCloudVmParam.getMemorySizeGb());
        environmentCheckCmd.addCpu(hiCloudVmParam.getCnaName(), hiCloudVmParam.getCpuCores());
    }

    @Generated
    private DeployVmsFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

