/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.vm.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.UploadTemplateTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.DeployVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.DeployVmsTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;

public class BatchCreateVmTask
extends BaseTask {
    public static final String NAME_KEY = "deploy.hicloud.vms.batch";

    public void execute() throws TaskException {
        this.getSubTasks().stream().filter(task -> task instanceof UploadTemplateTask).map(UploadTemplateTask.class::cast).findFirst().ifPresent(BaseTask::run);
        List<DeployVmsTask> vmTasks = this.getSubTasks().stream().filter(task -> task instanceof DeployVmsTask).map(DeployVmsTask.class::cast).collect(Collectors.toList());
        DeployVmsTaskManager.getInstance().addAndStartTask(vmTasks);
        RetryUtils.retry(() -> this.isTaskFinish(vmTasks), result -> result, (int)60, (TimeUnit)TimeUnit.MINUTES);
        if (!this.isTaskSuccess(vmTasks)) {
            throw new DeployHiCloudException(DeployHiCloudError.DEPLOY_VM_FAILED);
        }
    }

    private boolean isTaskSuccess(List<DeployVmsTask> vmTasks) {
        return vmTasks.stream().map(task -> this.queryTask(task.getTaskId())).allMatch(BaseTask::isSuccess);
    }

    private boolean isTaskFinish(List<DeployVmsTask> vmTasks) {
        return vmTasks.stream().map(task -> this.queryTask(task.getTaskId())).allMatch(BaseTask::isFinish);
    }

    private BaseTask queryTask(String taskId) {
        return (BaseTask)CommonTaskManager.getInstance().queryTaskById(taskId).orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.TASK_NOT_EXIST));
    }

    @Generated
    protected BatchCreateVmTask(BatchCreateVmTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static BatchCreateVmTaskBuilder<?, ?> builder() {
        return new BatchCreateVmTaskBuilderImpl();
    }

    @Generated
    private static final class BatchCreateVmTaskBuilderImpl
    extends BatchCreateVmTaskBuilder<BatchCreateVmTask, BatchCreateVmTaskBuilderImpl> {
        @Generated
        private BatchCreateVmTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected BatchCreateVmTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BatchCreateVmTask build() {
            return new BatchCreateVmTask(this);
        }
    }

    @Generated
    public static abstract class BatchCreateVmTaskBuilder<C extends BatchCreateVmTask, B extends BatchCreateVmTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BatchCreateVmTask.BatchCreateVmTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

