/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.vm.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.context.DeployHiCloudContext;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmStatusCheckTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmStatusCheckTask.class);
    public static final String TASK_NAME = "deploy.hicloud.vm.check";
    private List<HiCloudVmParam> vmParams;
    private FcLoginInfo fcLoginInfo;

    public void execute() throws TaskException {
        try {
            RetryUtils.retry(this::checkAllIpReachable, (int)30, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (TaskException e) {
            log.error("execute time out", (Throwable)e);
            this.appendTaskDetail("execute time out");
            throw new DeployHiCloudException(DeployHiCloudError.IP_CHECK_FAILED);
        }
        DeployHiCloudContext deployHiCloudContext = DeployHiCloudContext.getInstance();
        FcClientService.createApiService((FcLoginInfo)this.fcLoginInfo).deleteVm(deployHiCloudContext.getTemplateId());
        log.info("delete template {}", (Object)deployHiCloudContext.getTemplateId());
        this.appendTaskDetail("delete HiCloud template, id:" + deployHiCloudContext.getTemplateId());
        log.info("execute clear resource task");
    }

    private Boolean checkAllIpReachable() {
        return this.vmParams.stream().allMatch(p -> IpUtils.isReachable((String)p.getAppOmIp()));
    }

    @Generated
    protected VmStatusCheckTask(VmStatusCheckTaskBuilder<?, ?> b) {
        super(b);
        this.vmParams = ((VmStatusCheckTaskBuilder)b).vmParams;
        this.fcLoginInfo = ((VmStatusCheckTaskBuilder)b).fcLoginInfo;
    }

    @Generated
    public static VmStatusCheckTaskBuilder<?, ?> builder() {
        return new VmStatusCheckTaskBuilderImpl();
    }

    @Generated
    private static final class VmStatusCheckTaskBuilderImpl
    extends VmStatusCheckTaskBuilder<VmStatusCheckTask, VmStatusCheckTaskBuilderImpl> {
        @Generated
        private VmStatusCheckTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected VmStatusCheckTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VmStatusCheckTask build() {
            return new VmStatusCheckTask(this);
        }
    }

    @Generated
    public static abstract class VmStatusCheckTaskBuilder<C extends VmStatusCheckTask, B extends VmStatusCheckTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private List<HiCloudVmParam> vmParams;
        @Generated
        private FcLoginInfo fcLoginInfo;

        @Generated
        public B vmParams(List<HiCloudVmParam> vmParams) {
            this.vmParams = vmParams;
            return (B)this.self();
        }

        @Generated
        public B fcLoginInfo(FcLoginInfo fcLoginInfo) {
            this.fcLoginInfo = fcLoginInfo;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VmStatusCheckTask.VmStatusCheckTaskBuilder(super=" + super.toString() + ", vmParams=" + this.vmParams + ", fcLoginInfo=" + this.fcLoginInfo + ")";
        }
    }
}

