/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public final class HiCloudConfigUtils {
    private static final String TEMPLATE_ID = "templateId";
    private static final String UNZIP_TIME_OUT = "unzip.time.out";
    private static final String SCRIPT_TIME_OUT = "script.time.out";
    private static final String DME_NBI_PORT = "dme.nbi.port";
    private static final String DME_SBI_PORT = "dme.sbi.port";
    private static final String DME_OC_PORT = "dme.oc.port";
    private static final String GDE_RESERVATION_IP_ADDRESS = "gde.reservation.ip.address";
    private static final String GDE_RESERVATION_NETWORK_MASK = "gde.reservation.network.mask";
    private static final String CONFIG_PATH = String.join((CharSequence)File.separator, "configProperties", "deployhicloud.properties");

    public static String getTemplateId() {
        return ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)TEMPLATE_ID).orElse("");
    }

    public static int getUnzipTimeout() {
        String timeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)UNZIP_TIME_OUT).orElse("5");
        return Math.max(0, NumberUtils.parseInt((String)timeout, (int)5));
    }

    public static String getDmeNbiPort() {
        return ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DME_NBI_PORT).orElse("27335");
    }

    public static String getDmeSbiPort() {
        return ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DME_SBI_PORT).orElse("27336");
    }

    public static String getDmeOcPort() {
        return ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DME_OC_PORT).orElse("31943");
    }

    public static int getScriptExecutionTimeout() {
        String timeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)SCRIPT_TIME_OUT).orElse("5");
        return Math.max(0, NumberUtils.parseInt((String)timeout, (int)5));
    }

    public static String getGdeReservationNetworkMask() {
        return ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)GDE_RESERVATION_NETWORK_MASK).orElse("255.255.0.0");
    }

    public static List<String> getGdeReservationIpAddress() {
        return Arrays.asList(ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)GDE_RESERVATION_IP_ADDRESS).orElse("10.247.0.0,172.16.0.0,172.18.0.0").split(","));
    }

    @Generated
    private HiCloudConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

