/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.LineSeparator;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.constant.HiCloudConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils.HiCloudPackageFileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileContentOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageUpdate;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.digest.Crypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiCloudImageUpdateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HiCloudImageUpdateUtils.class);

    public static synchronized String updateImages(ImageUpdate imageUpdate, String packagePath, String isoPath) {
        String vmToolPath = (String)FilePathValidatorUtils.getSafePath((File)HiCloudPackageFileUtils.getVmToolPackage(packagePath)).orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
        ZipUtils.decompressFileBy7Zip((String)ImageConstant.ZIP_TOOL_PATH, (String)vmToolPath, (String)HiCloudConstant.ISO_CACHE_DIR);
        String toolPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{HiCloudConstant.ISO_CACHE_DIR, "install_package", imageUpdate.getEulerVersion()});
        if (!HiCloudImageUpdateUtils.replaceKsContents(imageUpdate, isoPath, toolPath)) {
            return "replace ks contents failed";
        }
        if (!HiCloudImageUpdateUtils.replaceGrubFile(imageUpdate, isoPath, toolPath)) {
            return "replace grub file failed";
        }
        if (!HiCloudImageUpdateUtils.replaceIsoLinuxFile(imageUpdate, isoPath, toolPath)) {
            return "replace iso file failed";
        }
        return "";
    }

    private static boolean replaceKsContents(ImageUpdate imageUpdate, String cacheDir, String toolPath) {
        String template = FilePathValidatorUtils.joinChildPath((String[])new String[]{toolPath, "ks", "ks.cfg"});
        String ksPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, "ks", "ks.cfg"});
        File ksFile = new File(ksPath);
        if (ksFile.exists() && !ksFile.delete()) {
            log.error("delete original ks file failed");
            return false;
        }
        if (!FileOperateUtils.createDirectory((String)ksFile.getParent())) {
            log.error("cannot create ks directory for the current iso file.");
            return false;
        }
        return FileContentOperateUtils.replaceTextFileContent((String)template, (String)ksPath, HiCloudImageUpdateUtils.replaceContent(imageUpdate), (LineSeparator)LineSeparator.LINUX);
    }

    private static Map<String, String> replaceContent(ImageUpdate imageUpdate) {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{ip}", imageUpdate.getIp());
        replace.put("{netmask}", imageUpdate.getNetMask());
        replace.put("{gateway}", imageUpdate.getGateway());
        replace.put("{device}", imageUpdate.getNetDevice());
        replace.put("{rootpw}", Crypt.crypt((String)imageUpdate.getRootPassword()));
        replace.put("{paaspw}", Crypt.crypt((String)imageUpdate.getPaasPassword()));
        return replace;
    }

    private static boolean copyFile(String srcPath, String destPath) {
        File destFile = new File(destPath);
        if (!destFile.delete()) {
            log.error("Failed to delete the file {}.", (Object)destFile.getName());
            return false;
        }
        try {
            Files.copy(Paths.get(srcPath, new String[0]), Paths.get(destPath, new String[0]), new CopyOption[0]);
        }
        catch (IOException exception) {
            log.error("Failed to copy the template to the original path. {}", (Object)destFile.getName());
            return false;
        }
        return true;
    }

    private static boolean replaceGrubFile(ImageUpdate imageUpdate, String cacheDir, String toolPath) {
        String templatePath = FilePathValidatorUtils.joinChildPath((String[])new String[]{toolPath, imageUpdate.isArchX86() ? "x86" : "arm", imageUpdate.isArchX86() ? "grub.conf" : "grub.cfg"});
        log.info("Grub File Template Start Replacing.");
        String originConfigPath = imageUpdate.isArchX86() ? FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, "isolinux", "grub.conf"}) : FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, "EFI", "BOOT", "grub.cfg"});
        return HiCloudImageUpdateUtils.copyFile(templatePath, originConfigPath);
    }

    private static boolean replaceIsoLinuxFile(ImageUpdate imageUpdate, String cacheDir, String toolPath) {
        if (!imageUpdate.isArchX86()) {
            return true;
        }
        String templatePath = FilePathValidatorUtils.joinChildPath((String[])new String[]{toolPath, "x86", "isolinux.cfg"});
        String originConfigPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, "isolinux", "isolinux.cfg"});
        return HiCloudImageUpdateUtils.copyFile(templatePath, originConfigPath);
    }

    @Generated
    private HiCloudImageUpdateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

