/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.hicloud.utils;

import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudError;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.exception.DeployHiCloudException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public final class HiCloudPackageFileUtils {
    private static final Pattern PATTERN = Pattern.compile("^HiCloud_.*?_Tool_Any-Any_HicloudAutoInstallTool-OP\\.zip$");
    private static final Pattern GKIT_ISO_PATTERN = Pattern.compile("EulerOS.*\\.iso$");

    public static List<File> getPackageFiles(String packagePath) {
        File file = new File(packagePath);
        if (!file.exists() || !file.isDirectory()) {
            throw new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID);
        }
        Object[] files = file.listFiles();
        if (ArrayUtils.isEmpty((Object[])files)) {
            throw new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID);
        }
        return Arrays.stream(files).filter(File::isFile).collect(Collectors.toList());
    }

    public static List<String> getPackageFiles(String packagePath, Predicate<String> predicate) {
        return HiCloudPackageFileUtils.getPackageFiles(packagePath).stream().map(File::getName).filter(predicate).collect(Collectors.toList());
    }

    public static File getUnzipFile(String packagePath) {
        return HiCloudPackageFileUtils.getPackageFiles(packagePath).stream().filter(file -> PATTERN.matcher(file.getName()).matches()).findFirst().orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
    }

    public static File getVmImageFile(String packagePath) {
        return HiCloudPackageFileUtils.getPackageFiles(packagePath).stream().filter(file -> ConsistencyPattern.isHiCloudVmImageFilePackage((String)file.getName())).findFirst().orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
    }

    public static File getGKitImagePackageFile(String packagePath) {
        return HiCloudPackageFileUtils.getPackageFiles(packagePath).stream().filter(file -> ConsistencyPattern.isHiCloudGKitImageFilePackage((String)file.getName())).findFirst().orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
    }

    public static File getGKitIsoFile(String packagePath) {
        return HiCloudPackageFileUtils.getPackageFiles(packagePath).stream().filter(file -> GKIT_ISO_PATTERN.matcher(file.getName()).matches()).findFirst().orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
    }

    public static File getVmToolPackage(String packagePath) {
        return HiCloudPackageFileUtils.getPackageFiles(packagePath).stream().filter(file -> ConsistencyPattern.isHiCloudConversionScriptPackage((String)file.getName())).findFirst().orElseThrow(() -> new DeployHiCloudException(DeployHiCloudError.PACKAGE_PATH_INVALID));
    }

    @Generated
    private HiCloudPackageFileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

