/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business;

import com.huawei.smartkit.baseserver.report.business.BasicReportGenerator;
import com.huawei.smartkit.baseserver.report.business.excel.ExcelXlsReportGenerator;
import com.huawei.smartkit.baseserver.report.business.excel.ExcelXlsxReportGenerator;
import com.huawei.smartkit.baseserver.report.business.html.HtmlReportGenerator;
import com.huawei.smartkit.baseserver.report.business.word.WordReportGenerator;
import com.huawei.smartkit.baseserver.report.service.ReportType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class ReportGeneratorHelper {
    private final Map<ReportType, Supplier<BasicReportGenerator>> reportGeneratorMaps = new HashMap<ReportType, Supplier<BasicReportGenerator>>();

    private ReportGeneratorHelper() {
        this.reportGeneratorMaps.put(ReportType.WORD, WordReportGenerator::new);
        this.reportGeneratorMaps.put(ReportType.EXCEL_XLS, ExcelXlsReportGenerator::new);
        this.reportGeneratorMaps.put(ReportType.EXCEL_XLSX, ExcelXlsxReportGenerator::new);
        this.reportGeneratorMaps.put(ReportType.HTML, HtmlReportGenerator::new);
    }

    public static ReportGeneratorHelper getHelper() {
        return ReportGeneratorHelperHolder.HELPER;
    }

    public Optional<BasicReportGenerator> createReportGenerator(ReportType reportType) {
        return Optional.ofNullable(this.reportGeneratorMaps.get((Object)reportType)).map(Supplier::get);
    }

    private static final class ReportGeneratorHelperHolder {
        private static final ReportGeneratorHelper HELPER = new ReportGeneratorHelper();

        private ReportGeneratorHelperHolder() {
        }
    }
}

