/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.bo;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ReportBasicData {
    private static final String KEY_HOME_PAGE_REPORT_TIME = "reportTime";
    private static final String KEY_HOME_PAGE_REPORT_NAME = "reportName";
    private static final String KEY_HOME_PAGE_TOOL_VERSION = "toolVersion";
    private static final String KEY_HOME_PAGE_PLUGIN_VERSION = "pluginVersion";
    private String reportName;
    private String toolVersion;
    private String pluginVersion;
    private String templateRootPath;

    public Map<String, Object> getHomePageReportParams() {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put(KEY_HOME_PAGE_REPORT_NAME, this.reportName);
        reportParams.put(KEY_HOME_PAGE_TOOL_VERSION, this.toolVersion);
        reportParams.put(KEY_HOME_PAGE_PLUGIN_VERSION, this.pluginVersion);
        reportParams.put(KEY_HOME_PAGE_REPORT_TIME, LocalDateTime.now().toString());
        return reportParams;
    }

    public boolean checkValid() {
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.reportName, this.toolVersion, this.pluginVersion, this.templateRootPath});
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public String getTemplateRootPath() {
        return this.templateRootPath;
    }

    private ReportBasicData() {
    }

    private ReportBasicData(String reportName, String toolVersion, String pluginVersion, String templateRootPath) {
        this.reportName = reportName;
        this.toolVersion = toolVersion;
        this.pluginVersion = pluginVersion;
        this.templateRootPath = templateRootPath;
    }

    public static class Builder {
        private String reportName;
        private String toolVersion;
        private String pluginVersion;
        private String templateRootPath;

        Builder() {
        }

        public Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public Builder toolVersion(String toolVersion) {
            this.toolVersion = toolVersion;
            return this;
        }

        public Builder pluginVersion(String pluginVersion) {
            this.pluginVersion = pluginVersion;
            return this;
        }

        public Builder templateRootPath(String templateRootPath) {
            this.templateRootPath = templateRootPath;
            return this;
        }

        public ReportBasicData build() {
            return new ReportBasicData(this.reportName, this.toolVersion, this.pluginVersion, this.templateRootPath);
        }

        public String toString() {
            return "ReportBasicData.Builder(reportName=" + this.reportName + ", toolVersion=" + this.toolVersion + ", pluginVersion=" + this.pluginVersion + ", templateRootPath=" + this.templateRootPath + ")";
        }
    }
}

