/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.excel;

import com.huawei.smartkit.baseserver.report.business.excel.ReportCellStyle;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public enum CellStypeEnum implements ReportCellStyle
{
    DEFAULT,
    CENTER{

        @Override
        public CellStyle createCellStyle(Workbook workbook) {
            return CellStypeEnum.createCenterCellStyle(workbook);
        }
    }
    ,
    TITLE{

        @Override
        public CellStyle createCellStyle(Workbook workbook) {
            return CellStypeEnum.createTitleCellStyle(workbook);
        }
    }
    ,
    WARN_NO_PASS{

        @Override
        public CellStyle createCellStyle(Workbook workbook) {
            return CellStypeEnum.createWarnNoPassCellStyle(workbook);
        }
    };


    @Override
    public CellStyle createCellStyle(Workbook workbook) {
        return CellStypeEnum.createDefaultCellStyle(workbook);
    }

    private static Font createCustomFont(Workbook workbook, short colorIdx) {
        Font defaultFont = workbook.createFont();
        defaultFont.setFontName("\u5b8b\u4f53");
        defaultFont.setFontHeightInPoints((short)10);
        defaultFont.setColor(colorIdx);
        return defaultFont;
    }

    private static CellStyle createDefaultCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setFont(CellStypeEnum.createCustomFont(workbook, HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
        cellStyle.setDataFormat(workbook.createDataFormat().getFormat("@"));
        return cellStyle;
    }

    private static CellStyle createCenterCellStyle(Workbook workbook) {
        CellStyle cellStyle = CellStypeEnum.createDefaultCellStyle(workbook);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    private static CellStyle createWarnNoPassCellStyle(Workbook workbook) {
        CellStyle cellStyle = CellStypeEnum.createDefaultCellStyle(workbook);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFont(CellStypeEnum.createCustomFont(workbook, HSSFColor.HSSFColorPredefined.RED.getIndex()));
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    private static CellStyle createTitleCellStyle(Workbook workbook) {
        CellStyle cellStyle = CellStypeEnum.createCenterCellStyle(workbook);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.TEAL.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFont(CellStypeEnum.createCustomFont(workbook, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }
}

