/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.excel;

import com.huawei.smartkit.baseserver.report.business.BasicReportGenerator;
import com.huawei.smartkit.baseserver.report.business.bo.BasePageData;
import com.huawei.smartkit.baseserver.report.business.excel.ReportCell;
import com.huawei.smartkit.baseserver.report.business.excel.ReportCellStyle;
import com.huawei.smartkit.baseserver.report.business.excel.ReportExcelData;
import com.huawei.smartkit.baseserver.report.business.excel.ReportMergeRegion;
import com.huawei.smartkit.baseserver.report.business.excel.ReportRow;
import com.huawei.smartkit.baseserver.report.business.excel.ReportSheet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelXlsReportGenerator
extends BasicReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(ExcelXlsReportGenerator.class);
    private static final Map<Class<?>, BiConsumer<Cell, Object>> cellFuncMaps = new HashMap();

    @Override
    public boolean addTemplatePageData(BasePageData basePageData) {
        if (basePageData instanceof ReportExcelData) {
            return super.addTemplatePageData(basePageData);
        }
        return false;
    }

    private void generateCell(Workbook workbook, Row workRow, ReportCell cell, ReportCellStyle rowCellStyle) {
        ReportCellStyle cellStypeEnum;
        Cell workCell = workRow.createCell(cell.getCol() - 1);
        ReportCellStyle reportCellStyle = cellStypeEnum = cell.getCellStyle() != null ? cell.getCellStyle() : rowCellStyle;
        if (cellStypeEnum != null) {
            workCell.setCellStyle(cellStypeEnum.createCellStyle(workbook));
        }
        Object cellObj = cell.getValue();
        this.findCellValueConsumer(cellObj).accept(workCell, cellObj);
    }

    private BiConsumer<Cell, Object> findCellValueConsumer(Object cellObj) {
        return cellFuncMaps.entrySet().stream().filter(funcEntry -> ((Class)funcEntry.getKey()).isInstance(cellObj)).map(Map.Entry::getValue).findFirst().orElse((cell, obj) -> log.error("cell value is invalid type, obj={}.", cellObj));
    }

    private void generateRow(Workbook workbook, Sheet workSheet, boolean shouldAutoSizeColum, ReportRow row) {
        Row workRow = workSheet.createRow(row.getRow() - 1);
        List<ReportCell> reportCells = row.getCells();
        if (reportCells == null || reportCells.isEmpty()) {
            return;
        }
        ReportCellStyle rowCellStyle = row.getRowStyle();
        reportCells.forEach(cell -> this.generateCell(workbook, workRow, (ReportCell)cell, rowCellStyle));
        if (shouldAutoSizeColum) {
            reportCells.forEach(cell -> workSheet.autoSizeColumn(cell.getCol() - 1));
        }
    }

    private void generateSheet(Workbook workbook, ReportSheet sheet) {
        List<ReportMergeRegion> mergeRegions;
        List<ReportRow> reportRows;
        int rowHeight;
        Sheet workSheet = workbook.createSheet(sheet.getName());
        int colWidth = sheet.getColWidth();
        if (colWidth > 0) {
            workSheet.setDefaultColumnWidth(colWidth);
        }
        if ((rowHeight = sheet.getRowHeight()) > 0) {
            workSheet.setDefaultRowHeightInPoints((float)rowHeight);
        }
        if ((reportRows = sheet.getRows()) != null && !reportRows.isEmpty()) {
            reportRows.forEach(row -> this.generateRow(workbook, workSheet, sheet.isShouldAutoSizeColumn(), (ReportRow)row));
        }
        if ((mergeRegions = sheet.getMergeRegions()) != null && !mergeRegions.isEmpty()) {
            mergeRegions.stream().map(mergeRegion -> new CellRangeAddress(mergeRegion.getFirstRow() - 1, mergeRegion.getLastRow() - 1, mergeRegion.getFirstCol() - 1, mergeRegion.getLastCol() - 1)).forEach(rangeAddress -> this.addMergeRegion(workbook, sheet, workSheet, (CellRangeAddress)rangeAddress));
        }
    }

    private void addMergeRegion(Workbook workbook, ReportSheet sheet, Sheet workSheet, CellRangeAddress rangeAddress) {
        workSheet.addMergedRegion(rangeAddress);
        this.findMergeRegionReportCellStyle(sheet, rangeAddress.getFirstRow() + 1, rangeAddress.getFirstColumn() + 1).map(cellStyle -> cellStyle.createCellStyle(workbook)).ifPresent(cellStyle -> {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)rangeAddress, (Sheet)workSheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)rangeAddress, (Sheet)workSheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)rangeAddress, (Sheet)workSheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)rangeAddress, (Sheet)workSheet);
        });
    }

    private Optional<ReportCellStyle> findMergeRegionReportCellStyle(ReportSheet sheet, int row, int col) {
        List<ReportRow> sheetRows = sheet.getRows();
        if (sheetRows == null || sheetRows.isEmpty()) {
            return Optional.empty();
        }
        Optional<ReportRow> opReportRow = sheetRows.stream().filter(reportRow -> reportRow.getRow() == row).filter(reportRow -> Objects.nonNull(reportRow.getCells())).findFirst();
        return opReportRow.map(reportRow -> reportRow.getCells().stream().filter(cell -> cell.getCol() == col).map(ReportCell::getCellStyle).filter(Objects::nonNull).findFirst().orElse(reportRow.getRowStyle()));
    }

    /*
     * Exception decompiling
     */
    private boolean generateWorkbook(String reportPath, ReportExcelData excelData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean generateReport(String reportPath) {
        return this.pageDatas.stream().filter(pageData -> pageData instanceof ReportExcelData).map(pageData -> (ReportExcelData)pageData).allMatch(workbook -> this.generateWorkbook(reportPath, (ReportExcelData)workbook));
    }

    protected Workbook createWorkbook() {
        return new HSSFWorkbook();
    }

    private /* synthetic */ void lambda$generateWorkbook$21(Workbook workbook, ReportSheet sheet) {
        this.generateSheet(workbook, sheet);
    }

    static {
        cellFuncMaps.put(Boolean.class, (cell, obj) -> cell.setCellValue(((Boolean)obj).booleanValue()));
        cellFuncMaps.put(Number.class, (cell, obj) -> cell.setCellValue(((Number)obj).doubleValue()));
        cellFuncMaps.put(Date.class, (cell, obj) -> cell.setCellValue((Date)obj));
        cellFuncMaps.put(LocalDateTime.class, (cell, obj) -> cell.setCellValue((LocalDateTime)obj));
        cellFuncMaps.put(LocalDate.class, (cell, obj) -> cell.setCellValue((LocalDate)obj));
        cellFuncMaps.put(Calendar.class, (cell, obj) -> cell.setCellValue((Calendar)obj));
        cellFuncMaps.put(RichTextString.class, (cell, obj) -> cell.setCellValue((RichTextString)obj));
        cellFuncMaps.put(String.class, (cell, obj) -> cell.setCellValue((String)obj));
    }
}

