/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.excel;

import com.huawei.smartkit.baseserver.report.business.excel.ReportCellStyle;

public final class ReportCell {
    private int col;
    private Object value;
    private ReportCellStyle cellStyle;

    public static ReportCellBuilder builder() {
        return new ReportCellBuilder();
    }

    public int getCol() {
        return this.col;
    }

    public Object getValue() {
        return this.value;
    }

    public ReportCellStyle getCellStyle() {
        return this.cellStyle;
    }

    private ReportCell() {
    }

    private ReportCell(int col, Object value, ReportCellStyle cellStyle) {
        this.col = col;
        this.value = value;
        this.cellStyle = cellStyle;
    }

    public static class ReportCellBuilder {
        private int col;
        private Object value;
        private ReportCellStyle cellStyle;

        ReportCellBuilder() {
        }

        public ReportCellBuilder col(int col) {
            this.col = col;
            return this;
        }

        public ReportCellBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public ReportCellBuilder cellStyle(ReportCellStyle cellStyle) {
            this.cellStyle = cellStyle;
            return this;
        }

        public ReportCell build() {
            return new ReportCell(this.col, this.value, this.cellStyle);
        }

        public String toString() {
            return "ReportCell.ReportCellBuilder(col=" + this.col + ", value=" + this.value + ", cellStyle=" + this.cellStyle + ")";
        }
    }
}

