/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.excel;

import com.huawei.smartkit.baseserver.report.business.excel.ReportCell;
import com.huawei.smartkit.baseserver.report.business.excel.ReportCellStyle;
import java.util.List;

public class ReportRow {
    private int row;
    private ReportCellStyle rowStyle;
    private List<ReportCell> cells;

    public static ReportRowBuilder builder() {
        return new ReportRowBuilder();
    }

    public int getRow() {
        return this.row;
    }

    public ReportCellStyle getRowStyle() {
        return this.rowStyle;
    }

    public List<ReportCell> getCells() {
        return this.cells;
    }

    private ReportRow() {
    }

    private ReportRow(int row, ReportCellStyle rowStyle, List<ReportCell> cells) {
        this.row = row;
        this.rowStyle = rowStyle;
        this.cells = cells;
    }

    public static class ReportRowBuilder {
        private int row;
        private ReportCellStyle rowStyle;
        private List<ReportCell> cells;

        ReportRowBuilder() {
        }

        public ReportRowBuilder row(int row) {
            this.row = row;
            return this;
        }

        public ReportRowBuilder rowStyle(ReportCellStyle rowStyle) {
            this.rowStyle = rowStyle;
            return this;
        }

        public ReportRowBuilder cells(List<ReportCell> cells) {
            this.cells = cells;
            return this;
        }

        public ReportRow build() {
            return new ReportRow(this.row, this.rowStyle, this.cells);
        }

        public String toString() {
            return "ReportRow.ReportRowBuilder(row=" + this.row + ", rowStyle=" + this.rowStyle + ", cells=" + this.cells + ")";
        }
    }
}

