/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.excel;

import com.huawei.smartkit.baseserver.report.business.excel.ReportMergeRegion;
import com.huawei.smartkit.baseserver.report.business.excel.ReportRow;
import java.util.List;

public final class ReportSheet {
    private String name;
    private int rowHeight;
    private int colWidth;
    private boolean shouldAutoSizeColumn;
    private List<ReportMergeRegion> mergeRegions;
    private List<ReportRow> rows;

    public static ReportSheetBuilder builder() {
        return new ReportSheetBuilder();
    }

    public String getName() {
        return this.name;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getColWidth() {
        return this.colWidth;
    }

    public boolean isShouldAutoSizeColumn() {
        return this.shouldAutoSizeColumn;
    }

    public List<ReportMergeRegion> getMergeRegions() {
        return this.mergeRegions;
    }

    public List<ReportRow> getRows() {
        return this.rows;
    }

    private ReportSheet() {
    }

    private ReportSheet(String name, int rowHeight, int colWidth, boolean shouldAutoSizeColumn, List<ReportMergeRegion> mergeRegions, List<ReportRow> rows) {
        this.name = name;
        this.rowHeight = rowHeight;
        this.colWidth = colWidth;
        this.shouldAutoSizeColumn = shouldAutoSizeColumn;
        this.mergeRegions = mergeRegions;
        this.rows = rows;
    }

    public static class ReportSheetBuilder {
        private String name;
        private int rowHeight;
        private int colWidth;
        private boolean shouldAutoSizeColumn;
        private List<ReportMergeRegion> mergeRegions;
        private List<ReportRow> rows;

        ReportSheetBuilder() {
        }

        public ReportSheetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReportSheetBuilder rowHeight(int rowHeight) {
            this.rowHeight = rowHeight;
            return this;
        }

        public ReportSheetBuilder colWidth(int colWidth) {
            this.colWidth = colWidth;
            return this;
        }

        public ReportSheetBuilder shouldAutoSizeColumn(boolean shouldAutoSizeColumn) {
            this.shouldAutoSizeColumn = shouldAutoSizeColumn;
            return this;
        }

        public ReportSheetBuilder mergeRegions(List<ReportMergeRegion> mergeRegions) {
            this.mergeRegions = mergeRegions;
            return this;
        }

        public ReportSheetBuilder rows(List<ReportRow> rows) {
            this.rows = rows;
            return this;
        }

        public ReportSheet build() {
            return new ReportSheet(this.name, this.rowHeight, this.colWidth, this.shouldAutoSizeColumn, this.mergeRegions, this.rows);
        }

        public String toString() {
            return "ReportSheet.ReportSheetBuilder(name=" + this.name + ", rowHeight=" + this.rowHeight + ", colWidth=" + this.colWidth + ", shouldAutoSizeColumn=" + this.shouldAutoSizeColumn + ", mergeRegions=" + this.mergeRegions + ", rows=" + this.rows + ")";
        }
    }
}

