/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.html;

import com.alibaba.fastjson.JSON;
import com.huawei.smartkit.baseserver.report.business.BasicReportGenerator;
import com.huawei.smartkit.baseserver.report.business.html.PageNode;
import com.huawei.smartkit.baseserver.report.business.html.ReportHtmlData;
import com.huawei.smartkit.baseserver.report.business.html.TreeNode;
import com.huawei.smartkit.baseserver.report.business.utils.FileHelper;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportGenerator
extends BasicReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(HtmlReportGenerator.class);
    private static final String HTML_TEMPLATE_DICTIONARY = "/templates/html/";
    private static final String[] HTML_TEMP_CONST_FILE_DIRS = new String[]{"css", "images", "js"};
    private static final String HTML_TEMPLATE_HOME_PAGE = "home" + File.separator + "homePage.html";
    private static final String HTML_TEMPLATE_SKELETON_PAGE = "index.html";
    private static final String KEY_TEMP_SKELETON_HEAD_PAGES = "headPages";
    private static final String HTML_TEMPLATE_TREE_SKELETON = "tree.html";
    private static final String KEY_TEMP_TREE_SKELETON_NODES = "treeNodes";
    private static final String HTML_TEMPLATE_TREE_SKELETON_FORMAT = "tree_skeleton_%d.html";
    private static final String HTML_TEMPLATE_TREE_PAGE = "page.html";
    private static final String HTML_TEMPLATE_TREE_PAGE_FORMAT = "tree_page_%d.html";
    private static final String KEY_TEMP_TREE_SKELETON_URL = "treeSkeletonUrl";
    private static final String KEY_TEMP_TREE_MAIN_PAGE_URL = "treeMainPageUrl";
    private final Configuration freeMarkerConfiguration = new Configuration(Configuration.VERSION_2_3_31);

    public HtmlReportGenerator() {
        this.freeMarkerConfiguration.setCacheStorage((CacheStorage)new MruCacheStorage(10, 200));
        this.freeMarkerConfiguration.setLocale(Locale.getDefault());
        this.freeMarkerConfiguration.clearEncodingMap();
        this.freeMarkerConfiguration.setEncoding(Locale.CHINESE, StandardCharsets.UTF_8.name());
        this.freeMarkerConfiguration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
    }

    private Optional<FileTemplateLoader> createFileTemplateLoader() {
        try {
            String templateRootPath = this.basicData.getTemplateRootPath();
            if (!StringUtils.isEmpty((CharSequence)templateRootPath)) {
                return Optional.of(new FileTemplateLoader(new File(templateRootPath)));
            }
        }
        catch (IOException e) {
            log.error("create file template loader failed.", (Throwable)e);
        }
        return Optional.empty();
    }

    private void configTemplateLoader() {
        ArrayList<ClassTemplateLoader> loaders = new ArrayList<ClassTemplateLoader>(2);
        loaders.add(new ClassTemplateLoader(this.getClass(), HTML_TEMPLATE_DICTIONARY));
        this.createFileTemplateLoader().ifPresent(loaders::add);
        this.freeMarkerConfiguration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders.toArray(new TemplateLoader[0])));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generateTemplateFile(File dstFile, String templateFile, Map<String, Object> templateDatas) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(dstFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            Template template = this.freeMarkerConfiguration.getTemplate(templateFile, StandardCharsets.UTF_8.name());
            template.process(templateDatas, (Writer)writer);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("write html file {} failed, msg : {}.", (Object)dstFile, (Object)e.getMessage());
            return false;
        }
        catch (TemplateException e) {
            log.error("html template {} invalid, msg : {}.", (Object)templateFile, (Object)e.getMessage());
        }
        return false;
    }

    private String buildRealTreePageUrl(int id, boolean isTreeSkeleton) {
        return String.format(Locale.ROOT, isTreeSkeleton ? HTML_TEMPLATE_TREE_SKELETON_FORMAT : HTML_TEMPLATE_TREE_PAGE_FORMAT, id);
    }

    private List<PageNode> buildIndexPageNodes() {
        return this.pageDatas.stream().filter(pageData -> pageData instanceof ReportHtmlData).map(pageData -> (ReportHtmlData)pageData).map(htmlData -> ((PageNode.PageNodeBuilder)((PageNode.PageNodeBuilder)PageNode.builder().name(htmlData.getPageName())).url(htmlData.hasChildPages() ? this.buildRealTreePageUrl(htmlData.getId(), false) : htmlData.getLinkUrl())).build()).collect(Collectors.toList());
    }

    private boolean generateReportIndexSkeletonPages(String reportPath) {
        if (this.basicData == null || !this.basicData.checkValid()) {
            log.error("not find basic data, data={}.", (Object)this.basicData);
            return false;
        }
        File skeletonFile = new File(reportPath, HTML_TEMPLATE_SKELETON_PAGE);
        FileHelper.createParentDirectories(skeletonFile);
        Map<String, Object> templateMaps = this.basicData.getHomePageReportParams();
        templateMaps.put(KEY_TEMP_SKELETON_HEAD_PAGES, this.buildIndexPageNodes());
        return this.generateTemplateFile(skeletonFile, HTML_TEMPLATE_SKELETON_PAGE, templateMaps);
    }

    private boolean generateReportBasicHomePage(String reportPath) {
        File homePageFile = new File(reportPath, HTML_TEMPLATE_HOME_PAGE);
        FileHelper.createParentDirectories(homePageFile);
        return this.generateTemplateFile(homePageFile, HTML_TEMPLATE_HOME_PAGE, this.basicData.getHomePageReportParams());
    }

    private boolean generateTemplatePage(ReportHtmlData htmlPage, String reportPath) {
        File reportFile = new File(reportPath, htmlPage.getLinkUrl());
        FileHelper.createParentDirectories(reportFile);
        return this.generateTemplateFile(reportFile, htmlPage.getTemplateFile(), htmlPage.getPageDatas());
    }

    private List<TreeNode> buildChildTreeNode(ReportHtmlData htmlData) {
        if (!htmlData.hasChildPages()) {
            return new LinkedList<TreeNode>();
        }
        LinkedList<TreeNode> treeNodes = new LinkedList<TreeNode>();
        htmlData.getChildPages().forEach(page -> treeNodes.add((TreeNode)((TreeNode.TreeNodeBuilder)((TreeNode.TreeNodeBuilder)((TreeNode.TreeNodeBuilder)TreeNode.builder().name(page.getPageName())).url(page.getLinkUrl())).children(this.buildChildTreeNode((ReportHtmlData)page))).build()));
        return treeNodes;
    }

    private boolean generateChildReportHtmlPage(ReportHtmlData htmlData, String reportPath) {
        if (!this.generateTemplatePage(htmlData, reportPath)) {
            log.error("create template page failed. page={}.", (Object)htmlData);
            return false;
        }
        if (!htmlData.hasChildPages()) {
            return true;
        }
        Optional<ReportHtmlData> opFailData = htmlData.getChildPages().stream().filter(childPage -> !this.generateChildReportHtmlPage((ReportHtmlData)childPage, reportPath)).findFirst();
        opFailData.ifPresent(failData -> log.error("create template page failed. page={}.", failData));
        return !opFailData.isPresent();
    }

    private boolean generateTreeSkeletonPage(ReportHtmlData htmlData, String reportPath) {
        List<TreeNode> treeNodes = this.buildChildTreeNode(htmlData);
        HashMap<String, Object> treeDatas = new HashMap<String, Object>();
        treeDatas.put(KEY_TEMP_TREE_SKELETON_NODES, JSON.toJSONString(treeNodes).replace("\"", "\\\""));
        return this.generateTemplateFile(new File(reportPath, this.buildRealTreePageUrl(htmlData.getId(), true)), HTML_TEMPLATE_TREE_SKELETON, treeDatas);
    }

    private boolean generateTreeMainPage(ReportHtmlData htmlData, String reportPath) {
        HashMap<String, Object> pageDatas = new HashMap<String, Object>();
        pageDatas.put(KEY_TEMP_TREE_SKELETON_URL, this.buildRealTreePageUrl(htmlData.getId(), true));
        pageDatas.put(KEY_TEMP_TREE_MAIN_PAGE_URL, htmlData.getLinkUrl());
        return this.generateTemplateFile(new File(reportPath, this.buildRealTreePageUrl(htmlData.getId(), false)), HTML_TEMPLATE_TREE_PAGE, pageDatas);
    }

    private boolean generateTreeNodePages(ReportHtmlData htmlData, String reportPath) {
        if (!this.generateTreeSkeletonPage(htmlData, reportPath)) {
            log.error("create tree skeleton page failed. page={}.", (Object)htmlData);
            return false;
        }
        if (!this.generateTreeMainPage(htmlData, reportPath)) {
            log.error("create tree main page failed. page={}.", (Object)htmlData);
            return false;
        }
        return true;
    }

    private boolean generateReportHtmlPage(ReportHtmlData htmlData, String reportPath) {
        if (!htmlData.hasChildPages()) {
            return this.generateTemplatePage(htmlData, reportPath);
        }
        if (!this.generateTreeNodePages(htmlData, reportPath)) {
            log.error("create tree page failed, page={}.", (Object)htmlData);
        }
        return this.generateChildReportHtmlPage(htmlData, reportPath);
    }

    private void copyTemplateFiles2ReportPath(String reportPath) {
        URL templateUrl = this.getClass().getResource(HTML_TEMPLATE_DICTIONARY);
        if (templateUrl == null) {
            return;
        }
        Stream.of(HTML_TEMP_CONST_FILE_DIRS).forEach(dirName -> FileHelper.copyHtmlResourceFile(new File(templateUrl.getFile(), (String)dirName), new File(reportPath, (String)dirName)));
        log.info("copy html resource to report path successfully.");
    }

    private void initReportGeneratedEnv(String reportPath) {
        FileHelper.createDirectories(reportPath);
        this.configTemplateLoader();
        this.copyTemplateFiles2ReportPath(reportPath);
    }

    @Override
    public boolean generateReport(String reportPath) {
        this.initReportGeneratedEnv(reportPath);
        if (!this.generateReportIndexSkeletonPages(reportPath)) {
            log.warn("generate index skeleton page failed.");
            return false;
        }
        if (!this.generateReportBasicHomePage(reportPath)) {
            log.warn("generate html home page failed.");
            return false;
        }
        if (this.pageDatas.isEmpty()) {
            log.info("this report has not other page.");
            return true;
        }
        return this.pageDatas.stream().filter(pageData -> pageData instanceof ReportHtmlData).map(pageData -> (ReportHtmlData)pageData).allMatch(htmlData -> this.generateReportHtmlPage((ReportHtmlData)htmlData, reportPath));
    }
}

