/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);

    public static void createParentDirectories(File file) {
        try {
            FileUtils.createParentDirectories((File)file);
        }
        catch (IOException e) {
            log.error("make parent dir failed.", (Throwable)e);
        }
    }

    public static void createDirectories(String file) {
        File dirFile = new File(file);
        if (!dirFile.exists()) {
            boolean isMkdirSuccess = new File(file).mkdirs();
            log.info("create dirs [{}] result = {}.", (Object)file, (Object)isMkdirSuccess);
        }
    }

    public static void copyHtmlResExcludeFtl(String srcPath, String dstPath) {
        try {
            FileUtils.copyDirectory((File)new File(srcPath), (File)new File(dstPath), pathname -> !pathname.getName().endsWith("ftl"));
        }
        catch (IOException e) {
            log.error("copy html resource template file exclude ftl failed.", (Throwable)e);
        }
    }

    public static void copyHtmlResourceFile(File srcFile, File dstPath) {
        try {
            if (srcFile.isFile()) {
                FileUtils.copyFile((File)srcFile, (File)new File(dstPath, srcFile.getName()));
            } else {
                FileUtils.copyDirectory((File)srcFile, (File)dstPath);
            }
        }
        catch (IOException e) {
            log.error("copy html resource template file failed.", (Throwable)e);
        }
    }

    private FileHelper() {
    }
}

