/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.business.word;

import com.deepoove.poi.XWPFTemplate;
import com.huawei.smartkit.baseserver.report.business.BasicReportGenerator;
import com.huawei.smartkit.baseserver.report.business.utils.FileHelper;
import com.huawei.smartkit.baseserver.report.business.word.ReportWordData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordReportGenerator
extends BasicReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(WordReportGenerator.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generateOneWord(String reportPath, ReportWordData wordData) {
        File templateFile = new File(this.basicData.getTemplateRootPath(), wordData.getTemplateFile());
        if (!templateFile.exists()) {
            log.error("word template file is not exist, template file = {}.", (Object)templateFile);
            return false;
        }
        File wordFile = new File(reportPath, wordData.getPageName());
        FileHelper.createParentDirectories(wordFile);
        try (XWPFTemplate template = XWPFTemplate.compile((File)templateFile);){
            template.render(wordData.getPageDatas()).writeAndClose(Files.newOutputStream(wordFile.toPath(), new OpenOption[0]));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("word template render failed.", (Throwable)e);
            return false;
        }
    }

    protected boolean generateSpecialFile(String reportPath, ReportWordData reportWordData) {
        return this.generateOneWord(reportPath, reportWordData);
    }

    @Override
    public boolean generateReport(String reportPath) {
        return this.pageDatas.stream().filter(pageData -> pageData instanceof ReportWordData).map(pageData -> (ReportWordData)pageData).allMatch(sheetPageData -> this.generateSpecialFile(reportPath, (ReportWordData)sheetPageData));
    }
}

