/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.service;

import com.huawei.smartkit.baseserver.report.business.bo.BasePageData;
import com.huawei.smartkit.baseserver.report.business.bo.ReportBasicData;
import com.huawei.smartkit.baseserver.report.service.ReportType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ReportData {
    private ReportType reportType;
    private ReportBasicData basicData;
    private List<? extends BasePageData> pageDatas;
    private String reportPath;

    public boolean checkDataValid() {
        if (this.reportType == null || StringUtils.isEmpty((CharSequence)this.reportPath)) {
            return false;
        }
        if (this.basicData == null) {
            return this.reportType == ReportType.EXCEL_XLS || this.reportType == ReportType.EXCEL_XLSX;
        }
        return true;
    }

    ReportData(ReportType reportType, ReportBasicData basicData, List<? extends BasePageData> pageDatas, String reportPath) {
        this.reportType = reportType;
        this.basicData = basicData;
        this.pageDatas = pageDatas;
        this.reportPath = reportPath;
    }

    public static ReportDataBuilder builder() {
        return new ReportDataBuilder();
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public ReportBasicData getBasicData() {
        return this.basicData;
    }

    public List<? extends BasePageData> getPageDatas() {
        return this.pageDatas;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public ReportData setReportType(ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    public ReportData setBasicData(ReportBasicData basicData) {
        this.basicData = basicData;
        return this;
    }

    public ReportData setPageDatas(List<? extends BasePageData> pageDatas) {
        this.pageDatas = pageDatas;
        return this;
    }

    public ReportData setReportPath(String reportPath) {
        this.reportPath = reportPath;
        return this;
    }

    public static class ReportDataBuilder {
        private ReportType reportType;
        private ReportBasicData basicData;
        private List<? extends BasePageData> pageDatas;
        private String reportPath;

        ReportDataBuilder() {
        }

        public ReportDataBuilder reportType(ReportType reportType) {
            this.reportType = reportType;
            return this;
        }

        public ReportDataBuilder basicData(ReportBasicData basicData) {
            this.basicData = basicData;
            return this;
        }

        public ReportDataBuilder pageDatas(List<? extends BasePageData> pageDatas) {
            this.pageDatas = pageDatas;
            return this;
        }

        public ReportDataBuilder reportPath(String reportPath) {
            this.reportPath = reportPath;
            return this;
        }

        public ReportData build() {
            return new ReportData(this.reportType, this.basicData, this.pageDatas, this.reportPath);
        }

        public String toString() {
            return "ReportData.ReportDataBuilder(reportType=" + (Object)((Object)this.reportType) + ", basicData=" + this.basicData + ", pageDatas=" + this.pageDatas + ", reportPath=" + this.reportPath + ")";
        }
    }
}

