/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.baseserver.report.service.impl;

import com.huawei.smartkit.baseserver.report.business.BasicReportGenerator;
import com.huawei.smartkit.baseserver.report.business.ReportGeneratorHelper;
import com.huawei.smartkit.baseserver.report.service.ReportData;
import com.huawei.smartkit.baseserver.report.service.ReportGenerator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportGeneratorImpl
implements ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(ReportGeneratorImpl.class);

    @Override
    public boolean generateReport(ReportData reportData) {
        if (reportData == null || !reportData.checkDataValid()) {
            log.error("generate report data is invalid.");
            return false;
        }
        Optional<BasicReportGenerator> opGenerator = ReportGeneratorHelper.getHelper().createReportGenerator(reportData.getReportType());
        if (!opGenerator.isPresent()) {
            log.error("generate report type is unsupported. type={}.", (Object)reportData.getReportType());
            return false;
        }
        BasicReportGenerator generator = opGenerator.get();
        generator.setBasicData(reportData.getBasicData());
        if (reportData.getPageDatas() != null) {
            reportData.getPageDatas().forEach(generator::addTemplatePageData);
        }
        return generator.generateReport(reportData.getReportPath());
    }
}

