/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.dto;

import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.bpm.engine.BpmnExtension;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class ProcessActivity {
    private String id;
    private String name;
    private String activityInstanceId;
    private String processInstanceId;
    private ProcessStatus status;
    private int progress;
    private List<ProcessActivity> children;
    private String displayName;
    private Map business = new HashMap();
    private Map<String, Object> extensions = new HashMap<String, Object>();

    public static ProcessActivity fromRepositoryActivity(ActivityImpl activity) {
        ProcessActivity processActivity = new ProcessActivity();
        processActivity.setId(activity.getId());
        processActivity.setName(activity.getName());
        processActivity.setStatus(ProcessStatus.NO_START);
        if (!activity.getActivities().isEmpty()) {
            processActivity.setChildren(ProcessActivity.transChildActivity(activity));
        }
        processActivity.setExtensions(BpmnExtension.getActivityExtensionProperties(activity.getProperties()));
        return processActivity;
    }

    private static List<ProcessActivity> transChildActivity(ActivityImpl activity) {
        return activity.getActivities().stream().filter(item -> BpmnExtension.isDisplayActivity(item.getProperties())).map(ProcessActivity::fromRepositoryActivity).collect(Collectors.toList());
    }

    public static ProcessActivity fromHistoryActivity(HistoricActivityInstanceEntity activity) {
        ProcessActivity processActivity = new ProcessActivity();
        processActivity.setId(activity.getActivityId());
        processActivity.setName(activity.getActivityName());
        processActivity.setStatus(ProcessStatus.from(activity.getActivityInstanceState()));
        processActivity.setActivityInstanceId(activity.getId());
        processActivity.setProcessInstanceId(activity.getProcessInstanceId());
        return processActivity;
    }

    public ProcessActivity updateVariables(Map<String, Object> variables) {
        this.business = (Map)ObjectMapperUtils.transKey(variables, Map.class, (String)"activityResult", Collections.emptyMap());
        if (!ProcessStatus.needMergeStatus(this.status)) {
            return this;
        }
        Map statusMaps = (Map)ObjectMapperUtils.transKey(variables, Map.class, (String)"activityStatus", Collections.emptyMap());
        if (statusMaps.containsKey("activityStatus")) {
            this.status = ProcessStatus.of((String)statusMaps.get("activityStatus"), ProcessStatus.RUNNING);
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public int getProgress() {
        return this.progress;
    }

    public List<ProcessActivity> getChildren() {
        return this.children;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map getBusiness() {
        return this.business;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setStatus(ProcessStatus status) {
        this.status = status;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setChildren(List<ProcessActivity> children) {
        this.children = children;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setBusiness(Map business) {
        this.business = business;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }
}

