/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.dto;

import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.bpm.engine.BpmnExtension;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceDto {
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceDto.class);
    private String id;
    private String name;
    private String type;
    private ProcessStatus status;
    private boolean readOnly;
    private int progress;
    private String errMsg;
    private int remainTime;
    private long createTime;
    private long startTime;
    private long durationTime;
    private long endTime;
    private String workPath;
    private Object processConfig;

    public static ProcessInstanceDto from(HistoricProcessInstance instance) {
        ProcessInstanceDto processInstanceDto = new ProcessInstanceDto();
        processInstanceDto.setId(instance.getId());
        processInstanceDto.setName(instance.getBusinessKey());
        processInstanceDto.setType(instance.getProcessDefinitionKey());
        processInstanceDto.setStatus(ProcessStatus.from(instance.getState()));
        processInstanceDto.setCreateTime(instance.getStartTime().getTime());
        if (instance.getDurationInMillis() != null) {
            processInstanceDto.setDurationTime(instance.getDurationInMillis() / 1000L);
        } else {
            processInstanceDto.setDurationTime(BpmnExtension.calDurationTime(instance.getStartTime().getTime()));
        }
        if (instance.getEndTime() != null) {
            processInstanceDto.setEndTime(instance.getEndTime().getTime());
        }
        return processInstanceDto;
    }

    public ProcessInstanceDto updateVariable(Map<String, Object> variables) {
        if (this.status == ProcessStatus.RUNNING || this.status == ProcessStatus.PAUSE) {
            this.status = (ProcessStatus)((Object)variables.getOrDefault("status", (Object)ProcessStatus.RUNNING));
        }
        this.startTime = (Long)ObjectMapperUtils.transKey(variables, Long.class, (String)"startTime", (Object)this.startTime);
        if (this.endTime == 0L) {
            this.endTime = (Long)ObjectMapperUtils.transKey(variables, Long.class, (String)"endTime", (Object)this.endTime);
        }
        this.processConfig = variables.getOrDefault("context", "");
        return this;
    }

    public ProcessInstanceDto updateReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ProcessInstanceDto updateProgress(int progress) {
        this.progress = progress;
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatus(ProcessStatus status) {
        this.status = status;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setRemainTime(int remainTime) {
        this.remainTime = remainTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setDurationTime(long durationTime) {
        this.durationTime = durationTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setWorkPath(String workPath) {
        this.workPath = workPath;
    }

    public void setProcessConfig(Object processConfig) {
        this.processConfig = processConfig;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getRemainTime() {
        return this.remainTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getDurationTime() {
        return this.durationTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getWorkPath() {
        return this.workPath;
    }

    public Object getProcessConfig() {
        return this.processConfig;
    }
}

