/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.engine;

import com.huawei.yinglong.bpm.engine.ActivityTime;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public enum Activity {
    QUERY_FC_ENV_CLEAN("queryFcCleanEvnDetail", 1, 1),
    QUERY_ULTRA_VR("queryUltraVRDeployDetail", 2, 1),
    QUERY_EBACK_UP("queryEBackupDeployDetail", 2, 1),
    START_HICOUD("startHiCloudVmDeploy", 3, 1),
    QUERY_HICOUD("queryHiCloudProgress", 3, 2),
    START_DME_VM_DEPLOY("startDmeVmDeploy", 3, 3),
    QUERY_EDME("queryDmeDeployDetail", 3, 4),
    START_DAYU("startDayuVmDeploy", 3, 5),
    QUERY_DAYU("queryDayuProgress", 3, 6);

    private final String id;
    private final int group;
    private final int order;

    public static Optional<Activity> of(String activityId) {
        return Arrays.stream(Activity.values()).filter(activity -> activity.id.equalsIgnoreCase(activityId)).findFirst();
    }

    public boolean canStart(List<ActivityTime> activityTimes, Map activityCondition) {
        return activityTimes.stream().allMatch(other -> this.canStart((ActivityTime)other, activityCondition));
    }

    private boolean canStart(ActivityTime other, Map activityCondition) {
        if (this.id.contains("query") || this.equals((Object)other.getActivity()) || this.isBefore(other.getActivity())) {
            return true;
        }
        if (!((Boolean)ObjectMapperUtils.transKey((Map)activityCondition, Boolean.class, (String)other.getActivity().getId(), (Object)false)).booleanValue()) {
            return true;
        }
        if (this.group > other.getActivity().getGroup()) {
            return other.hasEnd();
        }
        if (!this.needWait(other.getActivity())) {
            return true;
        }
        return other.hasStart() && other.getStartTime().plusMinutes(20L).isBefore(LocalDateTime.now());
    }

    private boolean isBefore(Activity activity) {
        return this.group < activity.getGroup() || this.order < activity.getOrder();
    }

    private boolean needWait(Activity otherActivity) {
        if (this.group < 3) {
            return false;
        }
        if (!this.id.startsWith("start") || !otherActivity.getId().startsWith("start")) {
            return false;
        }
        return this.order > otherActivity.getOrder();
    }

    private Activity(String id, int group, int order) {
        this.id = id;
        this.group = group;
        this.order = order;
    }

    public String getId() {
        return this.id;
    }

    public int getGroup() {
        return this.group;
    }

    public int getOrder() {
        return this.order;
    }
}

