/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.engine;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.engine.impl.core.model.Properties;
import org.camunda.bpm.engine.impl.core.model.PropertyKey;

public class BpmnExtension {
    private static final String ESTIMATED_DURATION = "estimatedDuration";
    private static final String ACTIVITY_CONDITION = "condition";
    private static final List<String> DISPLAY_ACTIVITY_TYPES = Arrays.asList("subProcess", "serviceTask", "multiInstanceBody");
    private static final String SERVICE_TASK_TYPE = "serviceTask";

    public static boolean isDisplayActivity(Properties properties) {
        Map<String, Object> extensionProperties = BpmnExtension.getActivityExtensionProperties(properties);
        String type = (String)BpmnExtension.getPropertyValue(properties, "type");
        if (!BpmnExtension.isDisplayActivity(type)) {
            return false;
        }
        if (extensionProperties == null || extensionProperties.get(ACTIVITY_CONDITION) == null) {
            return true;
        }
        return "true".equals(extensionProperties.get(ACTIVITY_CONDITION));
    }

    public static boolean isServiceTaskActivity(Properties properties) {
        String type = (String)BpmnExtension.getPropertyValue(properties, "type");
        return Objects.equals(type, SERVICE_TASK_TYPE);
    }

    public static boolean isDisplayActivity(String activityType) {
        return DISPLAY_ACTIVITY_TYPES.contains(activityType);
    }

    public static int getEstimatedDuration(Properties properties) {
        Map<String, Object> extensionProperties = BpmnExtension.getActivityExtensionProperties(properties);
        if (extensionProperties == null || extensionProperties.get(ESTIMATED_DURATION) == null) {
            return 1;
        }
        return Integer.parseInt((String)extensionProperties.get(ESTIMATED_DURATION));
    }

    public static Map<String, Object> getActivityExtensionProperties(Properties properties) {
        return (Map)properties.get(new PropertyKey("extensionProperties"));
    }

    private static Object getPropertyValue(Properties properties, String key) {
        return properties.get(new PropertyKey(key));
    }

    public static long calDurationTime(Long startTime) {
        return (System.currentTimeMillis() - startTime) / 1000L;
    }
}

