/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.engine;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.bpm.engine.Activity;
import com.huawei.yinglong.bpm.engine.ActivityTime;
import com.huawei.yinglong.bpm.util.CryptUtil;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CamundaContextServiceImpl
implements BpmContextService {
    private static final Logger log = LoggerFactory.getLogger(CamundaContextServiceImpl.class);
    private final RuntimeService runtimeService;
    private final BpmCryptService cryptService;

    Map<String, Object> getParams(ProcessConfig processConfig) {
        Map<String, Object> business = processConfig.getBusiness();
        log.info("get params with encrypt password");
        return CryptUtil.deepCopyMaps(business);
    }

    @Override
    public <T> T getContext(String executionId, Class<T> clazz) {
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        return (T)ObjectMapperUtils.transObject(CryptUtil.decryptDirectBusiness(this.cryptService, processConfig), clazz, null);
    }

    @Override
    public <T> T getContextWithoutDecrypt(String executionId, Class<T> clazz) {
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        return (T)ObjectMapperUtils.transObject(this.getParams(processConfig), clazz, null);
    }

    @Override
    public <T> T getContext(String executionId, Class<T> clazz, String key, T defaultVal) {
        return (T)ObjectMapperUtils.transObject((Object)this.runtimeService.getVariable(executionId, key), clazz, defaultVal);
    }

    @Override
    public void updateActivityResult(String executionId, ActivityResult result) {
        this.runtimeService.setVariableLocal(executionId, "activityResult", (Object)result);
    }

    @Override
    @Deprecated
    public void notifyInvocationFinished(ExternalTask task) {
        this.runtimeService.setVariable(task.getExecutionId(), "status", (Object)ProcessStatus.FINISHED);
    }

    @Override
    public void notifyInvocationFinished(ExternalTask task, ExternalTaskService externalTaskService) {
        this.updateActivityStatus(task, ProcessStatus.SUCCEED);
        externalTaskService.complete(task);
    }

    @Override
    public List<ActivityTime> getActivityTimes(ExternalTask task) {
        Object activityTimes = this.runtimeService.getVariable(task.getExecutionId(), "activityTime");
        if (Objects.nonNull(activityTimes)) {
            return JsonUtils.toList((String)activityTimes.toString(), ActivityTime.class);
        }
        Object conditionVar = this.runtimeService.getVariable(task.getExecutionId(), "conditionVar");
        return this.getActivityTimeList(conditionVar);
    }

    List<ActivityTime> getActivityTimeList(Object conditionVar) {
        if (Objects.isNull(conditionVar)) {
            return Collections.emptyList();
        }
        Map conditionMaps = JsonUtils.toMap((String)JsonUtils.toJson((Object)conditionVar), String.class, Boolean.class);
        return Arrays.stream(Activity.values()).filter(activity -> MapUtils.emptyIfNull((Map)conditionMaps).getOrDefault(activity.getId(), false)).map(ActivityTime::new).collect(Collectors.toList());
    }

    @Override
    public void notifyInvocationFailed(ExternalTask task, ExternalTaskService externalTaskService) {
        this.notifyInvocationFailed(task, externalTaskService, ResourceUtils.getString((String)"task.common.failed", (Object[])new Object[]{task.getExecutionId(), task.getActivityId()}));
    }

    @Override
    public void notifyInvocationPaused(ExternalTask task, ExternalTaskService externalTaskService) {
        log.error("Activity: {} execute pause, id: {}", (Object)task.getActivityId(), (Object)task.getActivityInstanceId());
        this.updateActivityStatus(task, ProcessStatus.PAUSE);
        externalTaskService.handleFailure(task.getId(), ResourceUtils.getString((String)"task.common.paused", (Object[])new Object[]{task.getExecutionId(), task.getActivityId()}), "", 0, 0L);
    }

    @Override
    public void notifyInvocationFailed(ExternalTask task, ExternalTaskService externalTaskService, String errMsg) {
        log.error("Activity: {} execute failed, err msg: {}, id: {}", new Object[]{task.getActivityId(), errMsg, task.getActivityInstanceId()});
        this.updateActivityStatus(task, ProcessStatus.FAILED);
        this.runtimeService.setVariable(task.getExecutionId(), "endTime", (Object)System.currentTimeMillis());
        externalTaskService.handleFailure(task.getId(), errMsg, "", 0, 0L);
    }

    @Override
    public void updateActivityStatus(ExternalTask task, ProcessStatus status) {
        if (status.isEnd()) {
            this.setFinishTime(task);
        }
        Object result = ((ActivityResult.ActivityResultBuilder)ActivityResult.builder().activityStatus(status)).build();
        this.runtimeService.setVariableLocal(task.getExecutionId(), "activityStatus", result);
        this.runtimeService.setVariableLocal(task.getExecutionId(), "pause", (Object)(status == ProcessStatus.PAUSE ? 1 : 0));
    }

    @Override
    public void setProgress(String executionId, int progress) {
        this.runtimeService.setVariable(executionId, "progress", (Object)progress);
    }

    @Override
    public void setStatus(String executionId, ProcessStatus status) {
        this.runtimeService.setVariable(executionId, "status", (Object)status);
    }

    @Override
    public void setStartTime(ExternalTask task) {
        Activity.of(task.getActivityId()).ifPresent(activity -> this.updateActivityTime((Activity)((Object)activity), task, true));
    }

    private void setFinishTime(ExternalTask task) {
        Activity.of(task.getActivityId()).ifPresent(activity -> this.updateActivityTime((Activity)((Object)activity), task, false));
    }

    private void updateActivityTime(Activity activity, ExternalTask task, boolean isStart) {
        log.info("Update Activity {} {} time", (Object)activity, (Object)(isStart ? "start" : "finish"));
        List<ActivityTime> activityTimes = this.getActivityTimes(task);
        activityTimes.stream().filter(activityTime -> activity.equals((Object)activityTime.getActivity())).findFirst().ifPresent(activityTime -> activityTime.update(isStart));
        this.runtimeService.setVariable(task.getExecutionId(), "activityTime", (Object)JsonUtils.toJson(activityTimes));
    }

    public CamundaContextServiceImpl(RuntimeService runtimeService, BpmCryptService cryptService) {
        this.runtimeService = runtimeService;
        this.cryptService = cryptService;
    }
}

