/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.engine;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.bpm.engine.Activity;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExternalTaskDecorator {
    private static final Logger log = LoggerFactory.getLogger(ExternalTaskDecorator.class);
    private final BpmContextService bpmContextService;
    private final RuntimeService runtimeService;

    public ExternalTaskHandler process(ExternalTaskHandler externalTaskHandler) {
        return this.process(externalTaskHandler, null);
    }

    public ExternalTaskHandler process(ExternalTaskHandler externalTaskHandler, ExternalTaskHandler retryHandler) {
        return (externalTask, externalTaskService) -> {
            try {
                if (!this.checkNeedExecuted(externalTask)) {
                    log.info("no need execute activity {}", (Object)externalTask.getActivityId());
                    this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                    return;
                }
                if (this.processRetryHandler(retryHandler, externalTask, externalTaskService)) {
                    return;
                }
                if (!this.checkCanStart(externalTask)) {
                    return;
                }
                log.info("enter to process activity: {}, process instance id:{}, process define: {}", new Object[]{externalTask.getActivityId(), externalTask.getProcessInstanceId(), externalTask.getProcessDefinitionKey()});
                this.bpmContextService.updateActivityStatus(externalTask, ProcessStatus.RUNNING);
                this.bpmContextService.setStartTime(externalTask);
                externalTaskHandler.execute(externalTask, externalTaskService);
            }
            catch (Exception e) {
                log.error("activity execute error", (Throwable)e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    private boolean checkCanStart(ExternalTask task) {
        return Activity.of(task.getActivityId()).map(activity -> activity.canStart(this.bpmContextService.getActivityTimes(task), this.getActivityCondition(task))).orElse(true);
    }

    private boolean processRetryHandler(ExternalTaskHandler retryHandler, ExternalTask externalTask, ExternalTaskService externalTaskService) {
        if (retryHandler == null) {
            return false;
        }
        String activityCmd = (String)this.runtimeService.getVariable(externalTask.getExecutionId(), externalTask.getActivityInstanceId());
        if (!Objects.equals(activityCmd, "retry")) {
            return false;
        }
        this.bpmContextService.updateActivityStatus(externalTask, ProcessStatus.RUNNING);
        log.info("begin to execute retry handler for activity {}", (Object)externalTask.getActivityId());
        this.runtimeService.setVariable(externalTask.getExecutionId(), externalTask.getActivityInstanceId(), (Object)"");
        retryHandler.execute(externalTask, externalTaskService);
        return true;
    }

    private boolean checkNeedExecuted(ExternalTask task) {
        return (Boolean)ObjectMapperUtils.transKey((Map)this.getActivityCondition(task), Boolean.class, (String)task.getActivityId(), (Object)true);
    }

    private Map getActivityCondition(ExternalTask task) {
        return (Map)ObjectMapperUtils.transKey((Map)task.getAllVariables(), Map.class, (String)"conditionVar", new HashMap());
    }

    public ExternalTaskDecorator(BpmContextService bpmContextService, RuntimeService runtimeService) {
        this.bpmContextService = bpmContextService;
        this.runtimeService = runtimeService;
    }
}

