/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.base.util;

import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathUtils {
    private static final Logger log = LoggerFactory.getLogger(FilePathUtils.class);

    public static String getCanonicalPath(File file) {
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("getCanonicalPath has IOException");
        }
        return path;
    }

    public static String getDefaultReportPath() {
        String envPath = System.getenv("jsonSceneResultPath");
        if (envPath == null) {
            return "";
        }
        String canonicalPath = FilePathUtils.getCanonicalPath(new File(envPath));
        if (FilePathUtils.validatePath(canonicalPath)) {
            return canonicalPath;
        }
        return "";
    }

    private static boolean validatePath(String canonicalPath) {
        return FilePathUtils.hasMatchStr(canonicalPath, "([^\\w-\\s]+)|(\\s{2,})");
    }

    public static boolean hasMatchStr(String source, String regex) {
        String result = FilePathUtils.findMatchStr(source, regex, 0);
        return result != null && !result.isEmpty();
    }

    public static String findMatchStr(String source, String regex, int group) {
        String regexNormalized = Normalizer.normalize(regex, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile(regexNormalized);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return "";
    }
}

